/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.SignalBlock;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.track.BezierConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class Navigation {
    public Train train;
    public GlobalStation destination;
    public double distanceToDestination;
    public double distanceStartedAt;
    public boolean destinationBehindTrain;
    public boolean announceArrival;
    List<Couple<TrackNode>> currentPath;
    private TravellingPoint signalScout;
    public Pair<UUID, Boolean> waitingForSignal;
    private Map<UUID, Pair<SignalBoundary, Boolean>> waitingForChainedGroups;
    public double distanceToSignal;
    public int ticksWaitingForSignal;

    public Navigation(Train train) {
        this.train = train;
        this.currentPath = new ArrayList<Couple<TrackNode>>();
        this.signalScout = new TravellingPoint();
        this.waitingForChainedGroups = new HashMap<UUID, Pair<SignalBoundary, Boolean>>();
    }

    public void tick(class_1937 level) {
        double targetSpeed;
        double maxApproachSpeed;
        double speedRelativeToStation;
        if (this.destination == null) {
            return;
        }
        if (!this.train.runtime.paused) {
            boolean frontDriver = this.train.hasForwardConductor();
            boolean backDriver = this.train.hasBackwardConductor();
            if (this.destinationBehindTrain && !backDriver) {
                if (frontDriver) {
                    this.train.status.missingCorrectConductor();
                } else {
                    this.train.status.missingConductor();
                }
                this.cancelNavigation();
                return;
            }
            if (!this.destinationBehindTrain && !frontDriver) {
                this.train.status.missingConductor();
                this.cancelNavigation();
                return;
            }
            this.train.status.foundConductor();
        }
        this.destination.reserveFor(this.train);
        double acceleration = this.train.acceleration();
        double brakingDistance = this.train.speed * this.train.speed / (2.0 * acceleration);
        double speedMod = this.destinationBehindTrain ? -1.0 : 1.0;
        double preDepartureLookAhead = this.train.getCurrentStation() != null ? 4.5 : 0.0;
        double distanceToNextCurve = -1.0;
        if (this.train.graph != null) {
            TravellingPoint leadingPoint;
            if (this.waitingForSignal != null && this.currentSignalResolved()) {
                UUID signalId = this.waitingForSignal.getFirst();
                SignalBoundary signal = this.train.graph.getPoint(EdgePointType.SIGNAL, signalId);
                if (signal != null && signal.types.get(this.waitingForSignal.getSecond()) == SignalBlock.SignalType.CROSS_SIGNAL) {
                    this.waitingForChainedGroups.clear();
                }
                this.waitingForSignal = null;
            }
            TravellingPoint travellingPoint = leadingPoint = !this.destinationBehindTrain ? this.train.carriages.get(0).getLeadingPoint() : this.train.carriages.get(this.train.carriages.size() - 1).getTrailingPoint();
            if (this.waitingForSignal == null) {
                this.distanceToSignal = Double.MAX_VALUE;
                this.ticksWaitingForSignal = 0;
            }
            if (this.distanceToSignal > 0.0625) {
                MutableDouble curveDistanceTracker = new MutableDouble(-1.0);
                this.signalScout.node1 = leadingPoint.node1;
                this.signalScout.node2 = leadingPoint.node2;
                this.signalScout.edge = leadingPoint.edge;
                this.signalScout.position = leadingPoint.position;
                double brakingDistanceNoFlicker = brakingDistance + 3.0 - brakingDistance % 3.0;
                double scanDistance = class_3532.method_15350((double)brakingDistanceNoFlicker, (double)preDepartureLookAhead, (double)this.distanceToDestination);
                MutableDouble crossSignalDistanceTracker = new MutableDouble(-1.0);
                MutableObject trackingCrossSignal = new MutableObject(null);
                this.waitingForChainedGroups.clear();
                this.signalScout.travel(this.train.graph, (this.distanceToDestination + 50.0) * speedMod, this.controlSignalScout(), (distance, couple) -> {
                    boolean occupied;
                    boolean crossSignalTracked;
                    boolean bl = crossSignalTracked = trackingCrossSignal.getValue() != null;
                    if (!crossSignalTracked && distance > scanDistance) {
                        return true;
                    }
                    Couple nodes = (Couple)couple.getSecond();
                    TrackEdgePoint boundary = (TrackEdgePoint)couple.getFirst();
                    if (boundary == this.destination && ((GlobalStation)boundary).canApproachFrom((TrackNode)nodes.getSecond())) {
                        return true;
                    }
                    if (!(boundary instanceof SignalBoundary)) {
                        return false;
                    }
                    SignalBoundary signal = (SignalBoundary)boundary;
                    UUID entering = signal.getGroup((TrackNode)nodes.getSecond());
                    SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(entering);
                    if (signalEdgeGroup == null) {
                        return false;
                    }
                    boolean primary = entering.equals(signal.groups.getFirst());
                    boolean crossSignal = signal.types.get(primary) == SignalBlock.SignalType.CROSS_SIGNAL;
                    boolean bl2 = occupied = !this.train.manualTick && (signal.isForcedRed((TrackNode)nodes.getSecond()) || signalEdgeGroup.isOccupiedUnless(this.train));
                    if (!crossSignalTracked) {
                        if (crossSignal) {
                            trackingCrossSignal.setValue(Pair.of(boundary.id, primary));
                            crossSignalDistanceTracker.setValue((Number)distance);
                            this.waitingForChainedGroups.put(entering, Pair.of(signal, primary));
                        }
                        if (occupied) {
                            this.waitingForSignal = Pair.of(boundary.id, primary);
                            this.distanceToSignal = distance;
                            if (!crossSignal) {
                                return true;
                            }
                        }
                        if (!occupied && !crossSignal && distance < this.distanceToSignal + 0.25 && distance < brakingDistanceNoFlicker) {
                            signalEdgeGroup.reserved = signal;
                        }
                        return false;
                    }
                    if (crossSignalTracked) {
                        this.waitingForChainedGroups.put(entering, Pair.of(signal, primary));
                        if (occupied) {
                            this.waitingForSignal = (Pair)trackingCrossSignal.getValue();
                            this.distanceToSignal = crossSignalDistanceTracker.doubleValue();
                            if (!crossSignal) {
                                return true;
                            }
                        }
                        if (!crossSignal) {
                            if (distance < this.distanceToSignal + 0.25) {
                                trackingCrossSignal.setValue(null);
                                this.reserveChain();
                                return false;
                            }
                            return true;
                        }
                    }
                    return false;
                }, (distance, edge) -> {
                    BezierConnection turn = edge.getTurn();
                    double vDistance = Math.abs(((class_243)turn.starts.getFirst()).field_1351 - ((class_243)turn.starts.getSecond()).field_1351);
                    if (turn != null && vDistance > 0.0625 && ((class_243)turn.axes.getFirst()).method_18805(1.0, 0.0, 1.0).method_1022(((class_243)turn.axes.getSecond()).method_18805(1.0, 0.0, 1.0).method_1021(-1.0)) < 0.015625 && vDistance / turn.getLength() < (double)0.225f) {
                        return;
                    }
                    float current = curveDistanceTracker.floatValue();
                    if (current == -1.0f || distance < (double)current) {
                        curveDistanceTracker.setValue((Number)distance);
                    }
                });
                if (trackingCrossSignal.getValue() != null && this.waitingForSignal == null) {
                    this.reserveChain();
                }
                distanceToNextCurve = curveDistanceTracker.floatValue();
            } else {
                ++this.ticksWaitingForSignal;
            }
        }
        double targetDistance = this.waitingForSignal != null ? this.distanceToSignal : this.distanceToDestination;
        if ((targetDistance += 0.25) > 0.03125 && this.train.getCurrentStation() != null) {
            if (this.waitingForSignal != null && this.distanceToSignal < preDepartureLookAhead) {
                ++this.ticksWaitingForSignal;
                return;
            }
            this.train.leaveStation();
        }
        this.train.currentlyBackwards = this.destinationBehindTrain;
        if (targetDistance < -10.0) {
            this.cancelNavigation();
            return;
        }
        if (targetDistance - Math.abs(this.train.speed) < 0.03125) {
            this.train.speed = Math.max(targetDistance, 0.03125) * speedMod;
            return;
        }
        this.train.burnFuel(level);
        double topSpeed = this.train.maxSpeed();
        if (targetDistance < 10.0 && (speedRelativeToStation = this.train.speed * speedMod) > (maxApproachSpeed = topSpeed * (targetDistance / 10.0))) {
            this.train.speed += (maxApproachSpeed - Math.abs(this.train.speed)) * 0.5 * speedMod;
            return;
        }
        double turnTopSpeed = Math.min(topSpeed *= this.train.throttle, (double)this.train.maxTurnSpeed());
        double d = targetSpeed = targetDistance > brakingDistance ? topSpeed * speedMod : 0.0;
        if (distanceToNextCurve != -1.0) {
            double targetTurnSpeed;
            double slowingDistance = brakingDistance - turnTopSpeed * turnTopSpeed / (2.0 * acceleration);
            double d2 = targetTurnSpeed = distanceToNextCurve > slowingDistance ? topSpeed * speedMod : turnTopSpeed * speedMod;
            if (Math.abs(targetTurnSpeed) < Math.abs(targetSpeed)) {
                targetSpeed = targetTurnSpeed;
            }
        }
        this.train.targetSpeed = targetSpeed;
        this.train.approachTargetSpeed(1.0f);
    }

    private void reserveChain() {
        this.train.reservedSignalBlocks.addAll(this.waitingForChainedGroups.keySet());
        this.waitingForChainedGroups.forEach((groupId, boundary) -> {
            SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(groupId);
            if (signalEdgeGroup != null) {
                signalEdgeGroup.reserved = (SignalBoundary)boundary.getFirst();
            }
        });
        this.waitingForChainedGroups.clear();
    }

    private boolean currentSignalResolved() {
        if (this.train.manualTick) {
            return true;
        }
        if (this.distanceToDestination < 0.5) {
            return true;
        }
        SignalBoundary signal = this.train.graph.getPoint(EdgePointType.SIGNAL, this.waitingForSignal.getFirst());
        if (signal == null) {
            return true;
        }
        if (signal.types.get(this.waitingForSignal.getSecond()) == SignalBlock.SignalType.CROSS_SIGNAL) {
            for (Map.Entry<UUID, Pair<SignalBoundary, Boolean>> entry : this.waitingForChainedGroups.entrySet()) {
                Pair<SignalBoundary, Boolean> boundary = entry.getValue();
                SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(entry.getKey());
                if (signalEdgeGroup == null) {
                    this.waitingForSignal.setFirst(null);
                    return true;
                }
                if (boundary.getFirst().isForcedRed(boundary.getSecond())) {
                    this.train.reservedSignalBlocks.clear();
                    return false;
                }
                if (!signalEdgeGroup.isOccupiedUnless(this.train)) continue;
                return false;
            }
            return true;
        }
        UUID groupId = signal.groups.get(this.waitingForSignal.getSecond());
        if (groupId == null) {
            return true;
        }
        SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(groupId);
        if (signalEdgeGroup == null) {
            return true;
        }
        return !signalEdgeGroup.isOccupiedUnless(this.train);
    }

    public boolean isActive() {
        return this.destination != null;
    }

    public TravellingPoint.ITrackSelector control(TravellingPoint mp) {
        if (this.destination == null) {
            return mp.steer(this.train.manualSteer, new class_243(0.0, 1.0, 0.0));
        }
        return (graph, pair) -> this.navigateOptions(this.currentPath, (TrackGraph)graph, (List)pair.getSecond());
    }

    public TravellingPoint.ITrackSelector controlSignalScout() {
        if (this.destination == null) {
            return this.signalScout.steer(this.train.manualSteer, new class_243(0.0, 1.0, 0.0));
        }
        ArrayList<Couple<TrackNode>> pathCopy = new ArrayList<Couple<TrackNode>>(this.currentPath);
        return (graph, pair) -> this.navigateOptions((List<Couple<TrackNode>>)pathCopy, (TrackGraph)graph, (List)pair.getSecond());
    }

    private Map.Entry<TrackNode, TrackEdge> navigateOptions(List<Couple<TrackNode>> path, TrackGraph graph, List<Map.Entry<TrackNode, TrackEdge>> options) {
        if (path.isEmpty()) {
            return options.get(0);
        }
        Couple<TrackNode> nodes = path.get(0);
        TrackEdge targetEdge = graph.getConnection(nodes);
        for (Map.Entry<TrackNode, TrackEdge> entry : options) {
            if (entry.getValue() != targetEdge) continue;
            path.remove(0);
            return entry;
        }
        return options.get(0);
    }

    public void cancelNavigation() {
        this.distanceToDestination = 0.0;
        this.currentPath.clear();
        if (this.destination == null) {
            return;
        }
        this.destination.cancelReservation(this.train);
        this.destination = null;
        this.train.runtime.transitInterrupted();
        this.train.reservedSignalBlocks.clear();
    }

    public double startNavigation(DiscoveredPath pathTo) {
        boolean noneFound = pathTo == null;
        double distance = noneFound ? -1.0 : Math.abs(pathTo.distance);
        double cost = noneFound ? -1.0 : pathTo.cost;
        this.distanceToDestination = distance;
        if (noneFound) {
            this.distanceStartedAt = 0.0;
            this.distanceToDestination = 0.0;
            this.currentPath = new ArrayList<Couple<TrackNode>>();
            if (this.destination != null) {
                this.cancelNavigation();
            }
            return -1.0;
        }
        if (Math.abs(this.distanceToDestination) > 100.0) {
            this.announceArrival = true;
        }
        this.currentPath = pathTo.path;
        this.destinationBehindTrain = pathTo.distance < 0.0;
        this.train.reservedSignalBlocks.clear();
        this.train.navigation.waitingForSignal = null;
        if (this.destination == null) {
            this.distanceStartedAt = distance;
        }
        if (this.destination == pathTo.destination) {
            return 0.0;
        }
        if (!this.train.runtime.paused) {
            boolean frontDriver = this.train.hasForwardConductor();
            boolean backDriver = this.train.hasBackwardConductor();
            if (this.destinationBehindTrain && !backDriver) {
                if (frontDriver) {
                    this.train.status.missingCorrectConductor();
                } else {
                    this.train.status.missingConductor();
                }
                return -1.0;
            }
            if (!this.destinationBehindTrain && !frontDriver) {
                if (backDriver) {
                    this.train.status.missingCorrectConductor();
                } else {
                    this.train.status.missingConductor();
                }
                return -1.0;
            }
            this.train.status.foundConductor();
        }
        this.destination = pathTo.destination;
        return cost;
    }

    @Nullable
    public DiscoveredPath findPathTo(GlobalStation destination, double maxCost) {
        ArrayList<GlobalStation> destinations = new ArrayList<GlobalStation>();
        destinations.add(destination);
        return this.findPathTo(destinations, maxCost);
    }

    @Nullable
    public DiscoveredPath findPathTo(ArrayList<GlobalStation> destinations, double maxCost) {
        boolean canDriveBackward;
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return null;
        }
        Couple<Object> results = Couple.create(null, null);
        for (boolean forward : Iterate.trueAndFalse) {
            if (this.destination != null && this.destinationBehindTrain == forward) continue;
            TravellingPoint initialPoint = forward ? this.train.carriages.get(0).getLeadingPoint() : this.train.carriages.get(this.train.carriages.size() - 1).getTrailingPoint();
            TrackEdge initialEdge = forward ? initialPoint.edge : graph.getConnectionsFrom(initialPoint.node2).get(initialPoint.node1);
            this.search(Double.MAX_VALUE, maxCost, forward, destinations, (distance, cost, reachedVia, currentEntry, globalStation) -> {
                for (GlobalStation destination : destinations) {
                    if (globalStation != destination) continue;
                    TrackEdge edge = (TrackEdge)currentEntry.getSecond();
                    TrackNode node1 = (TrackNode)((Couple)currentEntry.getFirst()).getFirst();
                    TrackNode node2 = (TrackNode)((Couple)currentEntry.getFirst()).getSecond();
                    ArrayList<Couple<TrackNode>> currentPath = new ArrayList<Couple<TrackNode>>();
                    Pair backTrack = (Pair)reachedVia.get(edge);
                    Couple toReach = Couple.create(node1, node2);
                    TrackEdge edgeReached = edge;
                    while (backTrack != null && edgeReached != initialEdge) {
                        if (((Boolean)backTrack.getFirst()).booleanValue()) {
                            currentPath.add(0, toReach);
                        }
                        toReach = (Couple)backTrack.getSecond();
                        edgeReached = graph.getConnection(toReach);
                        backTrack = (Pair)reachedVia.get(edgeReached);
                    }
                    double position = edge.getLength() - destination.getLocationOn(edge);
                    double distanceToDestination = distance - position;
                    results.set(forward, new DiscoveredPath((double)(forward ? 1 : -1) * distanceToDestination, cost, currentPath, destination));
                    return true;
                }
                return false;
            });
        }
        DiscoveredPath front = (DiscoveredPath)results.getFirst();
        DiscoveredPath back = (DiscoveredPath)results.getSecond();
        boolean frontEmpty = front == null;
        boolean backEmpty = back == null;
        boolean canDriveForward = this.train.hasForwardConductor() || this.train.runtime.paused;
        boolean bl = canDriveBackward = this.train.doubleEnded && this.train.hasBackwardConductor() || this.train.runtime.paused;
        if (backEmpty || !canDriveBackward) {
            return canDriveForward ? front : null;
        }
        if (frontEmpty || !canDriveForward) {
            return canDriveBackward ? back : null;
        }
        boolean frontBetter = maxCost == -1.0 ? -back.distance > front.distance : back.cost > front.cost;
        return frontBetter ? front : back;
    }

    public GlobalStation findNearestApproachable(boolean forward) {
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return null;
        }
        MutableObject result = new MutableObject(null);
        double acceleration = this.train.acceleration();
        double minDistance = 0.75 * (this.train.speed * this.train.speed) / (2.0 * acceleration);
        double maxDistance = Math.max(32.0, 1.5 * (this.train.speed * this.train.speed) / (2.0 * acceleration));
        this.search(maxDistance, forward, null, (distance, cost, reachedVia, currentEntry, globalStation) -> {
            if (distance < minDistance) {
                return false;
            }
            TrackEdge edge = (TrackEdge)currentEntry.getSecond();
            double position = edge.getLength() - globalStation.getLocationOn(edge);
            if (distance - position < minDistance) {
                return false;
            }
            Train presentTrain = globalStation.getPresentTrain();
            if (presentTrain != null && presentTrain != this.train) {
                return false;
            }
            result.setValue((Object)globalStation);
            return true;
        });
        return (GlobalStation)result.getValue();
    }

    public void search(double maxDistance, boolean forward, ArrayList<GlobalStation> destinations, StationTest stationTest) {
        this.search(maxDistance, -1.0, forward, destinations, stationTest);
    }

    public void search(double maxDistance, double maxCost, boolean forward, ArrayList<GlobalStation> destinations, StationTest stationTest) {
        EdgeData initialSignalData;
        boolean costRelevant;
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return;
        }
        HashSet<class_2960> validTypes = new HashSet<class_2960>();
        for (int i = 0; i < this.train.carriages.size(); ++i) {
            Carriage carriage = this.train.carriages.get(i);
            if (i == 0) {
                validTypes.addAll(carriage.leadingBogey().type.getValidPathfindingTypes(carriage.leadingBogey().getStyle()));
            } else {
                validTypes.retainAll(carriage.leadingBogey().type.getValidPathfindingTypes(carriage.leadingBogey().getStyle()));
            }
            if (!carriage.isOnTwoBogeys()) continue;
            validTypes.retainAll(carriage.trailingBogey().type.getValidPathfindingTypes(carriage.trailingBogey().getStyle()));
        }
        if (validTypes.isEmpty()) {
            return;
        }
        IdentityHashMap penalties = new IdentityHashMap();
        boolean bl = costRelevant = maxCost >= 0.0;
        if (costRelevant) {
            for (Train otherTrain : Create.RAILWAYS.trains.values()) {
                if (otherTrain.graph != graph || otherTrain == this.train) continue;
                int navigationPenalty = otherTrain.getNavigationPenalty();
                otherTrain.getEndpointEdges().forEach(nodes -> {
                    if (nodes.either(Objects::isNull)) {
                        return;
                    }
                    for (boolean flip : Iterate.trueAndFalse) {
                        TrackEdge e = graph.getConnection((Couple<TrackNode>)(flip ? nodes.swap() : nodes));
                        if (e == null) continue;
                        int existing = penalties.getOrDefault(e, 0);
                        penalties.put(e, existing + navigationPenalty / 2);
                    }
                });
            }
        }
        TravellingPoint startingPoint = forward ? this.train.carriages.get(0).getLeadingPoint() : this.train.carriages.get(this.train.carriages.size() - 1).getTrailingPoint();
        HashSet<TrackEdge> visited = new HashSet<TrackEdge>();
        IdentityHashMap<TrackEdge, Pair<Boolean, Couple<TrackNode>>> reachedVia = new IdentityHashMap<TrackEdge, Pair<Boolean, Couple<TrackNode>>>();
        PriorityQueue<FrontierEntry> frontier = new PriorityQueue<FrontierEntry>();
        TrackNode initialNode1 = forward ? startingPoint.node1 : startingPoint.node2;
        TrackNode initialNode2 = forward ? startingPoint.node2 : startingPoint.node1;
        TrackEdge initialEdge = graph.getConnectionsFrom(initialNode1).get(initialNode2);
        if (initialEdge == null) {
            return;
        }
        double distanceToNode2 = forward ? initialEdge.getLength() - startingPoint.position : startingPoint.position;
        int signalWeight = class_3532.method_15340((int)(this.ticksWaitingForSignal * 2), (int)25, (int)200);
        int initialPenalty = 0;
        if (costRelevant) {
            initialPenalty += penalties.getOrDefault(initialEdge, 0).intValue();
        }
        if ((initialSignalData = initialEdge.getEdgeData()).hasPoints()) {
            for (TrackEdgePoint point : initialSignalData.getPoints()) {
                boolean isOwnStation;
                if (point.getLocationOn(initialEdge) < initialEdge.getLength() - distanceToNode2) continue;
                if (costRelevant && distanceToNode2 + (double)initialPenalty > maxCost) {
                    return;
                }
                if (!point.canNavigateVia(initialNode2)) {
                    return;
                }
                if (point instanceof SignalBoundary) {
                    SignalEdgeGroup signalEdgeGroup;
                    SignalBoundary signal = (SignalBoundary)point;
                    if (signal.isForcedRed(initialNode2)) {
                        initialPenalty += 400;
                        continue;
                    }
                    UUID group = signal.getGroup(initialNode2);
                    if (group == null || (signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(group)) == null) continue;
                    if (signalEdgeGroup.isOccupiedUnless(signal)) {
                        initialPenalty += signalWeight;
                        signalWeight /= 2;
                    }
                }
                if (!(point instanceof GlobalStation)) continue;
                GlobalStation station = (GlobalStation)point;
                Train presentTrain = station.getPresentTrain();
                boolean bl2 = isOwnStation = presentTrain == this.train;
                if (presentTrain != null && !isOwnStation) {
                    initialPenalty += 300;
                }
                if (station.canApproachFrom(initialNode2) && stationTest.test(distanceToNode2, distanceToNode2 + (double)initialPenalty, reachedVia, Pair.of(Couple.create(initialNode1, initialNode2), initialEdge), station)) {
                    return;
                }
                if (isOwnStation) continue;
                initialPenalty += 50;
            }
        }
        if (costRelevant && distanceToNode2 + (double)initialPenalty > maxCost) {
            return;
        }
        frontier.add(new FrontierEntry(this, distanceToNode2, initialPenalty, initialNode1, initialNode2, initialEdge));
        while (!frontier.isEmpty()) {
            TrackNode newNode;
            EdgeData signalData;
            FrontierEntry entry = (FrontierEntry)frontier.poll();
            if (!visited.add(entry.edge)) continue;
            double distance = entry.distance;
            int penalty = entry.penalty;
            if (distance > maxDistance) continue;
            TrackEdge edge = entry.edge;
            TrackNode node1 = entry.node1;
            TrackNode node2 = entry.node2;
            if (entry.hasDestination && (signalData = edge.getEdgeData()).hasPoints()) {
                for (TrackEdgePoint point : signalData.getPoints()) {
                    GlobalStation station;
                    if (!(point instanceof GlobalStation) || !(station = (GlobalStation)point).canApproachFrom(node2) || !stationTest.test(distance, penalty, reachedVia, Pair.of(Couple.create(node1, node2), edge), station)) continue;
                    return;
                }
            }
            ArrayList<Map.Entry<TrackNode, TrackEdge>> validTargets = new ArrayList<Map.Entry<TrackNode, TrackEdge>>();
            Map<TrackNode, TrackEdge> connectionsFrom = graph.getConnectionsFrom(node2);
            for (Map.Entry<TrackNode, TrackEdge> connection : connectionsFrom.entrySet()) {
                newNode = connection.getKey();
                if (newNode == node1 || !edge.canTravelTo(connection.getValue())) continue;
                validTargets.add(connection);
            }
            if (validTargets.isEmpty()) continue;
            block6: for (Map.Entry<TrackNode, TrackEdge> target : validTargets) {
                if (!validTypes.contains(target.getValue().getTrackMaterial().getId())) continue;
                newNode = target.getKey();
                TrackEdge newEdge = target.getValue();
                int newPenalty = penalty;
                double edgeLength = newEdge.getLength();
                double newDistance = distance + edgeLength;
                if (costRelevant) {
                    newPenalty += penalties.getOrDefault(newEdge, 0).intValue();
                }
                boolean hasDestination = false;
                EdgeData signalData2 = newEdge.getEdgeData();
                if (signalData2.hasPoints()) {
                    for (TrackEdgePoint point : signalData2.getPoints()) {
                        boolean isOwnStation;
                        if (node2 == initialNode1 && point.getLocationOn(newEdge) < edgeLength - distanceToNode2) continue;
                        if (costRelevant && newDistance + (double)newPenalty > maxCost || !point.canNavigateVia(newNode)) continue block6;
                        if (point instanceof SignalBoundary) {
                            SignalEdgeGroup signalEdgeGroup;
                            SignalBoundary signal = (SignalBoundary)point;
                            if (signal.isForcedRed(newNode)) {
                                newPenalty += 400;
                                continue;
                            }
                            UUID group = signal.getGroup(newNode);
                            if (group == null || (signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(group)) == null) continue;
                            if (signalEdgeGroup.isOccupiedUnless(signal)) {
                                newPenalty += signalWeight;
                                signalWeight /= 2;
                            }
                        }
                        if (!(point instanceof GlobalStation)) continue;
                        GlobalStation station = (GlobalStation)point;
                        Train presentTrain = station.getPresentTrain();
                        boolean bl3 = isOwnStation = presentTrain == this.train;
                        if (presentTrain != null && !isOwnStation) {
                            newPenalty += 300;
                        }
                        if (station.canApproachFrom(newNode) && stationTest.test(newDistance, newDistance + (double)newPenalty, reachedVia, Pair.of(Couple.create(node2, newNode), newEdge), station)) {
                            hasDestination = true;
                            break;
                        }
                        if (isOwnStation) continue;
                        newPenalty += 50;
                    }
                }
                if (costRelevant && newDistance + (double)newPenalty > maxCost) continue;
                double remainingDist = 0.0;
                if (destinations != null && !destinations.isEmpty()) {
                    remainingDist = Double.MAX_VALUE;
                    class_243 newNodePosition = newNode.getLocation().getLocation();
                    for (GlobalStation destination : destinations) {
                        double temp;
                        TrackNodeLocation destinationNode = (TrackNodeLocation)((Object)destination.edgeLocation.getFirst());
                        double dMin = Math.abs(newNodePosition.field_1352 - destinationNode.getLocation().field_1352);
                        double dMid = Math.abs(newNodePosition.field_1351 - destinationNode.getLocation().field_1351);
                        double dMax = Math.abs(newNodePosition.field_1350 - destinationNode.getLocation().field_1350);
                        if (dMin > dMid) {
                            temp = dMid;
                            dMid = dMin;
                            dMin = temp;
                        }
                        if (dMin > dMax) {
                            temp = dMax;
                            dMax = dMin;
                            dMin = temp;
                        }
                        if (dMid > dMax) {
                            temp = dMax;
                            dMax = dMid;
                            dMid = temp;
                        }
                        double currentRemaining = 0.317837245195782 * dMin + 0.414213562373095 * dMid + dMax + destination.position;
                        if (node2.getLocation().equals((Object)destinationNode)) {
                            currentRemaining -= newEdge.getLength() * 2.0;
                        }
                        remainingDist = Math.min(remainingDist, currentRemaining);
                    }
                }
                reachedVia.putIfAbsent(newEdge, Pair.of(validTargets.size() > 1, Couple.create(node1, node2)));
                frontier.add(new FrontierEntry(this, newDistance, newPenalty, remainingDist, hasDestination, node2, newNode, newEdge));
            }
        }
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        if (this.destination == null) {
            return;
        }
        this.removeBrokenPathEntries();
        view.method_71468("Destination", class_4844.field_25122, (Object)this.destination.id);
        view.method_71463("DistanceToDestination", this.distanceToDestination);
        view.method_71463("DistanceStartedAt", this.distanceStartedAt);
        view.method_71472("BehindTrain", this.destinationBehindTrain);
        view.method_71472("AnnounceArrival", this.announceArrival);
        class_11372.class_11374 list = view.method_71476("Path");
        this.currentPath.forEach(c -> {
            class_11372 item = list.method_71480();
            ((TrackNode)c.getFirst()).getLocation().write(item.method_71461("First"), dimensions);
            ((TrackNode)c.getSecond()).getLocation().write(item.method_71461("Second"), dimensions);
        });
        if (this.waitingForSignal == null) {
            return;
        }
        view.method_71468("BlockingSignal", class_4844.field_25122, (Object)this.waitingForSignal.getFirst());
        view.method_71472("BlockingSignalSide", this.waitingForSignal.getSecond().booleanValue());
        view.method_71463("DistanceToSignal", this.distanceToSignal);
        view.method_71465("TicksWaitingForSignal", this.ticksWaitingForSignal);
    }

    public static <T> DataResult<T> encode(Navigation input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        if (input.destination == null) {
            return map.build(empty);
        }
        input.removeBrokenPathEntries();
        map.add("Destination", (Object)input.destination.id, (Encoder)class_4844.field_25122);
        map.add("DistanceToDestination", ops.createDouble(input.distanceToDestination));
        map.add("DistanceStartedAt", ops.createDouble(input.distanceStartedAt));
        map.add("BehindTrain", ops.createBoolean(input.destinationBehindTrain));
        map.add("AnnounceArrival", ops.createBoolean(input.announceArrival));
        ListBuilder list = ops.listBuilder();
        input.currentPath.forEach(c -> {
            ListBuilder item = ops.listBuilder();
            item.add(TrackNodeLocation.encode(((TrackNode)c.getFirst()).getLocation(), ops, empty, dimensions));
            item.add(TrackNodeLocation.encode(((TrackNode)c.getSecond()).getLocation(), ops, empty, dimensions));
            list.add(item.build(empty));
        });
        map.add("Path", list.build(empty));
        if (input.waitingForSignal == null) {
            return map.build(empty);
        }
        map.add("BlockingSignal", (Object)input.waitingForSignal.getFirst(), (Encoder)class_4844.field_25122);
        map.add("BlockingSignalSide", ops.createBoolean(input.waitingForSignal.getSecond().booleanValue()));
        map.add("DistanceToSignal", ops.createDouble(input.distanceToSignal));
        map.add("TicksWaitingForSignal", ops.createInt(input.ticksWaitingForSignal));
        return map.build(empty);
    }

    public void read(class_11368 view, TrackGraph graph, DimensionPalette dimensions) {
        if (graph == null) {
            this.destination = null;
            return;
        }
        Optional id = view.method_71426("Destination", class_4844.field_25122);
        if (id.isEmpty()) {
            this.destination = null;
            return;
        }
        this.destination = graph.getPoint(EdgePointType.STATION, (UUID)id.get());
        if (this.destination == null) {
            return;
        }
        this.distanceToDestination = view.method_71422("DistanceToDestination", 0.0);
        this.distanceStartedAt = view.method_71422("DistanceStartedAt", 0.0);
        this.destinationBehindTrain = view.method_71433("BehindTrain", false);
        this.announceArrival = view.method_71433("AnnounceArrival", false);
        this.currentPath.clear();
        view.method_71438("Path").forEach(item -> this.currentPath.add(Couple.create(graph.locateNode(TrackNodeLocation.read(item.method_71434("First"), dimensions)), graph.locateNode(TrackNodeLocation.read(item.method_71434("Second"), dimensions)))));
        this.removeBrokenPathEntries();
        this.waitingForSignal = view.method_71426("BlockingSignal", class_4844.field_25122).map(uuid -> Pair.of(uuid, view.method_71433("BlockingSignalSide", false))).orElse(null);
        if (this.waitingForSignal == null) {
            return;
        }
        this.distanceToSignal = view.method_71422("DistanceToSignal", 0.0);
        this.ticksWaitingForSignal = view.method_71424("TicksWaitingForSignal", 0);
    }

    public <T> void decode(DynamicOps<T> ops, T input, TrackGraph graph, DimensionPalette dimensions) {
        if (graph == null) {
            this.destination = null;
            return;
        }
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        Optional id = class_4844.field_25122.parse(ops, map.get("Destination")).result();
        if (id.isEmpty()) {
            this.destination = null;
            return;
        }
        this.destination = graph.getPoint(EdgePointType.STATION, (UUID)id.get());
        if (this.destination == null) {
            return;
        }
        this.distanceToDestination = ops.getNumberValue(map.get("DistanceToDestination"), (Number)0).doubleValue();
        this.distanceStartedAt = ops.getNumberValue(map.get("DistanceStartedAt"), (Number)0).doubleValue();
        this.destinationBehindTrain = ops.getBooleanValue(map.get("BehindTrain")).result().orElse(false);
        this.announceArrival = ops.getBooleanValue(map.get("AnnounceArrival")).result().orElse(false);
        this.currentPath.clear();
        ((Consumer)ops.getList(map.get("Path")).getOrThrow()).accept(item -> {
            Iterator iterator = ((Stream)ops.getStream(item).getOrThrow()).iterator();
            this.currentPath.add(Couple.create(graph.locateNode(TrackNodeLocation.decode(ops, iterator.next(), dimensions)), graph.locateNode(TrackNodeLocation.decode(ops, iterator.next(), dimensions))));
        });
        this.removeBrokenPathEntries();
        this.waitingForSignal = class_4844.field_25122.parse(ops, map.get("BlockingSignal")).result().map(uuid -> Pair.of(uuid, ops.getBooleanValue(map.get("BlockingSignalSide")).result().orElse(false))).orElse(null);
        if (this.waitingForSignal == null) {
            return;
        }
        this.distanceToSignal = ops.getNumberValue(map.get("DistanceToSignal"), (Number)0).doubleValue();
        this.ticksWaitingForSignal = ops.getNumberValue(map.get("TicksWaitingForSignal"), (Number)0).intValue();
    }

    private void removeBrokenPathEntries() {
        boolean nullEntriesPresent = false;
        Iterator<Couple<TrackNode>> iterator = this.currentPath.iterator();
        while (iterator.hasNext()) {
            Couple<TrackNode> couple = iterator.next();
            if (couple != null && couple.getFirst() != null && couple.getSecond() != null) continue;
            iterator.remove();
            nullEntriesPresent = true;
        }
        if (nullEntriesPresent) {
            Create.LOGGER.error("Found null values in path of train with name: " + this.train.name.getString() + ", id: " + this.train.id.toString());
        }
    }

    @FunctionalInterface
    public static interface StationTest {
        public boolean test(double var1, double var3, Map<TrackEdge, Pair<Boolean, Couple<TrackNode>>> var5, Pair<Couple<TrackNode>, TrackEdge> var6, GlobalStation var7);
    }

    private class FrontierEntry
    implements Comparable<FrontierEntry> {
        double distance;
        int penalty;
        double remaining;
        boolean hasDestination;
        TrackNode node1;
        TrackNode node2;
        TrackEdge edge;

        public FrontierEntry(Navigation navigation, double distance, int penalty, TrackNode node1, TrackNode node2, TrackEdge edge) {
            this.distance = distance;
            this.penalty = penalty;
            this.remaining = 0.0;
            this.hasDestination = false;
            this.node1 = node1;
            this.node2 = node2;
            this.edge = edge;
        }

        public FrontierEntry(Navigation navigation, double distance, int penalty, double remaining, boolean hasDestination, TrackNode node1, TrackNode node2, TrackEdge edge) {
            this.distance = distance;
            this.penalty = penalty;
            this.remaining = remaining;
            this.hasDestination = hasDestination;
            this.node1 = node1;
            this.node2 = node2;
            this.edge = edge;
        }

        @Override
        public int compareTo(FrontierEntry o) {
            return Double.compare(this.distance + (double)this.penalty + this.remaining, o.distance + (double)o.penalty + o.remaining);
        }
    }
}

