/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.pack;

import com.google.gson.JsonElement;
import com.zurrtum.create.Create;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicPack
implements class_3262 {
    private final Map<String, class_7367<InputStream>> files = new HashMap<String, class_7367<InputStream>>();
    private final String packId;
    private final class_3264 packType;
    private final class_3272 metadata;
    private final class_9224 packLocationInfo;

    public DynamicPack(String packId, class_2561 title, class_3264 packType) {
        this.packId = packId;
        this.packType = packType;
        this.metadata = new class_3272(title, class_155.method_16673().method_70592(packType).method_72318());
        this.packLocationInfo = new class_9224(packId, (class_2561)class_2561.method_43470((String)packId), class_5352.field_25348, Optional.empty());
    }

    private static String getPath(class_3264 packType, class_2960 identifier) {
        return packType.method_14413() + "/" + identifier.method_12836() + "/" + identifier.method_12832();
    }

    public DynamicPack put(class_2960 location, class_7367<InputStream> stream) {
        this.files.put(DynamicPack.getPath(this.packType, location), stream);
        return this;
    }

    public DynamicPack put(class_2960 location, byte[] bytes) {
        return this.put(location, (class_7367<InputStream>)((class_7367)() -> new ByteArrayInputStream(bytes)));
    }

    public DynamicPack put(class_2960 location, String string) {
        return this.put(location, string.getBytes(StandardCharsets.UTF_8));
    }

    public DynamicPack put(class_2960 location, JsonElement json) {
        return this.put(location.method_48331(".json"), Create.GSON.toJson(json));
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... elements) {
        return this.files.getOrDefault(String.join((CharSequence)"/", elements), null);
    }

    @Nullable
    public class_7367<InputStream> method_14405(@NotNull class_3264 packType, @NotNull class_2960 identifier) {
        return this.files.getOrDefault(DynamicPack.getPath(packType, identifier), null);
    }

    public void method_14408(@NotNull class_3264 packType, @NotNull String namespace, @NotNull String path, @NotNull class_3262.class_7664 resourceOutput) {
        class_2960 identifier = class_2960.method_60655((String)namespace, (String)path);
        String directoryAndNamespace = packType.method_14413() + "/" + namespace + "/";
        String prefix = directoryAndNamespace + path + "/";
        this.files.forEach((filePath, streamSupplier) -> {
            if (filePath.startsWith(prefix)) {
                resourceOutput.accept((Object)identifier.method_45136(filePath.substring(directoryAndNamespace.length())), streamSupplier);
            }
        });
    }

    @NotNull
    public Set<String> method_14406(class_3264 packType) {
        HashSet<String> namespaces = new HashSet<String>();
        String dir = packType.method_14413() + "/";
        for (String path : this.files.keySet()) {
            String relative;
            if (!path.startsWith(dir) || !(relative = path.substring(dir.length())).contains("/")) continue;
            namespaces.add(relative.substring(0, relative.indexOf("/")));
        }
        return namespaces;
    }

    @Nullable
    public <T> T method_14407(@NotNull class_7677<T> deserializer) {
        return (T)(deserializer == class_3272.method_72356((class_3264)this.packType) ? this.metadata : null);
    }

    @NotNull
    public class_9224 method_56926() {
        return this.packLocationInfo;
    }

    @NotNull
    public String method_14409() {
        return this.packId;
    }

    public void close() {
    }
}

