/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.config;

import com.zurrtum.create.catnip.config.Builder;
import com.zurrtum.create.catnip.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigBase {
    protected int depth;
    protected List<CValue<?>> allValues = new ArrayList();
    protected List<ConfigBase> children = new ArrayList<ConfigBase>();

    public void registerAll(Builder builder) {
        for (CValue<?> cValue : this.allValues) {
            cValue.register(builder);
        }
    }

    public void onLoad() {
        if (!this.children.isEmpty()) {
            this.children.forEach(ConfigBase::onLoad);
        }
    }

    public void onReload() {
        if (!this.children.isEmpty()) {
            this.children.forEach(ConfigBase::onReload);
        }
    }

    public abstract String getName();

    protected ConfigString s(String current, String name, String ... comment) {
        return new ConfigString(this, name, current, comment);
    }

    protected ConfigBool b(boolean current, String name, String ... comment) {
        return new ConfigBool(this, name, current, comment);
    }

    protected ConfigFloat f(float current, float min, float max, String name, String ... comment) {
        return new ConfigFloat(this, name, current, min, max, comment);
    }

    protected ConfigFloat f(float current, float min, String name, String ... comment) {
        return this.f(current, min, Float.MAX_VALUE, name, comment);
    }

    protected ConfigInt i(int current, int min, int max, String name, String ... comment) {
        return new ConfigInt(this, name, current, min, max, comment);
    }

    protected ConfigInt i(int current, int min, String name, String ... comment) {
        return this.i(current, min, Integer.MAX_VALUE, name, comment);
    }

    protected ConfigInt i(int current, String name, String ... comment) {
        return this.i(current, Integer.MIN_VALUE, Integer.MAX_VALUE, name, comment);
    }

    protected <T extends Enum<T>> ConfigEnum<T> e(T defaultValue, String name, String ... comment) {
        return new ConfigEnum(this, name, defaultValue, comment);
    }

    protected ConfigGroup group(int depth, String name, String ... comment) {
        return new ConfigGroup(name, depth, comment);
    }

    protected <T extends ConfigBase> T nested(int depth, Supplier<T> constructor, String ... comment) {
        ConfigBase config = (ConfigBase)constructor.get();
        new ConfigGroup(config.getName(), depth, comment);
        new CValue(this, config.getName(), builder -> {
            config.depth = depth;
            config.registerAll((Builder)builder);
            if (config.depth > depth) {
                builder.pop(config.depth - depth);
            }
            return null;
        }, new String[0]);
        this.children.add(config);
        return (T)config;
    }

    public class CValue<V> {
        private final Function<Builder, ConfigValue<V>> provider;
        @Nullable
        protected ConfigValue<V> value;
        protected String name;

        public CValue(ConfigBase this$0, String name, Function<Builder, ConfigValue<V>> provider, String ... comment) {
            this.name = name;
            this.provider = builder -> {
                this.addComments((Builder)builder, comment);
                return (ConfigValue)provider.apply((Builder)builder);
            };
            this$0.allValues.add(this);
        }

        public void addComments(Builder builder, String ... comment) {
            if (comment.length > 0) {
                builder.comment(comment);
            }
        }

        public void register(Builder builder) {
            this.value = this.provider.apply(builder);
        }

        public V get() {
            if (this.value == null) {
                throw new AssertionError((Object)("Config " + this.getName() + " was accessed, but not registered before!"));
            }
            return this.value.get();
        }

        public void set(V value) {
            if (this.value == null) {
                throw new AssertionError((Object)("Config " + this.getName() + " was accessed, but not registered before!"));
            }
            this.value.set(value);
            this.value.save();
        }

        public String getName() {
            return this.name;
        }
    }

    public class ConfigString
    extends CValue<String> {
        public ConfigString(ConfigBase this$0, String name, String def, String ... comment) {
            super(this$0, name, (Builder builder) -> builder.define(name, def), comment);
        }
    }

    public class ConfigBool
    extends CValue<Boolean> {
        public ConfigBool(ConfigBase this$0, String name, boolean def, String ... comment) {
            super(this$0, name, builder -> builder.define(name, def), comment);
        }
    }

    public class ConfigFloat
    extends CValue<Float> {
        public ConfigFloat(ConfigBase this$0, String name, float current, float min, float max, String ... comment) {
            super(this$0, name, builder -> builder.defineInRange(name, current, min, max), comment);
        }

        public float getF() {
            return ((Float)this.get()).floatValue();
        }
    }

    public class ConfigInt
    extends CValue<Integer> {
        public ConfigInt(ConfigBase this$0, String name, int current, int min, int max, String ... comment) {
            super(this$0, name, builder -> builder.defineInRange(name, current, min, max), comment);
        }
    }

    public class ConfigEnum<T extends Enum<T>>
    extends CValue<T> {
        public ConfigEnum(String name, T defaultValue, String[] comment) {
            super(this$0, name, builder -> builder.defineEnum(name, defaultValue), comment);
        }
    }

    public class ConfigGroup
    extends CValue<Boolean> {
        private final int groupDepth;
        private final String[] comment;

        public ConfigGroup(String name, int depth, String ... comment) {
            super(ConfigBase.this, name, builder -> null, comment);
            this.groupDepth = depth;
            this.comment = comment;
        }

        @Override
        public void register(Builder builder) {
            if (ConfigBase.this.depth > this.groupDepth) {
                builder.pop(ConfigBase.this.depth - this.groupDepth);
            }
            ConfigBase.this.depth = this.groupDepth;
            this.addComments(builder, this.comment);
            builder.push(this.getName());
            ++ConfigBase.this.depth;
        }
    }
}

