/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.outliner;

import com.zurrtum.create.client.catnip.outliner.Outline;
import com.zurrtum.create.client.catnip.render.BindableTexture;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class AABBOutline
extends Outline {
    protected class_238 bb;
    protected final Vector3f minPosTemp1 = new Vector3f();
    protected final Vector3f maxPosTemp1 = new Vector3f();
    protected final Vector4f colorTemp1 = new Vector4f();
    protected final Vector3f pos0Temp = new Vector3f();
    protected final Vector3f pos1Temp = new Vector3f();
    protected final Vector3f pos2Temp = new Vector3f();
    protected final Vector3f pos3Temp = new Vector3f();
    protected final Vector3f normalTemp = new Vector3f();
    protected final Vector3f originTemp = new Vector3f();

    public AABBOutline(class_238 bb) {
        this.setBounds(bb);
    }

    public class_238 getBounds() {
        return this.bb;
    }

    public void setBounds(class_238 bb) {
        this.bb = bb;
    }

    @Override
    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt) {
        this.params.loadColor(this.colorTemp);
        Vector4f color = this.colorTemp;
        int lightmap = this.params.lightmap;
        boolean disableLineNormals = this.params.disableLineNormals;
        this.renderBox(ms, buffer, camera, this.bb, color, lightmap, disableLineNormals);
    }

    protected void renderBox(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, class_238 box, Vector4f color, int lightmap, boolean disableLineNormals) {
        Vector3f minPos = this.minPosTemp1;
        Vector3f maxPos = this.maxPosTemp1;
        boolean cameraInside = box.method_1006(camera);
        boolean cull = !cameraInside && !this.params.disableCull;
        float inflate = cameraInside ? -0.0078125f : 0.0078125f;
        box = box.method_997(camera.method_1021(-1.0));
        minPos.set((float)box.field_1323 - inflate, (float)box.field_1322 - inflate, (float)box.field_1321 - inflate);
        maxPos.set((float)box.field_1320 + inflate, (float)box.field_1325 + inflate, (float)box.field_1324 + inflate);
        this.renderBoxFaces(ms, buffer, cull, this.params.getHighlightedFace(), minPos, maxPos, color, lightmap);
        float lineWidth = this.params.getLineWidth();
        if (lineWidth == 0.0f) {
            return;
        }
        class_4588 consumer = buffer.getBuffer(PonderRenderTypes.outlineSolid());
        this.renderBoxEdges(ms, consumer, minPos, maxPos, lineWidth, color, lightmap, disableLineNormals);
    }

    protected void renderBoxFaces(class_4587 ms, SuperRenderTypeBuffer buffer, boolean cull, class_2350 highlightedFace, Vector3f minPos, Vector3f maxPos, Vector4f color, int lightmap) {
        class_4587.class_4665 pose = ms.method_23760();
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11033, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11036, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11043, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11035, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11039, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, class_2350.field_11034, color, lightmap);
    }

    protected void renderBoxFace(class_4587.class_4665 pose, SuperRenderTypeBuffer buffer, boolean cull, class_2350 highlightedFace, Vector3f minPos, Vector3f maxPos, class_2350 face, Vector4f color, int lightmap) {
        boolean highlighted = face == highlightedFace;
        BindableTexture faceTexture = this.params.faceTexture;
        if (faceTexture == null) {
            return;
        }
        class_1921 renderType = PonderRenderTypes.outlineTranslucent(faceTexture.getLocation(), cull);
        class_4588 consumer = buffer.getLateBuffer(renderType);
        float alphaMult = highlighted ? 1.0f : 0.5f;
        this.colorTemp1.set(color.x(), color.y(), color.z(), color.w() * alphaMult);
        color = this.colorTemp1;
        this.renderBoxFace(pose, consumer, minPos, maxPos, face, color, lightmap);
    }

    protected void renderBoxFace(class_4587.class_4665 pose, class_4588 consumer, Vector3f minPos, Vector3f maxPos, class_2350 face, Vector4f color, int lightmap) {
        float maxV;
        float maxU;
        Vector3f pos0 = this.pos0Temp;
        Vector3f pos1 = this.pos1Temp;
        Vector3f pos2 = this.pos2Temp;
        Vector3f pos3 = this.pos3Temp;
        Vector3f normal = this.normalTemp;
        float minX = minPos.x();
        float minY = minPos.y();
        float minZ = minPos.z();
        float maxX = maxPos.x();
        float maxY = maxPos.y();
        float maxZ = maxPos.z();
        switch (face) {
            case field_11033: {
                pos0.set(minX, minY, maxZ);
                pos1.set(minX, minY, minZ);
                pos2.set(maxX, minY, minZ);
                pos3.set(maxX, minY, maxZ);
                maxU = maxX - minX;
                maxV = maxZ - minZ;
                normal.set(0.0f, -1.0f, 0.0f);
                break;
            }
            case field_11036: {
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, maxY, maxZ);
                pos2.set(maxX, maxY, maxZ);
                pos3.set(maxX, maxY, minZ);
                maxU = maxX - minX;
                maxV = maxZ - minZ;
                normal.set(0.0f, 1.0f, 0.0f);
                break;
            }
            case field_11043: {
                pos0.set(maxX, maxY, minZ);
                pos1.set(maxX, minY, minZ);
                pos2.set(minX, minY, minZ);
                pos3.set(minX, maxY, minZ);
                maxU = maxX - minX;
                maxV = maxY - minY;
                normal.set(0.0f, 0.0f, -1.0f);
                break;
            }
            case field_11035: {
                pos0.set(minX, maxY, maxZ);
                pos1.set(minX, minY, maxZ);
                pos2.set(maxX, minY, maxZ);
                pos3.set(maxX, maxY, maxZ);
                maxU = maxX - minX;
                maxV = maxY - minY;
                normal.set(0.0f, 0.0f, 1.0f);
                break;
            }
            case field_11039: {
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, minY, minZ);
                pos2.set(minX, minY, maxZ);
                pos3.set(minX, maxY, maxZ);
                maxU = maxZ - minZ;
                maxV = maxY - minY;
                normal.set(-1.0f, 0.0f, 0.0f);
                break;
            }
            case field_11034: {
                pos0.set(maxX, maxY, maxZ);
                pos1.set(maxX, minY, maxZ);
                pos2.set(maxX, minY, minZ);
                pos3.set(maxX, maxY, minZ);
                maxU = maxZ - minZ;
                maxV = maxY - minY;
                normal.set(1.0f, 0.0f, 0.0f);
                break;
            }
            default: {
                maxU = 1.0f;
                maxV = 1.0f;
            }
        }
        this.bufferQuad(pose, consumer, pos0, pos1, pos2, pos3, color, 0.0f, 0.0f, maxU, maxV, lightmap, normal);
    }

    protected void renderBoxEdges(class_4587 ms, class_4588 consumer, Vector3f minPos, Vector3f maxPos, float lineWidth, Vector4f color, int lightmap, boolean disableNormals) {
        Vector3f origin = this.originTemp;
        class_4587.class_4665 pose = ms.method_23760();
        float lineLengthX = maxPos.x() - minPos.x();
        float lineLengthY = maxPos.y() - minPos.y();
        float lineLengthZ = maxPos.z() - minPos.z();
        origin.set((Vector3fc)minPos);
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11034, lineLengthX, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11036, lineLengthY, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11035, lineLengthZ, lineWidth, color, lightmap, disableNormals);
        origin.set(maxPos.x(), minPos.y(), minPos.z());
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11036, lineLengthY, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11035, lineLengthZ, lineWidth, color, lightmap, disableNormals);
        origin.set(minPos.x(), maxPos.y(), minPos.z());
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11034, lineLengthX, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11035, lineLengthZ, lineWidth, color, lightmap, disableNormals);
        origin.set(minPos.x(), minPos.y(), maxPos.z());
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11034, lineLengthX, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11036, lineLengthY, lineWidth, color, lightmap, disableNormals);
        origin.set(minPos.x(), maxPos.y(), maxPos.z());
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11034, lineLengthX, lineWidth, color, lightmap, disableNormals);
        origin.set(maxPos.x(), minPos.y(), maxPos.z());
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11036, lineLengthY, lineWidth, color, lightmap, disableNormals);
        origin.set(maxPos.x(), maxPos.y(), minPos.z());
        this.bufferCuboidLine(pose, consumer, origin, class_2350.field_11035, lineLengthZ, lineWidth, color, lightmap, disableNormals);
    }
}

