/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.rei;

import com.zurrtum.create.client.compat.rei.renderer.ChanceItemRenderer;
import com.zurrtum.create.client.compat.rei.renderer.FluidStackRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public abstract class CreateCategory<T extends Display>
implements DisplayCategory<T> {
    public abstract void addWidgets(List<Widget> var1, T var2, Rectangle var3);

    public static void drawSlotBackground(class_332 graphics, List<Point> points1, Point ... points2) {
        for (Point point : points1) {
            AllGuiTextures.JEI_SLOT.render(graphics, point.x - 1, point.y - 1);
        }
        CreateCategory.drawSlotBackground(graphics, points2);
    }

    public static void drawSlotBackground(class_332 graphics, Point ... points) {
        for (Point point : points) {
            AllGuiTextures.JEI_SLOT.render(graphics, point.x - 1, point.y - 1);
        }
    }

    public static void drawChanceSlotBackground(class_332 graphics, List<Point> points) {
        for (Point point : points) {
            AllGuiTextures.JEI_CHANCE_SLOT.render(graphics, point.x - 1, point.y - 1);
        }
    }

    public static void drawChanceSlotBackground(class_332 graphics, Point ... points) {
        for (Point point : points) {
            AllGuiTextures.JEI_CHANCE_SLOT.render(graphics, point.x - 1, point.y - 1);
        }
    }

    public static Slot createSlot(Point point) {
        return Widgets.createSlot((Point)point).disableBackground();
    }

    public static Slot createInputSlot(Point point) {
        return Widgets.createSlot((Point)point).markInput().disableBackground();
    }

    public static Slot createOutputSlot(Point point) {
        return Widgets.createSlot((Point)point).markOutput().disableBackground();
    }

    public static EntryIngredient getRenderEntryStack(EntryIngredient ingredient) {
        if (((EntryStack)ingredient.getFirst()).getValue() instanceof FluidStack) {
            for (EntryStack stack : ingredient.castAsList()) {
                stack.withRenderer((EntryRenderer)new FluidStackRenderer((EntryRenderer<FluidStack>)stack.getRenderer()));
            }
        }
        return ingredient;
    }

    public static EntryIngredient getRenderEntryStack(ChanceOutput output) {
        float chance = output.chance();
        if (chance == 1.0f) {
            return EntryIngredients.of((class_1799)output.stack());
        }
        EntryStack stack = EntryStacks.of((class_1799)output.stack());
        stack.withRenderer((EntryRenderer)new ChanceItemRenderer(chance, (EntryRenderer<class_1799>)stack.getRenderer()));
        return EntryIngredient.of((EntryStack)stack);
    }

    public static List<EntryIngredient> condenseIngredients(List<EntryIngredient> ingredients) {
        ArrayList<class_1799> cache = new ArrayList<class_1799>();
        ArrayList<EntryIngredient> result = new ArrayList<EntryIngredient>();
        block0: for (EntryIngredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            int size = ingredient.size();
            if (size != 1) {
                result.add(ingredient);
                continue;
            }
            EntryStack entryStack = (EntryStack)ingredient.getFirst();
            Iterator iterator = entryStack.getValue();
            if (!(iterator instanceof class_1799)) {
                result.add(ingredient);
                continue;
            }
            class_1799 stack = (class_1799)iterator;
            for (class_1799 target : cache) {
                if (!class_1799.method_31577((class_1799)stack, (class_1799)target)) continue;
                target.method_7933(stack.method_7947());
                continue block0;
            }
            stack = stack.method_7972();
            cache.add(stack);
            result.add(EntryIngredients.of((class_1799)stack));
        }
        return result;
    }

    public static void addOutputData(ChanceOutput output, int x, int y, List<Point> outputs, List<EntryIngredient> outputIngredients, List<Point> chances, List<EntryIngredient> chanceIngredients) {
        float chance = output.chance();
        Point point = new Point(x, y);
        EntryIngredient ingredient = CreateCategory.getRenderEntryStack(output);
        if (chance == 1.0f) {
            outputs.add(point);
            outputIngredients.add(ingredient);
        } else {
            chances.add(point);
            chanceIngredients.add(ingredient);
        }
    }

    public List<Widget> setupDisplay(T display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        this.addWidgets(widgets, display, bounds);
        return widgets;
    }

    public int getDisplayWidth(T display) {
        return 187;
    }
}

