/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.pulley;

import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractPulleyRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer<T> {
    private PartialModel halfRope;
    private PartialModel halfMagnet;

    public AbstractPulleyRenderer(class_5614.class_5615 context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    public boolean method_3563() {
        return true;
    }

    @Override
    protected void renderSafe(T be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            return;
        }
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        float offset = this.getOffset(be, partialTicks);
        boolean running = this.isRunning(be);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        AbstractPulleyRenderer.scrollCoil(this.getRotatedCoil(be), this.getCoilShift(), offset, 1.0f).light(light).renderInto(ms, vb);
        class_1937 world = be.method_10997();
        class_2680 blockState = be.method_11010();
        class_2338 pos = be.method_11016();
        SuperByteBuffer halfMagnet = CachedBuffers.partial(this.halfMagnet, blockState);
        SuperByteBuffer halfRope = CachedBuffers.partial(this.halfRope, blockState);
        SuperByteBuffer magnet = this.renderMagnet(be);
        SuperByteBuffer rope = this.renderRope(be);
        if (running || offset == 0.0f) {
            AbstractPulleyRenderer.renderAt((class_1936)world, offset > 0.25f ? magnet : halfMagnet, offset, pos, ms, vb);
        }
        float f = offset % 1.0f;
        if (offset > 0.75f && (f < 0.25f || f > 0.75f)) {
            AbstractPulleyRenderer.renderAt((class_1936)world, halfRope, f > 0.75f ? f - 1.0f : f, pos, ms, vb);
        }
        if (!running) {
            return;
        }
        int i = 0;
        while ((float)i < offset - 1.25f) {
            AbstractPulleyRenderer.renderAt((class_1936)world, rope, offset - (float)i - 1.0f, pos, ms, vb);
            ++i;
        }
    }

    public static void renderAt(class_1936 world, SuperByteBuffer partial, float offset, class_2338 pulleyPos, class_4587 ms, class_4588 buffer) {
        class_2338 actualPos = pulleyPos.method_10087((int)offset);
        int light = class_761.method_23793((class_761.class_10948)class_761.class_10948.field_58200, (class_1920)world, (class_2680)world.method_8320(actualPos), (class_2338)actualPos);
        ((SuperByteBuffer)partial.translate(0.0f, -offset, 0.0f)).light(light).renderInto(ms, buffer);
    }

    protected abstract class_2350.class_2351 getShaftAxis(T var1);

    protected abstract PartialModel getCoil();

    protected abstract SpriteShiftEntry getCoilShift();

    protected abstract SuperByteBuffer renderRope(T var1);

    protected abstract SuperByteBuffer renderMagnet(T var1);

    protected abstract float getOffset(T var1, float var2);

    protected abstract boolean isRunning(T var1);

    @Override
    protected class_2680 getRenderedBlockState(T be) {
        return AbstractPulleyRenderer.shaft(this.getShaftAxis(be));
    }

    protected SuperByteBuffer getRotatedCoil(T be) {
        class_2680 blockState = be.method_11010();
        return CachedBuffers.partialFacing(this.getCoil(), blockState, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.getShaftAxis(be)));
    }

    public static SuperByteBuffer scrollCoil(SuperByteBuffer sbb, SpriteShiftEntry coilShift, float offset, float speedModifier) {
        if (offset == 0.0f) {
            return sbb;
        }
        float spriteSize = coilShift.getTarget().method_4575() - coilShift.getTarget().method_4593();
        double coilScroll = (double)(-((offset *= speedModifier / 2.0f) + 0.1875f)) - Math.floor((offset + 0.1875f) * -2.0f) / 2.0;
        return sbb.shiftUVScrolling(coilShift, (float)coilScroll * spriteSize);
    }

    public int method_33893() {
        return (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
    }
}

