/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.content.contraptions.render.ContraptionRenderInfo;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_2688;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public class ContraptionEntityRenderer<C extends AbstractContraptionEntity, S extends AbstractContraptionState>
extends class_897<C, S> {
    public ContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (((AbstractContraptionEntity)((Object)entity)).getContraption() == null) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isAliveOrStale()) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isReadyForRender()) {
            return false;
        }
        return super.method_3933(entity, frustum, cameraX, cameraY, cameraZ);
    }

    public S createRenderState() {
        return (S)((Object)new AbstractContraptionState());
    }

    public void render(S state, class_4587 poseStack, class_4597 buffers, int overlay) {
        if (((AbstractContraptionState)((Object)state)).contraption == null) {
            return;
        }
        ContraptionRenderInfo renderInfo = ContraptionRenderInfo.get(((AbstractContraptionState)((Object)state)).contraption);
        VirtualRenderWorld renderWorld = renderInfo.getRenderWorld();
        ContraptionMatrices matrices = renderInfo.getMatrices();
        matrices.setup((matrixStack, partialTicks) -> this.transform(state, (class_4587)matrixStack, partialTicks.floatValue()), poseStack, (AbstractContraptionState)((Object)state));
        if (!VisualizationManager.supportsVisualization((class_1936)((AbstractContraptionState)((Object)state)).world)) {
            for (class_11515 renderType : class_11515.values()) {
                SuperByteBuffer sbb = ContraptionRenderInfo.getBuffer(((AbstractContraptionState)((Object)state)).contraption, renderWorld, renderType);
                if (sbb.isEmpty()) continue;
                class_4588 vc = buffers.getBuffer(this.getRenderLayer(renderType));
                ((SuperByteBuffer)sbb.transform(matrices.getModel())).useLevelLight((class_1920)((AbstractContraptionState)((Object)state)).world, matrices.getWorld()).renderInto(poseStack, vc);
            }
        }
        BlockEntityRenderHelper.renderBlockEntities(((AbstractContraptionState)((Object)state)).world, renderWorld, ((AbstractContraptionState)((Object)state)).contraption.getRenderedBEs(), matrices.getModelViewProjection(), matrices.getLight(), buffers);
        ContraptionEntityRenderer.renderActors(((AbstractContraptionState)((Object)state)).world, renderWorld, ((AbstractContraptionState)((Object)state)).contraption, matrices, buffers);
        matrices.clear();
    }

    private class_1921 getRenderLayer(class_11515 layer) {
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case class_11515.field_60923 -> class_1921.method_23577();
            case class_11515.field_60924 -> class_1921.method_23579();
            case class_11515.field_60925 -> class_1921.method_23581();
            case class_11515.field_60926 -> PonderRenderTypes.translucent();
            case class_11515.field_60927 -> class_1921.method_29997();
        };
    }

    public void transform(S state, class_4587 matrixStack, float partialTicks) {
    }

    public void updateRenderState(C entity, S state, float tickProgress) {
        ((AbstractContraptionState)((Object)state)).world = entity.method_37908();
        ((AbstractContraptionState)((Object)state)).contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        ((AbstractContraptionState)((Object)state)).lastRenderX = ((AbstractContraptionEntity)((Object)entity)).field_6038;
        ((AbstractContraptionState)((Object)state)).lastRenderY = ((AbstractContraptionEntity)((Object)entity)).field_5971;
        ((AbstractContraptionState)((Object)state)).lastRenderZ = ((AbstractContraptionEntity)((Object)entity)).field_5989;
        ((AbstractContraptionState)((Object)state)).entityX = entity.method_23317();
        ((AbstractContraptionState)((Object)state)).entityY = entity.method_23318();
        ((AbstractContraptionState)((Object)state)).entityZ = entity.method_23321();
    }

    private static void renderActors(class_1937 level, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, class_4597 buffer) {
        class_4587 m = matrices.getModel();
        for (Pair pair : c.getActors()) {
            MovementRenderBehaviour render;
            class_3499.class_3501 blockInfo;
            MovementBehaviour movementBehaviour;
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = level;
            }
            if ((movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)(blockInfo = (class_3499.class_3501)pair.getLeft()).comp_1342())) == null || (render = (MovementRenderBehaviour)movementBehaviour.getAttachRender()) == null || c.isHiddenInPortal(blockInfo.comp_1341())) continue;
            m.method_22903();
            TransformStack.of(m).translate((class_2382)blockInfo.comp_1341());
            render.renderInContraption(context, renderWorld, matrices, buffer);
            m.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class AbstractContraptionState
    extends class_10017 {
        public class_1937 world;
        public Contraption contraption;
        public double lastRenderX;
        public double lastRenderY;
        public double lastRenderZ;
        public double entityX;
        public double entityY;
        public double entityZ;
    }
}

