/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.contraptions.render.ContraptionRenderInfo;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.material.CardinalLightingMode;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.visual.BlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.LightUpdatedVisual;
import com.zurrtum.create.client.flywheel.api.visual.SectionTrackedVisual;
import com.zurrtum.create.client.flywheel.api.visual.ShaderLightVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visual.Visual;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualEmbedding;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.ModelUtil;
import com.zurrtum.create.client.flywheel.lib.model.baked.BlockModelBuilder;
import com.zurrtum.create.client.flywheel.lib.task.ForEachPlan;
import com.zurrtum.create.client.flywheel.lib.task.NestedPlan;
import com.zurrtum.create.client.flywheel.lib.task.PlanMap;
import com.zurrtum.create.client.flywheel.lib.task.RunnablePlan;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.foundation.utility.worldWrappers.WrappedBlockAndTintGetter;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class ContraptionVisual<E extends AbstractContraptionEntity>
extends AbstractEntityVisual<E>
implements DynamicVisual,
TickableVisual,
LightUpdatedVisual,
ShaderLightVisual {
    protected static final int LIGHT_PADDING = 1;
    protected final VisualEmbedding embedding;
    protected final List<BlockEntityVisual<?>> children = new ArrayList();
    protected final List<ActorVisual> actors = new ArrayList<ActorVisual>();
    protected final PlanMap<DynamicVisual, DynamicVisual.Context> dynamicVisuals = new PlanMap();
    protected final PlanMap<TickableVisual, TickableVisual.Context> tickableVisuals = new PlanMap();
    protected VirtualRenderWorld virtualRenderWorld;
    protected Model model;
    protected TransformedInstance structure;
    protected SectionTrackedVisual.SectionCollector sectionCollector;
    protected long minSection;
    protected long maxSection;
    protected long minBlock;
    protected long maxBlock;
    private final class_4587 contraptionMatrix = new class_4587();

    public ContraptionVisual(VisualizationContext ctx, E entity, float partialTick) {
        super(ctx, entity, partialTick);
        this.embedding = ctx.createEmbedding(class_2382.field_11176);
        this.setEmbeddingMatrices(partialTick);
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        if (contraption == null) {
            return;
        }
        this.setupModel(contraption);
        this.setupChildren(partialTick, contraption);
        this.setupActors(partialTick, contraption);
    }

    private void setupModel(Contraption contraption) {
        this.virtualRenderWorld = ContraptionRenderInfo.get(contraption).getRenderWorld();
        final Contraption.RenderedBlocks blocks = contraption.getRenderedBlocks();
        WrappedBlockAndTintGetter modelWorld = new WrappedBlockAndTintGetter(this, (class_1920)this.virtualRenderWorld){

            @Override
            public class_2680 method_8320(class_2338 pos) {
                return blocks.lookup().apply(pos);
            }
        };
        this.model = new BlockModelBuilder(modelWorld, blocks.positions()).materialFunc((renderType, shaded) -> {
            Material material = ModelUtil.getMaterial(renderType, shaded);
            if (material != null && material.cardinalLightingMode() == CardinalLightingMode.ENTITY) {
                return SimpleMaterial.builderOf(material).cardinalLightingMode(CardinalLightingMode.CHUNK).build();
            }
            return material;
        }).build();
        Instancer<TransformedInstance> instancer = this.embedding.instancerProvider().instancer(InstanceTypes.TRANSFORMED, this.model);
        if (this.structure == null) {
            this.structure = instancer.createInstance();
        } else {
            instancer.stealInstance(this.structure);
        }
        this.structure.setChanged();
    }

    private void setupChildren(float partialTick, Contraption contraption) {
        this.children.forEach(Visual::delete);
        this.children.clear();
        for (class_2586 be : contraption.getRenderedBEs()) {
            this.setupVisualizer(be, partialTick);
        }
    }

    private void setupActors(float partialTick, Contraption contraption) {
        this.actors.forEach(ActorVisual::delete);
        this.actors.clear();
        for (MutablePair<class_3499.class_3501, MovementContext> actor : contraption.getActors()) {
            this.setupActor(actor, partialTick);
        }
    }

    protected <T extends class_2586> void setupVisualizer(T be, float partialTicks) {
        BlockEntityVisualizer<T> visualizer = VisualizerRegistry.getVisualizer(be.method_11017());
        if (visualizer == null) {
            return;
        }
        class_1937 level = be.method_10997();
        be.method_31662((class_1937)this.virtualRenderWorld);
        BlockEntityVisual visual = visualizer.createVisual(this.embedding, be, partialTicks);
        this.children.add(visual);
        if (visual instanceof DynamicVisual) {
            DynamicVisual dynamic = (DynamicVisual)((Object)visual);
            this.dynamicVisuals.add(dynamic, dynamic.planFrame());
        }
        if (visual instanceof TickableVisual) {
            TickableVisual tickable = (TickableVisual)((Object)visual);
            this.tickableVisuals.add(tickable, tickable.planTick());
        }
        be.method_31662(level);
    }

    private void setupActor(MutablePair<class_3499.class_3501, MovementContext> actor, float partialTick) {
        class_3499.class_3501 blockInfo;
        MovementBehaviour movementBehaviour;
        MovementContext context = (MovementContext)actor.getRight();
        if (context == null) {
            return;
        }
        if (context.world == null) {
            context.world = this.level;
        }
        if ((movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)(blockInfo = (class_3499.class_3501)actor.getLeft()).comp_1342())) == null || movementBehaviour.attachRender == null) {
            return;
        }
        MovementRenderBehaviour render = (MovementRenderBehaviour)movementBehaviour.attachRender;
        ActorVisual visual = render.createVisual(this.embedding, this.virtualRenderWorld, context);
        if (visual == null) {
            return;
        }
        this.actors.add(visual);
    }

    @Override
    public Plan<TickableVisual.Context> planTick() {
        return NestedPlan.of(ForEachPlan.of(() -> this.actors, ActorVisual::tick), this.tickableVisuals);
    }

    @Override
    public Plan<DynamicVisual.Context> planFrame() {
        return NestedPlan.of(RunnablePlan.of(this::beginFrame), ForEachPlan.of(() -> this.actors, ActorVisual::beginFrame), this.dynamicVisuals);
    }

    protected void beginFrame(DynamicVisual.Context context) {
        float partialTick = context.partialTick();
        this.setEmbeddingMatrices(partialTick);
        if (this.hasMovedSections()) {
            this.sectionCollector.sections(this.collectLightSections());
        }
        if (this.hasMovedBlocks()) {
            this.updateLight(partialTick);
        }
        Contraption contraption = ((AbstractContraptionEntity)this.entity).getContraption();
        if (contraption.deferInvalidate) {
            this.setupModel(contraption);
            this.setupChildren(partialTick, contraption);
            this.setupActors(partialTick, contraption);
            contraption.deferInvalidate = false;
        }
    }

    private void setEmbeddingMatrices(float partialTick) {
        double z;
        double y;
        double x;
        class_2382 origin = this.renderOrigin();
        if (((AbstractContraptionEntity)this.entity).isPrevPosInvalid()) {
            x = ((AbstractContraptionEntity)this.entity).method_23317() - (double)origin.method_10263();
            y = ((AbstractContraptionEntity)this.entity).method_23318() - (double)origin.method_10264();
            z = ((AbstractContraptionEntity)this.entity).method_23321() - (double)origin.method_10260();
        } else {
            x = class_3532.method_16436((double)partialTick, (double)((AbstractContraptionEntity)this.entity).field_6014, (double)((AbstractContraptionEntity)this.entity).method_23317()) - (double)origin.method_10263();
            y = class_3532.method_16436((double)partialTick, (double)((AbstractContraptionEntity)this.entity).field_6036, (double)((AbstractContraptionEntity)this.entity).method_23318()) - (double)origin.method_10264();
            z = class_3532.method_16436((double)partialTick, (double)((AbstractContraptionEntity)this.entity).field_5969, (double)((AbstractContraptionEntity)this.entity).method_23321()) - (double)origin.method_10260();
        }
        this.contraptionMatrix.method_34426();
        this.contraptionMatrix.method_22904(x, y, z);
        this.transform(this.contraptionMatrix, partialTick);
        this.embedding.transforms((Matrix4fc)this.contraptionMatrix.method_23760().method_23761(), (Matrix3fc)this.contraptionMatrix.method_23760().method_23762());
    }

    public void transform(class_4587 contraptionMatrix, float partialTick) {
    }

    @Override
    public void updateLight(float partialTick) {
    }

    public LongSet collectLightSections() {
        class_238 boundingBox = ((AbstractContraptionEntity)this.entity).method_5829();
        int minSectionX = ContraptionVisual.minLightSection(boundingBox.field_1323);
        int minSectionY = ContraptionVisual.minLightSection(boundingBox.field_1322);
        int minSectionZ = ContraptionVisual.minLightSection(boundingBox.field_1321);
        int maxSectionX = ContraptionVisual.maxLightSection(boundingBox.field_1320);
        int maxSectionY = ContraptionVisual.maxLightSection(boundingBox.field_1325);
        int maxSectionZ = ContraptionVisual.maxLightSection(boundingBox.field_1324);
        this.minSection = class_4076.method_18685((int)minSectionX, (int)minSectionY, (int)minSectionZ);
        this.maxSection = class_4076.method_18685((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
        LongArraySet longSet = new LongArraySet();
        for (int x = 0; x <= maxSectionX - minSectionX; ++x) {
            for (int y = 0; y <= maxSectionY - minSectionY; ++y) {
                for (int z = 0; z <= maxSectionZ - minSectionZ; ++z) {
                    longSet.add(class_4076.method_18678((long)this.minSection, (int)x, (int)y, (int)z));
                }
            }
        }
        return longSet;
    }

    protected boolean hasMovedBlocks() {
        class_238 boundingBox = ((AbstractContraptionEntity)this.entity).method_5829();
        int minX = ContraptionVisual.minLight(boundingBox.field_1323);
        int minY = ContraptionVisual.minLight(boundingBox.field_1322);
        int minZ = ContraptionVisual.minLight(boundingBox.field_1321);
        int maxX = ContraptionVisual.maxLight(boundingBox.field_1320);
        int maxY = ContraptionVisual.maxLight(boundingBox.field_1325);
        int maxZ = ContraptionVisual.maxLight(boundingBox.field_1324);
        return this.minBlock != class_2338.method_10064((int)minX, (int)minY, (int)minZ) || this.maxBlock != class_2338.method_10064((int)maxX, (int)maxY, (int)maxZ);
    }

    protected boolean hasMovedSections() {
        class_238 boundingBox = ((AbstractContraptionEntity)this.entity).method_5829();
        int minSectionX = ContraptionVisual.minLightSection(boundingBox.field_1323);
        int minSectionY = ContraptionVisual.minLightSection(boundingBox.field_1322);
        int minSectionZ = ContraptionVisual.minLightSection(boundingBox.field_1321);
        int maxSectionX = ContraptionVisual.maxLightSection(boundingBox.field_1320);
        int maxSectionY = ContraptionVisual.maxLightSection(boundingBox.field_1325);
        int maxSectionZ = ContraptionVisual.maxLightSection(boundingBox.field_1324);
        return this.minSection != class_4076.method_18685((int)minSectionX, (int)minSectionY, (int)minSectionZ) || this.maxSection != class_4076.method_18685((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector collector) {
        this.sectionCollector = collector;
    }

    @Override
    protected void _delete() {
        this.children.forEach(Visual::delete);
        this.actors.forEach(ActorVisual::delete);
        if (this.structure != null) {
            this.structure.delete();
        }
        this.embedding.delete();
    }

    public static int minLight(double aabbPos) {
        return class_3532.method_15357((double)aabbPos) - 1;
    }

    public static int maxLight(double aabbPos) {
        return class_3532.method_15384((double)aabbPos) + 1;
    }

    public static int minLightSection(double aabbPos) {
        return class_4076.method_18675((int)ContraptionVisual.minLight(aabbPos));
    }

    public static int maxLightSection(double aabbPos) {
        return class_4076.method_18675((int)ContraptionVisual.maxLight(aabbPos));
    }
}

