/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.crafter;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.RecipeGridHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class MechanicalCrafterRenderer
extends SafeBlockEntityRenderer<MechanicalCrafterBlockEntity> {
    public MechanicalCrafterRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(MechanicalCrafterBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        ms.method_22903();
        class_2350 facing = (class_2350)be.method_11010().method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        class_243 vec = class_243.method_24954((class_2382)facing.method_62675()).method_1021(0.58).method_1031(0.5, 0.5, 0.5);
        if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
            class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(be.method_11010());
            float progress = class_3532.method_15363((float)(((float)(1000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
            vec = vec.method_1019(class_243.method_24954((class_2382)targetDirection.method_62675()).method_1021((double)(progress * 0.75f)));
        }
        ms.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
        ms.method_22905(0.5f, 0.5f, 0.5f);
        float yRot = AngleHelper.horizontalAngle(facing);
        ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(yRot));
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        ms.method_22909();
        this.renderFast(be, partialTicks, ms, buffer, light);
    }

    public void renderItems(MechanicalCrafterBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (be.phase == MechanicalCrafterBlockEntity.Phase.IDLE) {
            class_1799 stack2 = be.getInventory().getStack();
            if (!stack2.method_7960()) {
                ms.method_22903();
                ms.method_46416(0.0f, 0.0f, -0.00390625f);
                ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                class_310.method_1551().method_1480().method_23178(stack2, class_811.field_4319, light, overlay, ms, buffer, be.method_10997(), 0);
                ms.method_22909();
            }
        } else {
            RecipeGridHandler.GroupedItems items = be.groupedItems;
            float distance = 0.5f;
            ms.method_22903();
            if (be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING) {
                items = be.groupedItemsBeforeCraft;
                items.calcStats();
                float progress = class_3532.method_15363((float)(((float)(2000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = class_3532.method_15363((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = class_3532.method_15363((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.method_22905(1.0f - lateProgress, 1.0f - lateProgress, 1.0f - lateProgress);
                class_243 centering = new class_243((double)((float)(-items.minX) + (float)(-items.width + 1) / 2.0f), (double)((float)(-items.minY) + (float)(-items.height + 1) / 2.0f), 0.0).method_1021((double)earlyProgress);
                ms.method_22904(centering.field_1352 * 0.5, centering.field_1351 * 0.5, 0.0);
                distance += (-4.0f * (progress - 0.5f) * (progress - 0.5f) + 1.0f) * 0.25f;
            }
            boolean onlyRenderFirst = be.phase == MechanicalCrafterBlockEntity.Phase.INSERTING || be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING && be.countDown < 1000;
            float spacing = distance;
            class_918 itemRenderer = class_310.method_1551().method_1480();
            class_1937 world = be.method_10997();
            items.grid.forEach((pair, stack) -> {
                class_2680 state;
                if (onlyRenderFirst && ((Integer)pair.getFirst() != 0 || (Integer)pair.getSecond() != 0)) {
                    return;
                }
                ms.method_22903();
                Integer x = (Integer)pair.getFirst();
                Integer y = (Integer)pair.getSecond();
                ms.method_46416((float)x.intValue() * spacing, (float)y.intValue() * spacing, 0.0f);
                int offset = 0;
                if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING && (state = be.method_11010()).method_28498(MechanicalCrafterBlock.POINTING)) {
                    Pointing value = (Pointing)((Object)((Object)state.method_11654(MechanicalCrafterBlock.POINTING)));
                    offset = value == Pointing.UP ? -1 : (value == Pointing.LEFT ? 2 : (value == Pointing.RIGHT ? -2 : 1));
                }
                ((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(180.0f)).translate(0.0f, 0.0f, (float)(x + y * 3 + offset * 9) / 1024.0f);
                itemRenderer.method_23178(stack, class_811.field_4319, light, overlay, ms, buffer, world, 0);
                ms.method_22909();
            });
            ms.method_22909();
            if (be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING) {
                items = be.groupedItems;
                float progress = class_3532.method_15363((float)(((float)(1000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = class_3532.method_15363((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = class_3532.method_15363((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(earlyProgress * 2.0f * 360.0f));
                float upScaling = earlyProgress * 1.125f;
                float downScaling = 1.0f + (1.0f - lateProgress) * 0.125f;
                ms.method_22905(upScaling, upScaling, upScaling);
                ms.method_22905(downScaling, downScaling, downScaling);
                items.grid.forEach((pair, stack) -> {
                    if ((Integer)pair.getFirst() != 0 || (Integer)pair.getSecond() != 0) {
                        return;
                    }
                    ms.method_22903();
                    ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                    itemRenderer.method_23178(stack, class_811.field_4319, light, overlay, ms, buffer, world, 0);
                    ms.method_22909();
                });
            }
        }
    }

    public void renderFast(MechanicalCrafterBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light) {
        class_2680 blockState = be.method_11010();
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (!VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            SuperByteBuffer superBuffer = CachedBuffers.partial(AllPartialModels.SHAFTLESS_COGWHEEL, blockState);
            KineticBlockEntityRenderer.standardKineticRotationTransform(superBuffer, be, light);
            superBuffer.rotateCentered((float)(((class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166() != class_2350.class_2351.field_11048 ? 0.0 : 1.5707963267948966), class_2350.field_11036);
            superBuffer.rotateCentered(1.5707964f, class_2350.field_11034);
            superBuffer.renderInto(ms, vb);
        }
        class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(blockState);
        class_2338 pos = be.method_11016();
        if ((be.covered || be.phase != MechanicalCrafterBlockEntity.Phase.IDLE) && be.phase != MechanicalCrafterBlockEntity.Phase.CRAFTING && be.phase != MechanicalCrafterBlockEntity.Phase.INSERTING) {
            SuperByteBuffer lidBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_LID, blockState);
            lidBuffer.light(light).renderInto(ms, vb);
        }
        if (MechanicalCrafterBlock.isValidTarget(be.method_10997(), pos.method_10093(targetDirection), blockState)) {
            SuperByteBuffer beltBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_BELT, blockState);
            SuperByteBuffer beltFrameBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_BELT_FRAME, blockState);
            if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
                int textureIndex = (int)((float)be.getCountDownSpeed() / 128.0f * (float)AnimationTickHolder.getTicks());
                beltBuffer.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, (float)(textureIndex % 4) / 4.0f, 0.0f, 1);
            }
            beltBuffer.light(light).renderInto(ms, vb);
            beltFrameBuffer.light(light).renderInto(ms, vb);
        } else {
            SuperByteBuffer arrowBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_ARROW, blockState);
            arrowBuffer.light(light).renderInto(ms, vb);
        }
    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, class_2680 crafterState) {
        SuperByteBuffer buffer = CachedBuffers.partial(renderBlock, crafterState);
        float xRot = ((Pointing)((Object)crafterState.method_11654(MechanicalCrafterBlock.POINTING))).getXRotation();
        float yRot = AngleHelper.horizontalAngle((class_2350)crafterState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING));
        buffer.rotateCentered((float)((double)((yRot + 90.0f) / 180.0f) * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float)((double)(xRot / 180.0f) * Math.PI), class_2350.field_11034);
        return buffer;
    }
}

