/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;

@Environment(value=EnvType.CLIENT)
public class SchematicRenderer {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final Map<class_11515, SuperByteBuffer> bufferCache = new LinkedHashMap<class_11515, SuperByteBuffer>(class_11515.values().length);
    private boolean active;
    private boolean changed = false;
    protected SchematicLevel schematic;
    private class_2338 anchor;

    public void display(SchematicLevel world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.active = true;
        this.changed = true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void update() {
        this.changed = true;
    }

    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffers) {
        if (!this.active) {
            return;
        }
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        if (this.changed) {
            this.redraw(mc);
        }
        this.changed = false;
        this.bufferCache.forEach((layer, buffer) -> buffer.renderInto(ms, buffers.getBuffer((class_11515)layer)));
        BlockEntityRenderHelper.renderBlockEntities(this.schematic, this.schematic.getRenderedBlockEntities(), ms, buffers);
    }

    protected void redraw(class_310 mc) {
        this.bufferCache.clear();
        for (class_11515 layer : class_11515.values()) {
            SuperByteBuffer buffer = this.drawLayer(mc, layer);
            if (buffer.isEmpty()) continue;
            this.bufferCache.put(layer, buffer);
        }
    }

    protected SuperByteBuffer drawLayer(class_310 mc, class_11515 layer) {
        class_776 dispatcher = mc.method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        class_2338.class_2339 mutableBlockPos = objects.mutableBlockPos;
        SchematicLevel renderWorld = this.schematic;
        class_3341 bounds = renderWorld.getBounds();
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        renderWorld.renderMode = true;
        class_778.method_20544();
        for (class_2338 localPos : class_2338.method_10094((int)bounds.method_35415(), (int)bounds.method_35416(), (int)bounds.method_35417(), (int)bounds.method_35418(), (int)bounds.method_35419(), (int)bounds.method_35420())) {
            class_2338.class_2339 pos = mutableBlockPos.method_35831((class_2382)localPos, (class_2382)this.anchor);
            class_2680 state = renderWorld.method_8320((class_2338)pos);
            if (state.method_26217() != class_2464.field_11458 || class_4696.method_23679((class_2680)state) != layer) continue;
            long seed = state.method_26190((class_2338)pos);
            class_1087 model = dispatcher.method_3349(state);
            random.method_43052(seed);
            poseStack.method_22903();
            poseStack.method_46416((float)localPos.method_10263(), (float)localPos.method_10264(), (float)localPos.method_10260());
            ObjectArrayList parts = new ObjectArrayList();
            class_1087 class_10872 = WrapperBlockStateModel.unwrapCompat(model);
            if (class_10872 instanceof WrapperBlockStateModel) {
                WrapperBlockStateModel wrapper = (WrapperBlockStateModel)class_10872;
                wrapper.addPartsWithInfo((class_1920)renderWorld, (class_2338)pos, state, random, (List<class_10889>)parts);
            } else {
                model.method_68513(random, (List)parts);
            }
            renderer.method_3374((class_1920)renderWorld, (List)parts, state, (class_2338)pos, poseStack, (class_4588)sbbBuilder, true, class_4608.field_21444);
            poseStack.method_22909();
        }
        class_778.method_20545();
        renderWorld.renderMode = false;
        return sbbBuilder.end();
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }
}

