/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.client.content.contraptions.render.OrientedContraptionEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_765;

@Environment(value=EnvType.CLIENT)
public class CarriageContraptionEntityRenderer
extends OrientedContraptionEntityRenderer<CarriageContraptionEntity, CarriageContraptionState> {
    public CarriageContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public CarriageContraptionState createRenderState() {
        return new CarriageContraptionState();
    }

    @Override
    public boolean shouldRender(CarriageContraptionEntity entity, class_4604 clippingHelper, double cameraX, double cameraY, double cameraZ) {
        Carriage carriage = entity.getCarriage();
        if (carriage != null) {
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey == null) continue;
                bogey.couplingAnchors.replace(v -> null);
            }
        }
        return super.shouldRender(entity, clippingHelper, cameraX, cameraY, cameraZ);
    }

    @Override
    public void updateRenderState(CarriageContraptionEntity entity, CarriageContraptionState state, float tickProgress) {
        super.updateRenderState(entity, state, tickProgress);
        boolean bl = state.pass = !entity.validForRender || entity.firstPositionUpdate;
        if (state.pass) {
            return;
        }
        Carriage carriage = entity.getCarriage();
        if (carriage == null) {
            state.bogeys = null;
            return;
        }
        state.bogeySpacing = carriage.bogeySpacing;
        state.position = entity.method_30950(tickProgress);
        state.viewYRot = entity.getViewYRot(tickProgress);
        state.viewXRot = entity.getViewXRot(tickProgress);
        state.bogeys = carriage.bogeys;
        state.leadingPos = class_2338.field_10980.method_10079(entity.getInitialOrientation().method_10160(), carriage.bogeySpacing);
        state.cameraPos = entity.method_31166(tickProgress);
        state.yaw.replaceWithParams((f, bogeys) -> bogeys == null ? null : Float.valueOf(bogeys.yaw.getValue(tickProgress)), state.bogeys);
        state.pitch.replaceWithParams((f, bogeys) -> bogeys == null ? null : Float.valueOf(bogeys.pitch.getValue(tickProgress)), state.bogeys);
        state.tickProgress = tickProgress;
    }

    @Override
    public void render(CarriageContraptionState state, class_4587 ms, class_4597 buffers, int overlay) {
        if (state.pass) {
            return;
        }
        super.render(state, ms, buffers, overlay);
        if (state.bogeys == null) {
            return;
        }
        state.bogeys.forEachWithContext((bogey, first) -> {
            if (bogey == null) {
                return;
            }
            class_2338 bogeyPos = bogey.isLeading ? class_2338.field_10980 : state.leadingPos;
            float yaw = state.yaw.get((boolean)first).floatValue();
            float pitch = state.pitch.get((boolean)first).floatValue();
            if (!VisualizationManager.supportsVisualization((class_1936)state.world) && !state.contraption.isHiddenInPortal(bogeyPos)) {
                ms.method_22903();
                CarriageContraptionEntityRenderer.translateBogey(ms, bogey, state.bogeySpacing, state.viewYRot, state.viewXRot, yaw, pitch);
                int light = CarriageContraptionEntityRenderer.getBogeyLightCoords(state.world, bogey, () -> state.cameraPos);
                AllBogeyStyleRenders.render(bogey.getStyle(), bogey.getSize(), state.tickProgress, ms, buffers, light, overlay, bogey.wheelAngle.getValue(state.tickProgress), bogey.bogeyData, true);
                ms.method_22909();
            }
            bogey.updateCouplingAnchor(state.position, state.viewXRot, state.viewYRot, state.bogeySpacing, yaw, pitch, bogey.isLeading);
            if (state.bogeys.getSecond() == null) {
                bogey.updateCouplingAnchor(state.position, state.viewXRot, state.viewYRot, state.bogeySpacing, yaw, pitch, !bogey.isLeading);
            }
        });
    }

    public static void translateBogey(class_4587 ms, CarriageBogey bogey, int bogeySpacing, float viewYRot, float viewXRot, float yaw, float pitch) {
        boolean selfUpsideDown = bogey.isUpsideDown();
        boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(viewYRot + 90.0f)).rotateXDegrees(-viewXRot)).rotateYDegrees(180.0f)).translate(0.0f, 0.0f, bogey.isLeading ? 0.0f : (float)(-bogeySpacing)).rotateYDegrees(-180.0f)).rotateXDegrees(viewXRot)).rotateYDegrees(-viewYRot - 90.0f)).rotateYDegrees(yaw)).rotateXDegrees(pitch)).translate(0.0f, 0.5f, 0.0f).rotateZDegrees(selfUpsideDown ? 180.0f : 0.0f)).translateY(selfUpsideDown != leadingUpsideDown ? 2.0f : 0.0f);
    }

    public static int getBogeyLightCoords(class_1937 world, CarriageBogey bogey, Supplier<class_243> cameraPos) {
        class_2338 lightPos = class_2338.method_49638((class_2374)((class_2374)Objects.requireNonNullElseGet(bogey.getAnchorPosition(), cameraPos)));
        return class_765.method_23687((int)world.method_8314(class_1944.field_9282, lightPos), (int)world.method_8314(class_1944.field_9284, lightPos));
    }

    @Environment(value=EnvType.CLIENT)
    public static class CarriageContraptionState
    extends OrientedContraptionEntityRenderer.OrientedContraptionState {
        boolean pass;
        Couple<CarriageBogey> bogeys;
        Couple<Float> yaw = Couple.create(null, null);
        Couple<Float> pitch = Couple.create(null, null);
        class_2338 leadingPos;
        class_243 cameraPos;
        class_243 position;
        float viewYRot;
        float viewXRot;
        int bogeySpacing;
        float tickProgress;
    }
}

