/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackMaterialModels;
import com.zurrtum.create.client.content.contraptions.render.ContraptionVisual;
import com.zurrtum.create.client.content.trains.track.TrackRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.BlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visual.SectionTrackedVisual;
import com.zurrtum.create.client.flywheel.api.visual.ShaderLightVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractVisual;
import com.zurrtum.create.client.foundation.render.SpecialModels;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@Environment(value=EnvType.CLIENT)
public class TrackVisual
extends AbstractVisual
implements BlockEntityVisual<TrackBlockEntity>,
ShaderLightVisual {
    private final List<BezierTrackVisual> visuals = new ArrayList<BezierTrackVisual>();
    protected final TrackBlockEntity blockEntity;
    protected final class_2338 pos;
    protected final class_2338 visualPos;
    protected  @UnknownNullability SectionTrackedVisual.SectionCollector lightSections;

    public TrackVisual(VisualizationContext context, TrackBlockEntity track, float partialTick) {
        super(context, track.method_10997(), partialTick);
        this.blockEntity = track;
        this.pos = this.blockEntity.method_11016();
        this.visualPos = this.pos.method_10059(context.renderOrigin());
        this.collectConnections();
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        this.lightSections = sectionCollector;
        this.lightSections.sections(this.collectLightSections());
    }

    @Override
    public void update(float pt) {
        if (this.blockEntity.getConnections().isEmpty()) {
            return;
        }
        this._delete();
        this.collectConnections();
        this.lightSections.sections(this.collectLightSections());
    }

    private void collectConnections() {
        this.blockEntity.getConnections().values().stream().map(this::createInstance).filter(Objects::nonNull).forEach(this.visuals::add);
    }

    @Nullable
    private BezierTrackVisual createInstance(BezierConnection bc) {
        if (!bc.isPrimary()) {
            return null;
        }
        return new BezierTrackVisual(bc);
    }

    @Override
    public void _delete() {
        this.visuals.forEach(BezierTrackVisual::delete);
        this.visuals.clear();
    }

    public LongSet collectLightSections() {
        if (this.blockEntity.getConnections().isEmpty()) {
            return LongSet.of();
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BezierConnection connection : this.blockEntity.getConnections().values()) {
            class_238 bounds = connection.getBounds();
            minX = Math.min(minX, class_3532.method_15357((double)bounds.field_1323) - 1);
            minY = Math.min(minY, class_3532.method_15357((double)bounds.field_1322) - 1);
            minZ = Math.min(minZ, class_3532.method_15357((double)bounds.field_1321) - 1);
            maxX = Math.max(maxX, class_3532.method_15384((double)bounds.field_1320) + 1);
            maxY = Math.max(maxY, class_3532.method_15384((double)bounds.field_1325) + 1);
            maxZ = Math.max(maxZ, class_3532.method_15384((double)bounds.field_1324) + 1);
        }
        int minSectionX = ContraptionVisual.minLightSection(minX);
        int minSectionY = ContraptionVisual.minLightSection(minY);
        int minSectionZ = ContraptionVisual.minLightSection(minZ);
        int maxSectionX = ContraptionVisual.maxLightSection(maxX);
        int maxSectionY = ContraptionVisual.maxLightSection(maxY);
        int maxSectionZ = ContraptionVisual.maxLightSection(maxZ);
        LongArraySet out = new LongArraySet();
        for (int x = minSectionX; x <= maxSectionX; ++x) {
            for (int y = minSectionY; y <= maxSectionY; ++y) {
                for (int z = minSectionZ; z <= maxSectionZ; ++z) {
                    out.add(class_4076.method_18685((int)x, (int)y, (int)z));
                }
            }
        }
        return out;
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        for (BezierTrackVisual instance : this.visuals) {
            instance.collectCrumblingInstances(consumer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class BezierTrackVisual {
        private final TransformedInstance[] ties;
        private final TransformedInstance[] left;
        private final TransformedInstance[] right;
        @Nullable
        private GirderVisual girder;

        private BezierTrackVisual(BezierConnection bc) {
            this.girder = bc.hasGirder ? new GirderVisual(bc) : null;
            class_4587 pose = new class_4587();
            TransformStack.of(pose).translate((class_2382)TrackVisual.this.visualPos);
            int segCount = bc.getSegmentCount();
            this.ties = new TransformedInstance[segCount];
            this.left = new TransformedInstance[segCount];
            this.right = new TransformedInstance[segCount];
            AllTrackMaterialModels.TrackModelHolder modelHolder = (AllTrackMaterialModels.TrackModelHolder)bc.getMaterial().getModelHolder();
            TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.flatChunk(modelHolder.tie())).createInstances(this.ties);
            TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.flatChunk(modelHolder.leftSegment())).createInstances(this.left);
            TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.flatChunk(modelHolder.rightSegment())).createInstances(this.right);
            TrackRenderer.SegmentAngles segment = bc.getBakedSegments(TrackRenderer.SegmentAngles::new);
            for (int i = 1; i < segment.length; ++i) {
                int modelIndex = i - 1;
                this.ties[modelIndex].setTransform(pose).mul(segment.tieTransform[i]).setChanged();
                for (boolean first : Iterate.trueAndFalse) {
                    class_4587.class_4665 transform = segment.railTransforms[i].get(first);
                    (first ? this.left : this.right)[modelIndex].setTransform(pose).mul(transform).setChanged();
                }
            }
        }

        void delete() {
            for (TransformedInstance d : this.ties) {
                d.delete();
            }
            for (TransformedInstance d : this.left) {
                d.delete();
            }
            for (TransformedInstance d : this.right) {
                d.delete();
            }
            if (this.girder != null) {
                this.girder.delete();
            }
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            for (TransformedInstance d : this.ties) {
                consumer.accept(d);
            }
            for (TransformedInstance d : this.left) {
                consumer.accept(d);
            }
            for (TransformedInstance d : this.right) {
                consumer.accept(d);
            }
            if (this.girder != null) {
                this.girder.collectCrumblingInstances(consumer);
            }
        }

        @Environment(value=EnvType.CLIENT)
        private class GirderVisual {
            private final Couple<TransformedInstance[]> beams;
            private final Couple<Couple<TransformedInstance[]>> beamCaps;

            private GirderVisual(BezierConnection bc) {
                class_4587 pose = new class_4587();
                ((PoseTransformStack)TransformStack.of(pose).translate((class_2382)TrackVisual.this.visualPos)).nudge((int)((class_2338)bc.bePositions.getFirst()).method_10063());
                int segCount = bc.getSegmentCount();
                this.beams = Couple.create(() -> new TransformedInstance[segCount]);
                this.beamCaps = Couple.create(() -> Couple.create(() -> new TransformedInstance[segCount]));
                this.beams.forEach((Consumer<TransformedInstance[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, createInstances(com.zurrtum.create.client.flywheel.api.instance.Instance[] ), ([Lcom/zurrtum/create/client/flywheel/lib/instance/TransformedInstance;)V)(TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.flatChunk(AllPartialModels.GIRDER_SEGMENT_MIDDLE))));
                this.beamCaps.forEachWithContext((c, top) -> {
                    Model partialModel = SpecialModels.flatChunk(top != false ? AllPartialModels.GIRDER_SEGMENT_TOP : AllPartialModels.GIRDER_SEGMENT_BOTTOM);
                    c.forEach((Consumer<TransformedInstance[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, createInstances(com.zurrtum.create.client.flywheel.api.instance.Instance[] ), ([Lcom/zurrtum/create/client/flywheel/lib/instance/TransformedInstance;)V)(TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, partialModel)));
                });
                TrackRenderer.GirderAngles segment = bc.getBakedGirders(TrackRenderer.GirderAngles::new);
                for (int i = 1; i < segment.length; ++i) {
                    int modelIndex = i - 1;
                    for (boolean first : Iterate.trueAndFalse) {
                        class_4587.class_4665 beamTransform = segment.beams[i].get(first);
                        this.beams.get(first)[modelIndex].setTransform(pose).mul(beamTransform).setChanged();
                        for (boolean top2 : Iterate.trueAndFalse) {
                            class_4587.class_4665 beamCapTransform = segment.beamCaps[i].get(top2).get(first);
                            this.beamCaps.get(top2).get(first)[modelIndex].setTransform(pose).mul(beamCapTransform).setChanged();
                        }
                    }
                }
            }

            void delete() {
                this.beams.forEach(arr -> {
                    for (TransformedInstance d : arr) {
                        d.delete();
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (TransformedInstance d : arr) {
                        d.delete();
                    }
                }));
            }

            public void collectCrumblingInstances(Consumer<Instance> consumer) {
                this.beams.forEach(arr -> {
                    for (TransformedInstance d : arr) {
                        consumer.accept(d);
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (TransformedInstance d : arr) {
                        consumer.accept(d);
                    }
                }));
            }
        }
    }
}

