/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.client.flywheel.api.backend.Engine;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.backend.Samplers;
import com.zurrtum.create.client.flywheel.backend.compile.IndirectPrograms;
import com.zurrtum.create.client.flywheel.backend.compile.PipelineCompiler;
import com.zurrtum.create.client.flywheel.backend.engine.AbstractInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.CommonCrumbling;
import com.zurrtum.create.client.flywheel.backend.engine.DrawManager;
import com.zurrtum.create.client.flywheel.backend.engine.GroupKey;
import com.zurrtum.create.client.flywheel.backend.engine.InstanceHandleImpl;
import com.zurrtum.create.client.flywheel.backend.engine.InstancerKey;
import com.zurrtum.create.client.flywheel.backend.engine.LightStorage;
import com.zurrtum.create.client.flywheel.backend.engine.MaterialRenderState;
import com.zurrtum.create.client.flywheel.backend.engine.MeshPool;
import com.zurrtum.create.client.flywheel.backend.engine.TextureBinder;
import com.zurrtum.create.client.flywheel.backend.engine.embed.EnvironmentStorage;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.DepthPyramid;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.IndirectCullingGroup;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.IndirectDraw;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.IndirectInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.LightBuffers;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.MatrixBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.OitFramebuffer;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.StagingBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.Uniforms;
import com.zurrtum.create.client.flywheel.backend.gl.array.GlVertexArray;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBuffer;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBufferType;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBufferUsage;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL42;

@Environment(value=EnvType.CLIENT)
public class IndirectDrawManager
extends DrawManager<IndirectInstancer<?>> {
    private final IndirectPrograms programs;
    private final StagingBuffer stagingBuffer;
    private final MeshPool meshPool;
    private final GlVertexArray vertexArray;
    private final Map<InstanceType<?>, IndirectCullingGroup<?>> cullingGroups = new HashMap();
    private final GlBuffer crumblingDrawBuffer = new GlBuffer(GlBufferUsage.STREAM_DRAW);
    private final LightBuffers lightBuffers;
    private final MatrixBuffer matrixBuffer;
    private final DepthPyramid depthPyramid;
    private final OitFramebuffer oitFramebuffer;

    public IndirectDrawManager(IndirectPrograms programs) {
        this.programs = programs;
        programs.acquire();
        this.stagingBuffer = new StagingBuffer(this.programs);
        this.meshPool = new MeshPool();
        this.vertexArray = GlVertexArray.create();
        this.meshPool.bind(this.vertexArray);
        this.lightBuffers = new LightBuffers();
        this.matrixBuffer = new MatrixBuffer();
        this.depthPyramid = new DepthPyramid(programs);
        this.oitFramebuffer = new OitFramebuffer(programs.oitPrograms());
    }

    @Override
    protected <I extends Instance> IndirectInstancer<?> create(InstancerKey<I> key) {
        return new IndirectInstancer<I>(key, new AbstractInstancer.Recreate<I>(key, this));
    }

    @Override
    protected <I extends Instance> void initialize(InstancerKey<I> key, IndirectInstancer<?> instancer) {
        IndirectCullingGroup group = this.cullingGroups.computeIfAbsent(key.type(), t -> new IndirectCullingGroup(t, this.programs));
        group.add(instancer, key, this.meshPool);
    }

    @Override
    public void render(LightStorage lightStorage, EnvironmentStorage environmentStorage) {
        super.render(lightStorage, environmentStorage);
        this.cullingGroups.values().removeIf(IndirectCullingGroup::flushInstancers);
        this.instancers.values().removeIf(instancer -> instancer.instanceCount() == 0);
        this.meshPool.flush();
        this.stagingBuffer.reclaim();
        if (this.cullingGroups.isEmpty()) {
            return;
        }
        this.lightBuffers.flush(this.stagingBuffer, lightStorage);
        this.matrixBuffer.flush(this.stagingBuffer, environmentStorage);
        for (IndirectCullingGroup<?> group : this.cullingGroups.values()) {
            group.upload(this.stagingBuffer);
        }
        this.stagingBuffer.flush();
        this.depthPyramid.generate();
        GL42.glMemoryBarrier((int)8192);
        this.matrixBuffer.bind();
        this.depthPyramid.bindForCull();
        for (IndirectCullingGroup<?> group : this.cullingGroups.values()) {
            group.dispatchCull();
        }
        GL42.glMemoryBarrier((int)8192);
        this.programs.getApplyProgram().bind();
        for (IndirectCullingGroup<?> group : this.cullingGroups.values()) {
            group.dispatchApply();
        }
        GL42.glMemoryBarrier((int)8192);
        TextureBinder.bindLightAndOverlay();
        this.vertexArray.bindForDraw();
        this.lightBuffers.bind();
        this.matrixBuffer.bind();
        Uniforms.bindAll();
        for (IndirectCullingGroup<?> group : this.cullingGroups.values()) {
            group.submitSolid();
        }
        boolean useOit = false;
        for (IndirectCullingGroup<?> group : this.cullingGroups.values()) {
            if (!group.hasOitDraws()) continue;
            useOit = true;
            break;
        }
        if (useOit) {
            this.oitFramebuffer.prepare();
            this.oitFramebuffer.depthRange();
            for (IndirectCullingGroup<?> group : this.cullingGroups.values()) {
                group.submitTransparent(PipelineCompiler.OitMode.DEPTH_RANGE);
            }
            this.oitFramebuffer.renderTransmittance();
            for (IndirectCullingGroup<?> group : this.cullingGroups.values()) {
                group.submitTransparent(PipelineCompiler.OitMode.GENERATE_COEFFICIENTS);
            }
            this.oitFramebuffer.renderDepthFromTransmittance();
            this.vertexArray.bindForDraw();
            this.oitFramebuffer.accumulate();
            for (IndirectCullingGroup<?> group : this.cullingGroups.values()) {
                group.submitTransparent(PipelineCompiler.OitMode.EVALUATE);
            }
            this.oitFramebuffer.composite();
        }
        MaterialRenderState.reset();
        TextureBinder.resetLightAndOverlay();
    }

    @Override
    public void delete() {
        super.delete();
        this.cullingGroups.values().forEach(IndirectCullingGroup::delete);
        this.cullingGroups.clear();
        this.stagingBuffer.delete();
        this.meshPool.delete();
        this.crumblingDrawBuffer.delete();
        this.programs.release();
        this.depthPyramid.delete();
        this.lightBuffers.delete();
        this.matrixBuffer.delete();
        this.oitFramebuffer.delete();
    }

    @Override
    public void renderCrumbling(List<Engine.CrumblingBlock> crumblingBlocks) {
        Map<GroupKey<?>, Int2ObjectMap<List<Pair<IndirectInstancer, InstanceHandleImpl<?>>>>> byType = IndirectDrawManager.doCrumblingSort(crumblingBlocks, IndirectInstancer::fromState);
        if (byType.isEmpty()) {
            return;
        }
        TextureBinder.bindLightAndOverlay();
        this.vertexArray.bindForDraw();
        Uniforms.bindAll();
        SimpleMaterial.Builder crumblingMaterial = SimpleMaterial.builder();
        MemoryBlock block = MemoryBlock.malloc(36L);
        GlBufferType.DRAW_INDIRECT_BUFFER.bind(this.crumblingDrawBuffer.handle());
        GL30.glBindBufferRange((int)37074, (int)4, (int)this.crumblingDrawBuffer.handle(), (long)0L, (long)36L);
        for (Map.Entry<GroupKey<?>, Int2ObjectMap<List<Pair<IndirectInstancer, InstanceHandleImpl<?>>>>> groupEntry : byType.entrySet()) {
            Int2ObjectMap<List<Pair<IndirectInstancer, InstanceHandleImpl<?>>>> byProgress = groupEntry.getValue();
            GroupKey<?> groupKey = groupEntry.getKey();
            IndirectCullingGroup<?> cullingGroup = this.cullingGroups.get(groupKey.instanceType());
            if (cullingGroup == null) continue;
            for (Int2ObjectMap.Entry progressEntry : byProgress.int2ObjectEntrySet()) {
                Samplers.CRUMBLING.makeActive();
                TextureBinder.bind((class_2960)class_1088.field_21020.get(progressEntry.getIntKey()));
                for (Pair instanceHandlePair : (List)progressEntry.getValue()) {
                    IndirectInstancer instancer = (IndirectInstancer)instanceHandlePair.getFirst();
                    int instanceIndex = ((InstanceHandleImpl)instanceHandlePair.getSecond()).index;
                    for (IndirectDraw draw : instancer.draws()) {
                        CommonCrumbling.applyCrumblingProperties(crumblingMaterial, draw.material());
                        cullingGroup.bindForCrumbling(crumblingMaterial);
                        MaterialRenderState.setup(crumblingMaterial);
                        draw.writeWithOverrides(block.ptr(), instanceIndex, crumblingMaterial);
                        this.crumblingDrawBuffer.upload(block);
                        GL40.glDrawElementsIndirect((int)4, (int)5125, (long)0L);
                    }
                }
            }
        }
        MaterialRenderState.reset();
        TextureBinder.resetLightAndOverlay();
        block.free();
    }

    @Override
    public void triggerFallback() {
        IndirectPrograms.kill();
        class_310.method_1551().field_1769.method_3279();
    }
}

