/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.part;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.lib.model.RetexturedMesh;
import com.zurrtum.create.client.flywheel.lib.model.SingleMeshModel;
import com.zurrtum.create.client.flywheel.lib.model.part.MeshTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTree;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ModelTrees {
    private static final RendererReloadCache<ModelTreeKey, ModelTree> CACHE = new RendererReloadCache<ModelTreeKey, ModelTree>(k -> {
        ModelTree tree = ModelTrees.convert("", MeshTree.of(k.layer), k.pathsToPrune, k.texture != null ? k.texture.method_24148() : null, k.material);
        if (tree == null) {
            throw new IllegalArgumentException("Cannot prune root node!");
        }
        return tree;
    });

    private ModelTrees() {
    }

    public static ModelTree of(class_5601 layer, Material material) {
        return CACHE.get(new ModelTreeKey(layer, Collections.emptySet(), null, material));
    }

    public static ModelTree of(class_5601 layer, class_4730 texture, Material material) {
        return CACHE.get(new ModelTreeKey(layer, Collections.emptySet(), texture, material));
    }

    public static ModelTree of(class_5601 layer, Set<String> pathsToPrune, Material material) {
        return CACHE.get(new ModelTreeKey(layer, Set.copyOf(pathsToPrune), null, material));
    }

    public static ModelTree of(class_5601 layer, Set<String> pathsToPrune, class_4730 texture, Material material) {
        return CACHE.get(new ModelTreeKey(layer, Set.copyOf(pathsToPrune), texture, material));
    }

    @Nullable
    private static ModelTree convert(String path, MeshTree meshTree, Set<String> pathsToPrune, @Nullable class_1058 sprite, Material material) {
        if (pathsToPrune.contains(path)) {
            return null;
        }
        SingleMeshModel model = null;
        Mesh mesh = meshTree.mesh();
        if (mesh != null) {
            if (sprite != null) {
                mesh = new RetexturedMesh(mesh, sprite);
            }
            model = new SingleMeshModel(mesh, material);
        }
        HashMap<String, ModelTree> children = new HashMap<String, ModelTree>();
        String pathSlash = path + "/";
        for (int i = 0; i < meshTree.childCount(); ++i) {
            String childName = meshTree.childName(i);
            ModelTree child = ModelTrees.convert(pathSlash + childName, meshTree.child(i), pathsToPrune, sprite, material);
            if (child == null) continue;
            children.put(childName, child);
        }
        return new ModelTree(model, meshTree.initialPose(), children);
    }

    @Environment(value=EnvType.CLIENT)
    private record ModelTreeKey(class_5601 layer, Set<String> pathsToPrune, @Nullable class_4730 texture, Material material) {
    }
}

