/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.ponder;

import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.data.FunctionalHelper;
import com.zurrtum.create.client.content.contraptions.glue.SuperGlueSelectionHandler;
import com.zurrtum.create.client.foundation.ponder.element.BeltItemElement;
import com.zurrtum.create.client.foundation.ponder.element.ExpandedParrotElement;
import com.zurrtum.create.client.foundation.ponder.instruction.AnimateBlockEntityInstruction;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderSceneBuilder;
import com.zurrtum.create.client.ponder.foundation.element.ElementLinkImpl;
import com.zurrtum.create.client.ponder.foundation.instruction.CreateParrotInstruction;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.fluids.pump.PumpBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.infrastructure.particle.RotationIndicatorParticleData;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1453;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_6903;

@Environment(value=EnvType.CLIENT)
public class CreateSceneBuilder
extends PonderSceneBuilder {
    private final EffectInstructions effects = new EffectInstructions();
    private final WorldInstructions world = new WorldInstructions();
    private final SpecialInstructions special = new SpecialInstructions();

    public CreateSceneBuilder(SceneBuilder baseSceneBuilder) {
        this(baseSceneBuilder.getScene());
    }

    private CreateSceneBuilder(PonderScene ponderScene) {
        super(ponderScene);
    }

    @Override
    public EffectInstructions effects() {
        return this.effects;
    }

    @Override
    public WorldInstructions world() {
        return this.world;
    }

    @Override
    public SpecialInstructions special() {
        return this.special;
    }

    @Environment(value=EnvType.CLIENT)
    public class EffectInstructions
    extends PonderSceneBuilder.PonderEffectInstructions {
        public EffectInstructions() {
            super(CreateSceneBuilder.this);
        }

        public void superGlue(class_2338 pos, class_2350 side, boolean fullBlock) {
            CreateSceneBuilder.this.addInstruction(scene -> SuperGlueSelectionHandler.spawnParticles(scene.getWorld(), pos, side, fullBlock));
        }

        private void rotationIndicator(class_2338 pos, boolean direction, class_2338 displayPos) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                class_2680 blockState = scene.getWorld().method_8320(pos);
                class_2586 blockEntity = scene.getWorld().method_8321(pos);
                class_2248 patt0$temp = blockState.method_26204();
                if (!(patt0$temp instanceof KineticBlock)) {
                    return;
                }
                KineticBlock kb = (KineticBlock)patt0$temp;
                if (!(blockEntity instanceof KineticBlockEntity)) {
                    return;
                }
                KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
                class_2350.class_2351 rotationAxis = kb.getRotationAxis(blockState);
                float speed = kbe.getTheoreticalSpeed();
                IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
                int color = direction ? (speed > 0.0f ? 15425035 : 1476519) : speedLevel.getColor();
                int particleSpeed = speedLevel.getParticleSpeed();
                particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
                class_243 location = VecHelper.getCenterOf((class_2382)displayPos);
                RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, kb.getParticleInitialRadius(), kb.getParticleTargetRadius(), 20, rotationAxis);
                for (int i = 0; i < 20; ++i) {
                    scene.getWorld().method_8406(particleData, location.field_1352, location.field_1351, location.field_1350, 0.0, 0.0, 0.0);
                }
            });
        }

        public void rotationSpeedIndicator(class_2338 pos) {
            this.rotationIndicator(pos, false, pos);
        }

        public void rotationDirectionIndicator(class_2338 pos) {
            this.rotationIndicator(pos, true, pos);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class WorldInstructions
    extends PonderSceneBuilder.PonderWorldInstructions {
        public WorldInstructions() {
            super(CreateSceneBuilder.this);
        }

        public void rotateBearing(class_2338 pos, float angle, int duration) {
            CreateSceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.bearing(pos, angle, duration));
        }

        public void movePulley(class_2338 pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.pulley(pos, distance, duration));
        }

        public void animateBogey(class_2338 pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.bogey(pos, distance, duration + 1));
        }

        public void moveDeployer(class_2338 pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.deployer(pos, distance, duration));
        }

        public void createItemOnBeltLike(class_2338 location, class_2350 insertionSide, class_1799 stack) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getWorld();
                class_2586 blockEntity = world.method_8321(location);
                if (!(blockEntity instanceof SmartBlockEntity)) {
                    return;
                }
                SmartBlockEntity beltBlockEntity = (SmartBlockEntity)blockEntity;
                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                if (behaviour == null) {
                    return;
                }
                behaviour.handleInsertion(stack, insertionSide.method_10153(), false);
            });
            this.flapFunnel(location.method_10084(), true);
        }

        public ElementLink<BeltItemElement> createItemOnBelt(class_2338 beltLocation, class_2350 insertionSide, class_1799 stack) {
            ElementLinkImpl<BeltItemElement> link = new ElementLinkImpl<BeltItemElement>(BeltItemElement.class);
            CreateSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getWorld();
                class_2586 blockEntity = world.method_8321(beltLocation);
                if (!(blockEntity instanceof BeltBlockEntity)) {
                    return;
                }
                BeltBlockEntity beltBlockEntity = (BeltBlockEntity)blockEntity;
                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                behaviour.handleInsertion(stack, insertionSide.method_10153(), false);
                BeltBlockEntity controllerBE = beltBlockEntity.getControllerBE();
                if (controllerBE != null) {
                    controllerBE.tick();
                }
                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                transporter.handleProcessingOnAllItems(tis -> {
                    BeltItemElement tracker = new BeltItemElement((TransportedItemStack)tis);
                    scene.addElement(tracker);
                    scene.linkElement(tracker, link);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                });
            });
            this.flapFunnel(beltLocation.method_10084(), true);
            return link;
        }

        public void removeItemsFromBelt(class_2338 beltLocation) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getWorld();
                class_2586 blockEntity = world.method_8321(beltLocation);
                if (!(blockEntity instanceof SmartBlockEntity)) {
                    return;
                }
                SmartBlockEntity beltBlockEntity = (SmartBlockEntity)blockEntity;
                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                if (transporter == null) {
                    return;
                }
                transporter.handleCenteredProcessingOnAllItems(0.52f, tis -> TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            });
        }

        public void stallBeltItem(ElementLink<BeltItemElement> link, boolean stalled) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.locked = stalled;
                    });
                }
            });
        }

        public void changeBeltItemTo(ElementLink<BeltItemElement> link, class_1799 newStack) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.stack = newStack;
                    });
                }
            });
        }

        public void setKineticSpeed(Selection selection, float speed) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(speed));
        }

        public void multiplyKineticSpeed(Selection selection, float modifier) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(f.floatValue() * modifier));
        }

        public void modifyKineticSpeed(Selection selection, UnaryOperator<Float> speedFunc) {
            this.modifyBlockEntityNBT(selection, SpeedGaugeBlockEntity.class, nbt -> {
                float newSpeed = ((Float)speedFunc.apply(Float.valueOf(nbt.method_66563("Speed", 0.0f)))).floatValue();
                nbt.method_10548("Value", SpeedGaugeBlockEntity.getDialTarget(newSpeed));
            });
            this.modifyBlockEntityNBT(selection, KineticBlockEntity.class, nbt -> nbt.method_10548("Speed", ((Float)speedFunc.apply(Float.valueOf(nbt.method_66563("Speed", 0.0f)))).floatValue()));
        }

        public void propagatePipeChange(class_2338 pos) {
            this.modifyBlockEntity(pos, PumpBlockEntity.class, be -> be.onSpeedChanged(0.0f));
        }

        public void setFilterData(Selection selection, Class<? extends class_2586> teType, class_1799 filter) {
            this.modifyBlockEntityNBT(selection, teType, nbt -> {
                if (!filter.method_7960()) {
                    class_6903 ops = CreateSceneBuilder.this.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
                    nbt.method_67493("Filter", class_1799.field_24671, (DynamicOps)ops, (Object)filter);
                }
            });
        }

        public void instructArm(class_2338 armLocation, ArmBlockEntity.Phase phase, class_1799 heldItem, int targetedPoint) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.scene.getSceneBuildingUtil().select().position(armLocation), ArmBlockEntity.class, compound -> {
                compound.method_67494("Phase", ArmBlockEntity.Phase.CODEC, (Object)phase);
                if (!heldItem.method_7960()) {
                    class_6903 ops = CreateSceneBuilder.this.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
                    compound.method_67493("HeldItem", class_1799.field_24671, (DynamicOps)ops, (Object)heldItem);
                } else {
                    compound.method_10551("HeldItem");
                }
                compound.method_10569("TargetPointIndex", targetedPoint);
                compound.method_10548("MovementProgress", 0.0f);
            });
        }

        public void flapFunnel(class_2338 position, boolean outward) {
            this.modifyBlockEntity(position, FunnelBlockEntity.class, funnel -> funnel.flap(!outward));
        }

        public void setCraftingResult(class_2338 crafter, class_1799 output) {
            this.modifyBlockEntity(crafter, MechanicalCrafterBlockEntity.class, mct -> mct.setScriptedResult(output));
        }

        public void connectCrafterInvs(class_2338 position1, class_2338 position2) {
            CreateSceneBuilder.this.addInstruction(s -> {
                ConnectedInputHandler.toggleConnection(s.getWorld(), position1, position2);
                s.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
            });
        }

        public void toggleControls(class_2338 position) {
            this.cycleBlockProperty(position, (class_2769<?>)ControlsBlock.VIRTUAL);
        }

        public void animateTrainStation(class_2338 position, boolean trainPresent) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), StationBlockEntity.class, c -> c.method_10556("ForceFlag", trainPresent));
        }

        public void conductorBlaze(class_2338 position, boolean conductor) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), BlazeBurnerBlockEntity.class, c -> c.method_10556("TrainHat", conductor));
        }

        public void changeSignalState(class_2338 position, SignalBlockEntity.SignalState state) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), SignalBlockEntity.class, c -> c.method_67494("State", SignalBlockEntity.SignalState.CODEC, (Object)state));
        }

        public void setDisplayBoardText(class_2338 position, int line, class_2561 text) {
            this.modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.applyTextManually(line, text));
        }

        public void dyeDisplayBoard(class_2338 position, int line, class_1767 color) {
            this.modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.setColour(line, color));
        }

        public void flashDisplayLink(class_2338 position) {
            this.modifyBlockEntity(position, LinkWithBulbBlockEntity.class, LinkWithBulbBlockEntity::pulse);
        }

        @Override
        public void restoreBlocks(Selection selection) {
            super.restoreBlocks(selection);
            this.markSmartBlockEntityVirtual(selection);
        }

        @Override
        public void setBlocks(Selection selection, class_2680 state, boolean spawnParticles) {
            super.setBlocks(selection, state, spawnParticles);
            this.markSmartBlockEntityVirtual(selection);
        }

        @Override
        public void modifyBlocks(Selection selection, UnaryOperator<class_2680> stateFunc, boolean spawnParticles) {
            super.modifyBlocks(selection, stateFunc, spawnParticles);
            this.markSmartBlockEntityVirtual(selection);
        }

        private void markSmartBlockEntityVirtual(Selection selection) {
            CreateSceneBuilder.this.addInstruction(scene -> selection.forEach(pos -> {
                class_2586 patt0$temp = scene.getWorld().method_8321((class_2338)pos);
                if (patt0$temp instanceof SmartBlockEntity) {
                    SmartBlockEntity smartBlockEntity = (SmartBlockEntity)patt0$temp;
                    smartBlockEntity.markVirtual();
                }
            }));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class SpecialInstructions
    extends PonderSceneBuilder.PonderSpecialInstructions {
        public SpecialInstructions() {
            super(CreateSceneBuilder.this);
        }

        @Override
        public ElementLink<ParrotElement> createBirb(class_243 location, Supplier<? extends ParrotPose> pose) {
            ElementLinkImpl<ParrotElement> link = new ElementLinkImpl<ParrotElement>(ParrotElement.class);
            ParrotElement parrot = ExpandedParrotElement.create(location, pose);
            CreateSceneBuilder.this.addInstruction(new CreateParrotInstruction(10, class_2350.field_11033, parrot));
            CreateSceneBuilder.this.addInstruction(scene -> scene.linkElement(parrot, link));
            return link;
        }

        public ElementLink<ParrotElement> birbOnTurntable(class_2338 pos) {
            return this.createBirb(VecHelper.getCenterOf((class_2382)pos), () -> new ParrotSpinOnComponentPose(pos));
        }

        public ElementLink<ParrotElement> birbOnSpinnyShaft(class_2338 pos) {
            return this.createBirb(VecHelper.getCenterOf((class_2382)pos).method_1031(0.0, 0.5, 0.0), () -> new ParrotSpinOnComponentPose(pos));
        }

        public void conductorBirb(ElementLink<ParrotElement> birb, boolean conductor) {
            CreateSceneBuilder.this.addInstruction(scene -> scene.resolveOptional(birb).map(FunctionalHelper.filterAndCast(ExpandedParrotElement.class)).ifPresent(expandedBirb -> expandedBirb.setConductor(conductor)));
        }

        @Environment(value=EnvType.CLIENT)
        public static class ParrotSpinOnComponentPose
        extends ParrotPose {
            private final class_2338 componentPos;

            public ParrotSpinOnComponentPose(class_2338 componentPos) {
                this.componentPos = componentPos;
            }

            @Override
            public void tick(PonderScene scene, class_1453 entity, class_243 location) {
                class_2586 blockEntity = scene.getWorld().method_8321(this.componentPos);
                if (!(blockEntity instanceof KineticBlockEntity)) {
                    return;
                }
                float rpm = ((KineticBlockEntity)blockEntity).getSpeed();
                entity.field_5982 = entity.method_36454();
                entity.method_36456(entity.field_5982 + rpm * 0.3f);
            }
        }
    }
}

