/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.fluids.spout.SpoutBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.zurrtum.create.content.kinetics.press.PressingBehaviour;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import java.util.ArrayList;
import java.util.Collections;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

@Environment(value=EnvType.CLIENT)
public class BeltScenes {
    public static void beltConnector(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("belt_connector", "Using Mechanical Belts");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world().showSection(util.select().position(3, 0, 5), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 3, 4, 1, 5), class_2350.field_11033);
        ElementLink<WorldSectionElement> shafts = scene.world().showIndependentSection(util.select().fromTo(0, 1, 3, 4, 1, 3), class_2350.field_11033);
        scene.world().moveSection(shafts, util.vector().of(0.0, 0.0, -1.0), 0);
        scene.world().setKineticSpeed(util.select().position(0, 1, 3), 0.0f);
        scene.idle(20);
        class_2338 backEnd = util.grid().at(4, 1, 2);
        class_2338 frontEnd = util.grid().at(0, 1, 2);
        class_1799 beltItem = AllItems.BELT_CONNECTOR.method_7854();
        class_243 backEndCenter = util.vector().centerOf(backEnd);
        class_238 connectBB = new class_238(backEndCenter, backEndCenter);
        class_238 shaftBB = ((class_2680)AllBlocks.SHAFT.method_9564().method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11051)).method_26218(null, null).method_1107();
        scene.overlay().showControls(util.vector().topOf(backEnd), Pointing.DOWN, 57).rightClick().withItem(beltItem);
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, backEnd, shaftBB.method_996(backEnd), 42);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLACK, backEndCenter, connectBB, 50);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(frontEnd), Pointing.DOWN, 37).rightClick().withItem(beltItem);
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, frontEnd, shaftBB.method_996(frontEnd), 17);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLACK, backEndCenter, connectBB.method_1012(-4.0, 0.0, 0.0), 20);
        scene.idle(20);
        scene.world().moveSection(shafts, util.vector().of(0.0, -2.0, 0.0), 0);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 4, 1, 2), class_2350.field_11035);
        scene.idle(20);
        scene.overlay().showText(80).text("Right-Clicking two shafts with a belt item will connect them together").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(2, 1, 2));
        scene.idle(90);
        class_243 falseSelection = util.vector().topOf(backEnd.method_10077(1));
        scene.overlay().showControls(falseSelection, Pointing.DOWN, 37).rightClick().withItem(beltItem);
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, backEnd, shaftBB.method_996(backEnd.method_10077(1)), 50);
        scene.overlay().showText(80).colored(PonderPalette.RED).text("Accidental selections can be canceled with Right-Click while Sneaking").attachKeyFrame().placeNearTarget().pointAt(util.vector().centerOf(backEnd.method_10077(1)));
        scene.idle(43);
        scene.overlay().showControls(falseSelection, Pointing.DOWN, 20).rightClick().withItem(beltItem).whileSneaking();
        scene.idle(60);
        class_2338 shaftLocation = frontEnd.method_10078();
        scene.overlay().showControls(util.vector().topOf(shaftLocation), Pointing.DOWN, 50).rightClick().withItem(AllItems.SHAFT.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(shaftLocation, s -> (class_2680)s.method_11657(BeltBlock.PART, (Comparable)((Object)BeltPart.PULLEY)), true);
        scene.idle(10);
        scene.overlay().showText(43).text("Additional Shafts can be added throughout the Belt").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(shaftLocation, class_2350.field_11043));
        scene.idle(50);
        Selection attachedShafts = util.select().fromTo(0, 1, 1, 1, 1, 1);
        scene.world().showSection(attachedShafts, class_2350.field_11035);
        scene.world().setKineticSpeed(attachedShafts, 32.0f);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(util.grid().at(0, 1, 1));
        scene.effects().rotationDirectionIndicator(util.grid().at(1, 1, 1));
        scene.idle(20);
        scene.overlay().showText(50).text("Shafts connected via Belts will rotate with Identical Speed and Direction").placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(0, 1, 1), class_2350.field_11043));
        scene.idle(60);
        scene.world().hideSection(attachedShafts, class_2350.field_11043);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(shaftLocation), Pointing.DOWN, 50).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(shaftLocation, s -> (class_2680)s.method_11657(BeltBlock.PART, (Comparable)((Object)BeltPart.MIDDLE)), true);
        scene.idle(10);
        scene.overlay().showText(50).text("Added shafts can be removed using the wrench").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(shaftLocation, class_2350.field_11043));
        scene.idle(70);
        scene.overlay().showControls(util.vector().topOf(shaftLocation.method_10078()), Pointing.DOWN, 50).rightClick().withItem(new class_1799((class_1935)class_1802.field_8345));
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(util.select().fromTo(0, 1, 2, 4, 1, 2), BeltBlockEntity.class, nbt -> nbt.method_67494("Dye", (Codec)class_1767.field_41600, (Object)class_1767.field_7966));
        scene.idle(20);
        scene.overlay().showText(80).colored(PonderPalette.BLUE).text("Mechanical Belts can be dyed for aesthetic purposes").placeNearTarget().pointAt(util.vector().topOf(shaftLocation.method_10078()));
        scene.idle(50);
    }

    public static void directions(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("belt_directions", "Valid Orientations for Mechanical Belts");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        scene.idle(5);
        ElementLink<WorldSectionElement> leftShaft = scene.world().showIndependentSection(util.select().position(4, 1, 0), class_2350.field_11033);
        ElementLink<WorldSectionElement> rightShaft = scene.world().showIndependentSection(util.select().position(0, 1, 0), class_2350.field_11033);
        scene.world().moveSection(leftShaft, util.vector().of(0.0, 0.0, 2.0), 0);
        scene.world().moveSection(rightShaft, util.vector().of(0.0, 0.0, 2.0), 0);
        scene.idle(1);
        scene.world().moveSection(leftShaft, util.vector().of(-1.0, 0.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(1.0, 1.0, 0.0), 10);
        scene.idle(20);
        class_243 from = util.vector().centerOf(3, 1, 2);
        class_243 to = util.vector().centerOf(1, 2, 2);
        scene.overlay().showLine(PonderPalette.RED, from, to, 70);
        scene.idle(10);
        scene.overlay().showLine(PonderPalette.GREEN, to.method_1031(-1.0, -1.0, 0.0), from, 60);
        scene.overlay().showLine(PonderPalette.GREEN, from.method_1031(0.0, 3.0, 0.0), from, 60);
        scene.idle(20);
        scene.overlay().showText(60).colored(PonderPalette.RED).placeNearTarget().pointAt(to).text("Belts cannot connect in arbitrary directions");
        scene.idle(70);
        from = util.vector().centerOf(4, 1, 2);
        to = util.vector().centerOf(0, 1, 2);
        scene.world().moveSection(leftShaft, util.vector().of(1.0, 0.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(-1.0, -1.0, 0.0), 10);
        scene.idle(10);
        scene.overlay().showLine(PonderPalette.GREEN, from, to, 40);
        scene.idle(10);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).placeNearTarget().pointAt(to).attachKeyFrame().text("1. They can connect horizontally");
        scene.idle(20);
        Selection firstBelt = util.select().fromTo(4, 1, 1, 0, 1, 1);
        ElementLink<WorldSectionElement> belt = scene.world().showIndependentSection(firstBelt, class_2350.field_11035);
        scene.world().moveSection(belt, util.vector().of(0.0, 0.0, 1.0), 0);
        scene.idle(20);
        scene.world().hideIndependentSection(belt, class_2350.field_11035);
        scene.idle(15);
        from = util.vector().centerOf(3, 3, 2);
        to = util.vector().centerOf(1, 1, 2);
        scene.world().moveSection(leftShaft, util.vector().of(-1.0, 2.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(1.0, 0.0, 0.0), 10);
        scene.idle(10);
        scene.world().rotateSection(leftShaft, 0.0, 0.0, 25.0, 5);
        scene.world().rotateSection(rightShaft, 0.0, 0.0, 25.0, 5);
        scene.overlay().showLine(PonderPalette.GREEN, from, to, 40);
        scene.idle(10);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).placeNearTarget().pointAt(to).attachKeyFrame().text("2. They can connect diagonally");
        scene.idle(20);
        Selection secondBelt = util.select().fromTo(3, 3, 2, 1, 1, 2);
        belt = scene.world().showIndependentSection(secondBelt, class_2350.field_11035);
        scene.idle(20);
        scene.world().hideIndependentSection(belt, class_2350.field_11035);
        scene.idle(15);
        from = util.vector().centerOf(2, 4, 2);
        to = util.vector().centerOf(2, 1, 2);
        scene.world().moveSection(leftShaft, util.vector().of(-1.0, 1.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(1.0, 0.0, 0.0), 10);
        scene.idle(10);
        scene.world().rotateSection(rightShaft, 0.0, 0.0, -25.0, 5);
        scene.overlay().showLine(PonderPalette.GREEN, from, to, 40);
        scene.idle(10);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).placeNearTarget().pointAt(to).attachKeyFrame().text("3. They can connect vertically");
        scene.idle(20);
        Selection thirdBelt = util.select().fromTo(2, 1, 3, 2, 4, 3);
        belt = scene.world().showIndependentSection(thirdBelt, class_2350.field_11035);
        scene.world().moveSection(belt, util.vector().of(0.0, 0.0, -1.0), 0);
        scene.idle(20);
        scene.world().hideIndependentSection(belt, class_2350.field_11035);
        scene.idle(15);
        from = util.vector().centerOf(4, 1, 2);
        to = util.vector().centerOf(0, 1, 2);
        scene.world().moveSection(leftShaft, util.vector().of(2.0, -3.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(-2.0, 0.0, 0.0), 10);
        scene.idle(10);
        scene.world().rotateSection(rightShaft, 90.0, 0.0, -25.0, 5);
        scene.world().rotateSection(leftShaft, 90.0, 0.0, -50.0, 5);
        scene.overlay().showLine(PonderPalette.GREEN, from, to, 60);
        scene.idle(10);
        scene.overlay().showText(60).colored(PonderPalette.GREEN).placeNearTarget().pointAt(to).attachKeyFrame().text("4. And they can connect vertical shafts horizontally");
        scene.idle(20);
        Selection fourthBelt = util.select().fromTo(4, 1, 4, 0, 1, 4);
        belt = scene.world().showIndependentSection(fourthBelt, class_2350.field_11033);
        scene.world().moveSection(belt, util.vector().of(0.0, 0.001953125, -2.0), 0);
        scene.idle(40);
        scene.world().hideIndependentSection(belt, class_2350.field_11036);
        scene.idle(15);
        scene.world().hideIndependentSection(leftShaft, class_2350.field_11036);
        scene.world().hideIndependentSection(rightShaft, class_2350.field_11036);
        scene.idle(15);
        scene.world().showSection(firstBelt, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(secondBelt, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(thirdBelt, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(fourthBelt, class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(160).text("These are all possible directions. Belts can span any Length between 2 and 20 blocks");
        scene.markAsFinished();
    }

    public static void transport(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("belt_transport", "Using Mechanical Belts for Logistics");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(-0.6f * f.floatValue()));
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 2, 1, 5), class_2350.field_11033);
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 4, 3, 2), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 2, 0, 1, 2), class_2350.field_11035);
        scene.idle(10);
        scene.special().movePointOfInterest(util.grid().at(2, 2, 0));
        class_1799 stack = new class_1799((class_1935)class_1802.field_27071);
        ElementLink<EntityElement> item = scene.world().createItemEntity(util.vector().centerOf(0, 4, 2), util.vector().of(0.0, 0.0, 0.0), stack);
        scene.idle(13);
        scene.world().modifyEntity(item, class_1297::method_31472);
        class_2338 beltEnd = util.grid().at(0, 1, 2);
        scene.world().createItemOnBelt(beltEnd, class_2350.field_11033, stack);
        scene.idle(20);
        ElementLink<ParrotElement> parrot = scene.special().createBirb(util.vector().topOf(0, 1, 2).method_1031(0.0, -0.1875, 0.0), ParrotPose.FacePointOfInterestPose::new);
        scene.special().moveParrot(parrot, util.vector().of(1.78, 0.0, 0.0), 40);
        scene.special().movePointOfInterest(util.grid().at(1, 1, 3));
        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().topOf(beltEnd)).text("Moving belts will transport Items and other Entities");
        scene.idle(20);
        item = scene.world().createItemEntity(util.vector().centerOf(0, 4, 2), util.vector().of(0.0, 0.0, 0.0), stack);
        scene.special().movePointOfInterest(util.grid().at(0, 3, 2));
        scene.idle(10);
        scene.special().movePointOfInterest(beltEnd);
        scene.idle(3);
        scene.world().modifyEntity(item, class_1297::method_31472);
        scene.world().createItemOnBelt(beltEnd, class_2350.field_11033, stack);
        scene.idle(8);
        scene.special().movePointOfInterest(util.grid().at(3, 2, 1));
        scene.special().moveParrot(parrot, util.vector().of(2.1, 2.1, 0.0), 60);
        scene.idle(20);
        scene.special().movePointOfInterest(util.grid().at(5, 5, 2));
        scene.idle(30);
        scene.special().movePointOfInterest(util.grid().at(2, 1, 5));
        scene.idle(10);
        scene.special().moveParrot(parrot, util.vector().of(0.23, 0.0, 0.0), 5);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(10);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.special().movePointOfInterest(util.grid().at(2, 5, 4));
        class_243 topOf = util.vector().topOf(util.grid().at(3, 2, 2)).method_1031(-0.1, 0.3, 0.0);
        scene.overlay().showControls(topOf, Pointing.DOWN, 60).rightClick();
        scene.idle(10);
        scene.overlay().showText(60).placeNearTarget().pointAt(topOf.method_1023(0.0, 0.1, 0.0)).attachKeyFrame().text("Right-Click with an empty hand to take items off a belt");
        scene.idle(20);
        scene.world().removeItemsFromBelt(util.grid().at(3, 2, 2));
        scene.effects().indicateSuccess(util.grid().at(3, 2, 2));
        scene.idle(20);
        scene.special().changeBirbPose(parrot, ParrotPose.FaceCursorPose::new);
    }

    public static void beltsCanBeEncased(SceneBuilder builder, SceneBuildingUtil util) {
        int x;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("belt_casing", "Encasing Belts");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().layersFrom(1), class_2350.field_11033);
        scene.idle(20);
        class_1799 brassCasingItem = AllItems.BRASS_CASING.method_7854();
        class_1799 andesiteCasingItem = AllItems.ANDESITE_CASING.method_7854();
        class_2338 beltPos = util.grid().at(3, 1, 0);
        class_2338 beltPos2 = util.grid().at(0, 2, 3);
        class_2338 beltPos3 = util.grid().at(1, 4, 4);
        scene.overlay().showControls(util.vector().topOf(beltPos), Pointing.DOWN, 20).rightClick().withItem(brassCasingItem);
        scene.idle(7);
        scene.world().modifyBlock(beltPos, s -> (class_2680)s.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(beltPos2), Pointing.DOWN, 20).rightClick().withItem(andesiteCasingItem);
        scene.idle(7);
        scene.world().modifyBlock(beltPos2, s -> (class_2680)s.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
        scene.world().modifyBlockEntityNBT(util.select().position(beltPos2), BeltBlockEntity.class, nbt -> nbt.method_67494("Casing", BeltBlockEntity.CasingType.CODEC, (Object)BeltBlockEntity.CasingType.ANDESITE));
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(beltPos3, class_2350.field_11034), Pointing.RIGHT, 20).rightClick().withItem(brassCasingItem);
        scene.idle(7);
        scene.world().modifyBlock(beltPos3, s -> (class_2680)s.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
        scene.idle(20);
        scene.overlay().showText(80).text("Brass or Andesite Casing can be used to decorate Mechanical Belts").attachKeyFrame().pointAt(util.vector().centerOf(beltPos2));
        scene.idle(40);
        ArrayList<class_2338> brassBelts = new ArrayList<class_2338>();
        ArrayList<class_2338> andesiteBelts = new ArrayList<class_2338>();
        for (int z = 1; z <= 3; ++z) {
            brassBelts.add(beltPos.method_10077(z));
        }
        for (x = 1; x <= 3; ++x) {
            brassBelts.add(beltPos3.method_10089(x).method_10087(x));
        }
        for (x = 1; x <= 3; ++x) {
            andesiteBelts.add(beltPos2.method_10089(x));
        }
        Collections.shuffle(andesiteBelts);
        Collections.shuffle(brassBelts);
        for (class_2338 pos : andesiteBelts) {
            scene.idle(4);
            scene.world().modifyBlock(pos, s -> (class_2680)s.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
            scene.world().modifyBlockEntityNBT(util.select().position(pos), BeltBlockEntity.class, nbt -> nbt.method_67494("Casing", BeltBlockEntity.CasingType.CODEC, (Object)BeltBlockEntity.CasingType.ANDESITE));
        }
        for (class_2338 pos : brassBelts) {
            scene.idle(4);
            scene.world().modifyBlock(pos, s -> (class_2680)s.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
        }
        scene.idle(30);
        scene.addKeyframe();
        scene.overlay().showControls(util.vector().topOf(beltPos.method_10072()), Pointing.DOWN, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(beltPos.method_10072(), s -> (class_2680)s.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(false)), true);
        scene.overlay().showText(80).text("A wrench can be used to remove the casing").placeNearTarget().pointAt(util.vector().blockSurface(beltPos.method_10072(), class_2350.field_11039));
    }

    public static void depot(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("depot", "Using Depots");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().setBlock(util.grid().at(3, 2, 2), class_2246.field_10382.method_9564(), false);
        class_2338 depotPos = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().position(2, 1, 2), class_2350.field_11033);
        class_243 topOf = util.vector().topOf(depotPos);
        scene.overlay().showText(60).attachKeyFrame().text("Depots can serve as 'stationary' belt elements").placeNearTarget().pointAt(topOf);
        scene.idle(70);
        scene.overlay().showControls(topOf, Pointing.DOWN, 20).rightClick().withItem(new class_1799((class_1935)class_1802.field_27071));
        scene.idle(7);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11043, new class_1799((class_1935)class_1802.field_27071));
        scene.idle(10);
        scene.overlay().showText(70).attachKeyFrame().text("Right-Click to manually place or remove Items from it").placeNearTarget().pointAt(topOf);
        scene.idle(80);
        scene.overlay().showControls(topOf, Pointing.DOWN, 20).rightClick();
        scene.idle(7);
        scene.world().removeItemsFromBelt(depotPos);
        scene.effects().indicateSuccess(depotPos);
        scene.idle(20);
        scene.world().showSection(util.select().position(depotPos.method_10086(2)), class_2350.field_11035);
        scene.overlay().showText(70).attachKeyFrame().text("Just like Mechanical Belts, it can provide items to processing").placeNearTarget().pointAt(util.vector().blockSurface(depotPos.method_10086(2), class_2350.field_11039));
        class_1799 bottle = new class_1799((class_1935)class_1802.field_8550);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11043, bottle);
        scene.idle(20);
        scene.world().modifyBlockEntityNBT(util.select().position(depotPos.method_10086(2)), SpoutBlockEntity.class, nbt -> nbt.method_10569("ProcessingTicks", 20));
        scene.idle(20);
        scene.world().removeItemsFromBelt(depotPos);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11036, new class_1799((class_1935)class_1802.field_8705));
        scene.world().modifyBlockEntityNBT(util.select().position(depotPos.method_10086(2)), SpoutBlockEntity.class, nbt -> nbt.method_10556("Splash", true));
        scene.idle(30);
        scene.world().removeItemsFromBelt(depotPos);
        scene.world().hideSection(util.select().position(depotPos.method_10086(2)), class_2350.field_11035);
        scene.idle(20);
        ElementLink<WorldSectionElement> spout = scene.world().showIndependentSection(util.select().position(depotPos.method_10086(2).method_10067()), class_2350.field_11035);
        scene.world().moveSection(spout, util.vector().of(1.0, 0.0, 0.0), 0);
        class_2338 pressPos = depotPos.method_10086(2).method_10067();
        class_1799 copper = new class_1799((class_1935)class_1802.field_27022);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11043, copper);
        class_243 depotCenter = util.vector().centerOf(depotPos);
        scene.idle(10);
        Class<MechanicalPressBlockEntity> type = MechanicalPressBlockEntity.class;
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
        scene.idle(15);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(depotCenter.method_1031(0.0, 0.5, 0.0), copper));
        scene.world().removeItemsFromBelt(depotPos);
        class_1799 sheet = AllItems.COPPER_SHEET.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11036, sheet);
        scene.idle(20);
        scene.world().hideIndependentSection(spout, class_2350.field_11035);
        scene.idle(10);
        Selection fanSelect = util.select().fromTo(4, 1, 3, 5, 2, 2).add(util.select().position(3, 1, 2)).add(util.select().position(5, 0, 2));
        scene.world().showSection(fanSelect, class_2350.field_11035);
        ElementLink<WorldSectionElement> water = scene.world().showIndependentSection(util.select().position(3, 1, 0), class_2350.field_11035);
        scene.world().moveSection(water, util.vector().of(0.0, 1.0, 2.0), 0);
        scene.idle(30);
        scene.world().hideSection(fanSelect, class_2350.field_11035);
        scene.world().hideIndependentSection(water, class_2350.field_11035);
        scene.idle(30);
        scene.world().showSection(util.select().fromTo(2, 1, 4, 2, 1, 5).add(util.select().position(2, 0, 5)), class_2350.field_11033);
        class_2338 armPos = util.grid().at(2, 1, 4);
        scene.overlay().showText(70).attachKeyFrame().text("...as well as provide Items to Mechanical Arms").placeNearTarget().pointAt(util.vector().blockSurface(armPos, class_2350.field_11039));
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, class_1799.field_8037, 0);
        scene.idle(37);
        scene.world().removeItemsFromBelt(depotPos);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, sheet, -1);
    }
}

