/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.RecipeGridHandler;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class MechanicalCrafterBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity {
    protected CrafterItemHandler inventory;
    public RecipeGridHandler.GroupedItems groupedItems = new RecipeGridHandler.GroupedItems();
    protected ConnectedInputHandler.ConnectedInput input = new ConnectedInputHandler.ConnectedInput();
    @Nullable
    protected class_1263 invCap;
    protected boolean reRender;
    public Phase phase;
    public int countDown;
    public boolean covered;
    protected boolean wasPoweredBefore;
    public RecipeGridHandler.GroupedItems groupedItemsBeforeCraft;
    private InvManipulationBehaviour inserting;
    private class_1799 scriptedResult = class_1799.field_8037;

    public MechanicalCrafterBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_CRAFTER, pos, state);
        this.setLazyTickRate(20);
        this.phase = Phase.IDLE;
        this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
        this.inventory = new CrafterItemHandler();
        this.wasPoweredBefore = true;
    }

    public class_1263 getInvCapability() {
        if (this.invCap == null) {
            this.invCap = this.input.getItemHandler(this.method_10997(), this.method_11016());
        }
        return this.invCap;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        behaviours.add(this.inserting);
        behaviours.add(new EdgeInteractionBehaviour(this, ConnectedInputHandler::toggleConnection).connectivity(ConnectedInputHandler::shouldConnect).require(item -> item.method_40131().method_40220(AllItemTags.TOOLS_WRENCH)));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CRAFTER, AllAdvancements.CRAFTER_LAZY);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (!class_3532.method_15347((float)this.getSpeed(), (float)0.0f)) {
            this.award(AllAdvancements.CRAFTER);
            if (Math.abs(this.getSpeed()) < 5.0f) {
                this.award(AllAdvancements.CRAFTER_LAZY);
            }
        }
    }

    public void blockChanged() {
        this.removeBehaviour(InvManipulationBehaviour.TYPE);
        this.inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        this.attachBehaviourLate(this.inserting);
    }

    public BlockFace getTargetFace(class_1937 world, class_2338 pos, class_2680 state) {
        return new BlockFace(pos, MechanicalCrafterBlock.getTargetDirection(state));
    }

    public class_2350 getTargetDirection() {
        return MechanicalCrafterBlock.getTargetDirection(this.method_11010());
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        if (this.input == null) {
            return;
        }
        this.input.write(view.method_71461("ConnectedInput"));
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        this.inventory.write(view);
        this.input.write(view.method_71461("ConnectedInput"));
        if (this.groupedItemsBeforeCraft != null) {
            view.method_71468("GroupedItemsBeforeCraft", RecipeGridHandler.GroupedItems.CODEC, (Object)this.groupedItemsBeforeCraft);
            this.groupedItemsBeforeCraft = null;
        }
        view.method_71468("GroupedItems", RecipeGridHandler.GroupedItems.CODEC, (Object)this.groupedItems);
        view.method_71469("Phase", this.phase.name());
        view.method_71465("CountDown", this.countDown);
        view.method_71472("Cover", this.covered);
        super.write(view, clientPacket);
        if (clientPacket && this.reRender) {
            view.method_71472("Redraw", true);
            this.reRender = false;
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        Phase phaseBefore = this.phase;
        RecipeGridHandler.GroupedItems before = this.groupedItems;
        this.inventory.read(view);
        this.input.read(view.method_71434("ConnectedInput"));
        this.groupedItems = (RecipeGridHandler.GroupedItems)view.method_71426("GroupedItems", RecipeGridHandler.GroupedItems.CODEC).orElseThrow();
        this.phase = Phase.IDLE;
        String name = view.method_71428("Phase", "");
        for (Phase phase : Phase.values()) {
            if (!phase.name().equals(name)) continue;
            this.phase = phase;
        }
        this.countDown = view.method_71424("CountDown", 0);
        this.covered = view.method_71433("Cover", false);
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (view.method_71433("Redraw", false)) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
        }
        if (phaseBefore != this.phase && this.phase == Phase.CRAFTING) {
            this.groupedItemsBeforeCraft = view.method_71426("GroupedItemsBeforeCraft", RecipeGridHandler.GroupedItems.CODEC).orElse(before);
        }
        if (phaseBefore == Phase.EXPORTING && this.phase == Phase.WAITING) {
            if (before.onlyEmptyItems()) {
                return;
            }
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)MechanicalCrafterBlock.HORIZONTAL_FACING);
            class_243 vec = class_243.method_24954((class_2382)facing.method_62675()).method_1021(0.75).method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
            class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(this.method_11010());
            vec = vec.method_1019(class_243.method_24954((class_2382)targetDirection.method_62675()).method_1021(1.0));
            this.field_11863.method_8406((class_2394)class_2398.field_11205, vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0);
        }
    }

    public int getCountDownSpeed() {
        if (this.getSpeed() == 0.0f) {
            return 0;
        }
        return class_3532.method_15340((int)((int)Math.abs(this.getSpeed())), (int)4, (int)250);
    }

    @Override
    public void tick() {
        boolean runLogic;
        super.tick();
        if (this.phase == Phase.ACCEPTING) {
            return;
        }
        boolean onClient = this.field_11863.field_9236;
        boolean bl = runLogic = !onClient || this.isVirtual();
        if (this.wasPoweredBefore != this.field_11863.method_49803(this.field_11867)) {
            this.wasPoweredBefore = this.field_11863.method_49803(this.field_11867);
            if (this.wasPoweredBefore) {
                if (!runLogic) {
                    return;
                }
                this.checkCompletedRecipe(true);
            }
        }
        if (this.phase == Phase.ASSEMBLING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                class_1799 result;
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                if (RecipeGridHandler.getTargetingCrafter(this) != null) {
                    this.phase = Phase.EXPORTING;
                    this.countDown = this.groupedItems.onlyEmptyItems() ? 0 : 1000;
                    this.sendData();
                    return;
                }
                class_1799 class_17992 = result = this.isVirtual() ? this.scriptedResult : RecipeGridHandler.tryToApplyRecipe((class_3218)this.field_11863, this.groupedItems);
                if (result != null) {
                    ArrayList containers = new ArrayList();
                    this.groupedItems.grid.values().forEach(stack -> {
                        class_1799 remainder = stack.method_7909().method_7858();
                        if (!remainder.method_7960()) {
                            containers.add(remainder);
                        }
                    });
                    this.groupedItemsBeforeCraft = this.groupedItems;
                    this.groupedItems = new RecipeGridHandler.GroupedItems(result);
                    for (int i = 0; i < containers.size(); ++i) {
                        class_1799 stack2 = (class_1799)containers.get(i);
                        RecipeGridHandler.GroupedItems container = new RecipeGridHandler.GroupedItems();
                        container.grid.put(Pair.of(i, 0), stack2);
                        container.mergeOnto(this.groupedItems, Pointing.LEFT);
                    }
                    this.phase = Phase.CRAFTING;
                    this.countDown = 2000;
                    this.sendData();
                    return;
                }
                this.ejectWholeGrid();
                return;
            }
        }
        if (this.phase == Phase.EXPORTING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                MechanicalCrafterBlockEntity targetingCrafter = RecipeGridHandler.getTargetingCrafter(this);
                if (targetingCrafter == null) {
                    this.ejectWholeGrid();
                    return;
                }
                boolean empty = this.groupedItems.onlyEmptyItems();
                Pointing pointing = (Pointing)((Object)this.method_11010().method_11654(MechanicalCrafterBlock.POINTING));
                this.groupedItems.mergeOnto(targetingCrafter.groupedItems, pointing);
                this.groupedItems = new RecipeGridHandler.GroupedItems();
                float pitch = (float)(targetingCrafter.groupedItems.grid.size() * 1) / 16.0f + 0.5f;
                if (!empty) {
                    AllSoundEvents.CRAFTER_CLICK.playOnServer(this.field_11863, (class_2382)this.field_11867, 1.0f, pitch);
                }
                this.phase = Phase.WAITING;
                this.countDown = 0;
                this.sendData();
                targetingCrafter.continueIfAllPrecedingFinished();
                targetingCrafter.sendData();
                return;
            }
        }
        if (this.phase == Phase.CRAFTING) {
            if (onClient) {
                class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)MechanicalCrafterBlock.HORIZONTAL_FACING);
                float progress = (float)this.countDown / 2000.0f;
                class_243 facingVec = class_243.method_24954((class_2382)facing.method_62675());
                class_243 vec = facingVec.method_1021(0.65).method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
                class_243 offset = VecHelper.offsetRandomly(class_243.field_1353, this.field_11863.field_9229, 0.125f).method_18806(VecHelper.axisAlingedPlaneOf(facingVec)).method_1029().method_1021((double)(progress * 0.5f)).method_1019(vec);
                if (progress > 0.5f) {
                    this.field_11863.method_8406((class_2394)class_2398.field_11205, offset.field_1352, offset.field_1351, offset.field_1350, 0.0, 0.0, 0.0);
                }
                if (!this.groupedItemsBeforeCraft.grid.isEmpty() && progress < 0.5f && this.groupedItems.grid.containsKey(Pair.of(0, 0))) {
                    class_1799 stack3 = this.groupedItems.grid.get(Pair.of(0, 0));
                    this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
                    for (int i = 0; i < 10; ++i) {
                        class_243 randVec = VecHelper.offsetRandomly(class_243.field_1353, this.field_11863.field_9229, 0.125f).method_18806(VecHelper.axisAlingedPlaneOf(facingVec)).method_1029().method_1021(0.25);
                        class_243 offset2 = randVec.method_1019(vec);
                        randVec = randVec.method_1021((double)0.35f);
                        this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, stack3), offset2.field_1352, offset2.field_1351, offset2.field_1350, randVec.field_1352, randVec.field_1351, randVec.field_1350);
                    }
                }
            }
            int prev = this.countDown;
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 1000 && prev >= 1000) {
                AllSoundEvents.CRAFTER_CLICK.playOnServer(this.field_11863, (class_2382)this.field_11867, 1.0f, 2.0f);
                AllSoundEvents.CRAFTER_CRAFT.playOnServer(this.field_11863, (class_2382)this.field_11867);
            }
            if (this.countDown < 0) {
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                this.tryInsert();
                return;
            }
        }
        if (this.phase == Phase.INSERTING && runLogic && this.isTargetingBelt()) {
            this.tryInsert();
        }
    }

    protected boolean isTargetingBelt() {
        DirectBeltInputBehaviour behaviour = this.getTargetingBelt();
        return behaviour != null && behaviour.canInsertFromSide(this.getTargetDirection());
    }

    protected DirectBeltInputBehaviour getTargetingBelt() {
        class_2338 targetPos = this.field_11867.method_10093(this.getTargetDirection());
        return BlockEntityBehaviour.get((class_1922)this.field_11863, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public void tryInsert() {
        if (!this.inserting.hasInventory() && !this.isTargetingBelt()) {
            this.ejectWholeGrid();
            return;
        }
        boolean chagedPhase = this.phase != Phase.INSERTING;
        LinkedList<Pair<Integer, Integer>> inserted = new LinkedList<Pair<Integer, Integer>>();
        DirectBeltInputBehaviour behaviour = this.getTargetingBelt();
        for (Map.Entry<Pair<Integer, Integer>, class_1799> entry : this.groupedItems.grid.entrySet()) {
            class_1799 remainder;
            Pair<Integer, Integer> pair = entry.getKey();
            class_1799 stack = entry.getValue();
            BlockFace face = this.getTargetFace(this.field_11863, this.field_11867, this.method_11010());
            class_1799 class_17992 = remainder = behaviour == null ? this.inserting.insert(stack.method_7972()) : behaviour.handleInsertion(stack, face.getFace(), false);
            if (!remainder.method_7960()) {
                stack.method_7939(remainder.method_7947());
                continue;
            }
            inserted.add(pair);
        }
        inserted.forEach(this.groupedItems.grid::remove);
        if (this.groupedItems.grid.isEmpty()) {
            this.ejectWholeGrid();
        } else {
            this.phase = Phase.INSERTING;
        }
        if (!inserted.isEmpty() || chagedPhase) {
            this.sendData();
        }
    }

    public void ejectWholeGrid() {
        List<MechanicalCrafterBlockEntity> chain = RecipeGridHandler.getAllCraftersOfChain(this);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterBlockEntity::eject);
    }

    public void eject() {
        class_2680 blockState = this.method_11010();
        boolean present = blockState.method_27852((class_2248)AllBlocks.MECHANICAL_CRAFTER);
        class_243 vec = present ? class_243.method_24954((class_2382)((class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_62675()).method_1021(0.75) : class_243.field_1353;
        class_243 ejectPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(vec);
        this.groupedItems.grid.forEach((pair, stack) -> this.dropItem(ejectPos, (class_1799)stack));
        if (!this.inventory.getStack().method_7960()) {
            this.dropItem(ejectPos, this.inventory.onExtract(this.inventory.getStack()));
        }
        this.phase = Phase.IDLE;
        this.groupedItems = new RecipeGridHandler.GroupedItems();
        this.inventory.setStack(class_1799.field_8037);
        this.sendData();
    }

    public void dropItem(class_243 ejectPos, class_1799 stack) {
        class_1542 itemEntity = new class_1542(this.field_11863, ejectPos.field_1352, ejectPos.field_1351, ejectPos.field_1350, stack);
        itemEntity.method_6988();
        this.field_11863.method_8649((class_1297)itemEntity);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (this.phase == Phase.IDLE && this.craftingItemPresent()) {
            this.checkCompletedRecipe(false);
        }
        if (this.phase == Phase.INSERTING) {
            this.tryInsert();
        }
    }

    public boolean craftingItemPresent() {
        return !this.inventory.getStack().method_7960();
    }

    public boolean craftingItemOrCoverPresent() {
        return !this.inventory.getStack().method_7960() || this.covered;
    }

    public void checkCompletedRecipe(boolean poweredStart) {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        List<MechanicalCrafterBlockEntity> chain = RecipeGridHandler.getAllCraftersOfChainIf(this, poweredStart ? MechanicalCrafterBlockEntity::craftingItemPresent : MechanicalCrafterBlockEntity::craftingItemOrCoverPresent, poweredStart);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterBlockEntity::begin);
    }

    protected void begin() {
        this.phase = Phase.ACCEPTING;
        this.groupedItems = new RecipeGridHandler.GroupedItems(this.inventory.onExtract(this.inventory.getStack()));
        this.inventory.setStack(class_1799.field_8037);
        if (RecipeGridHandler.getPrecedingCrafters(this).isEmpty()) {
            this.phase = Phase.ASSEMBLING;
            this.countDown = 1;
        }
        this.sendData();
    }

    protected void continueIfAllPrecedingFinished() {
        List<MechanicalCrafterBlockEntity> preceding = RecipeGridHandler.getPrecedingCrafters(this);
        for (MechanicalCrafterBlockEntity blockEntity : preceding) {
            if (blockEntity.phase == Phase.WAITING) continue;
            return;
        }
        this.phase = Phase.ASSEMBLING;
        this.countDown = 1;
    }

    public void connectivityChanged() {
        this.reRender = true;
        this.sendData();
        this.invCap = null;
    }

    public CrafterItemHandler getInventory() {
        return this.inventory;
    }

    public void setScriptedResult(class_1799 scriptedResult) {
        this.scriptedResult = scriptedResult;
    }

    public ConnectedInputHandler.ConnectedInput getInput() {
        return this.input;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        this.input.data.replaceAll(transform::applyWithoutOffset);
        this.notifyUpdate();
    }

    public static enum Phase {
        IDLE,
        ACCEPTING,
        ASSEMBLING,
        EXPORTING,
        WAITING,
        CRAFTING,
        INSERTING;

    }

    public class CrafterItemHandler
    implements class_1278 {
        public static final Optional<Integer> LIMIT = Optional.of(1);
        private static final int[] SLOTS = new int[]{0};
        private class_1799 stack = class_1799.field_8037;

        public int[] method_5494(class_2350 side) {
            return SLOTS;
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return MechanicalCrafterBlockEntity.this.phase == Phase.IDLE && !MechanicalCrafterBlockEntity.this.covered;
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return false;
        }

        public class_1799 onExtract(class_1799 stack) {
            return this.removeMaxSize(stack, LIMIT);
        }

        public int method_5444() {
            return 1;
        }

        public int method_5439() {
            return 1;
        }

        public class_1799 method_5438(int slot) {
            if (slot != 0) {
                return class_1799.field_8037;
            }
            return this.stack;
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot == 0) {
                this.setStack(stack);
            }
        }

        public void method_5431() {
            MechanicalCrafterBlockEntity.this.notifyUpdate();
            if (this.stack.method_7960()) {
                return;
            }
            if (MechanicalCrafterBlockEntity.this.phase == Phase.IDLE) {
                MechanicalCrafterBlockEntity.this.checkCompletedRecipe(false);
            }
        }

        public class_1799 getStack() {
            return this.stack;
        }

        public void setStack(class_1799 stack) {
            if (!stack.method_7960()) {
                MechanicalCrafterBlockEntity.this.method_10997().method_8396(null, MechanicalCrafterBlockEntity.this.method_11016(), class_3417.field_14667, class_3419.field_15245, 0.25f, 0.5f);
            }
            if (stack != class_1799.field_8037) {
                this.setMaxSize(stack, LIMIT);
            }
            this.stack = stack;
        }

        public void write(class_11372 view) {
            view.method_71468("Stack", class_1799.field_49266, (Object)this.stack);
        }

        public void read(class_11368 view) {
            this.stack = view.method_71426("Stack", class_1799.field_49266).orElse(class_1799.field_8037);
        }
    }
}

