/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.box;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.chute.ChuteBlock;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.PackageDestroyPacket;
import com.zurrtum.create.infrastructure.packet.s2c.PackageSpawnPacket;
import java.lang.ref.WeakReference;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import net.minecraft.class_8103;
import net.minecraft.class_8942;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class PackageEntity
extends class_1309 {
    private class_1297 originalEntity;
    public class_1799 box;
    public int insertionDelay;
    public class_243 vec2 = class_243.field_1353;
    public class_243 vec3 = class_243.field_1353;
    public WeakReference<class_1657> tossedBy = new WeakReference<Object>(null);

    public PackageEntity(class_1299<? extends PackageEntity> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.box = class_1799.field_8037;
        this.method_36456(this.field_5974.method_43057() * 360.0f);
        this.method_5847(this.method_36454());
        this.field_5982 = this.method_36454();
        this.insertionDelay = 30;
    }

    public PackageEntity(class_1937 worldIn, double x, double y, double z) {
        this(AllEntityTypes.PACKAGE, worldIn);
        this.method_5814(x, y, z);
        this.method_18382();
    }

    public void method_5784(class_1313 type, class_243 movement) {
        super.method_5784(type, movement);
        if (movement.method_1027() >= (double)0.01f) {
            this.field_6007 = true;
        }
    }

    public static PackageEntity fromDroppedItem(class_1937 world, class_1297 originalEntity, class_1799 itemstack) {
        PackageEntity packageEntity = new PackageEntity(AllEntityTypes.PACKAGE, world);
        class_243 position = originalEntity.method_19538();
        packageEntity.method_33574(position);
        packageEntity.setBox(itemstack);
        packageEntity.method_18799(originalEntity.method_18798().method_1021(1.5));
        packageEntity.originalEntity = originalEntity;
        if (world != null && !world.field_9236 && ChuteBlock.isChute(world.method_8320(class_2338.method_49637((double)position.field_1352, (double)(position.field_1351 + 0.5), (double)position.field_1350)))) {
            packageEntity.method_36456((int)packageEntity.method_36454() / 90 * 90);
        }
        return packageEntity;
    }

    public static PackageEntity fromItemStack(class_1937 world, class_243 position, class_1799 itemstack) {
        PackageEntity packageEntity = new PackageEntity(AllEntityTypes.PACKAGE, world);
        packageEntity.method_33574(position);
        packageEntity.setBox(itemstack);
        return packageEntity;
    }

    public class_1799 method_31480() {
        return this.box.method_7972();
    }

    public static class_5132.class_5133 createPackageAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 1.0);
    }

    public void method_5750(double x, double y, double z) {
        this.method_18799(this.method_18798().method_1031(x, y, z).method_1021(0.5));
    }

    public String getAddress() {
        return (String)this.box.method_58694(AllDataComponents.PACKAGE_ADDRESS);
    }

    public void method_5773() {
        if (this.field_5953) {
            this.verifyInitialEntity();
            this.originalEntity = null;
        }
        this.insertionDelay = Math.min(this.insertionDelay + 1, 30);
        super.method_5773();
        if (!PackageItem.isPackage(this.box)) {
            this.method_31472();
        }
    }

    protected void verifyInitialEntity() {
        class_1297 class_12972 = this.originalEntity;
        if (!(class_12972 instanceof class_1542)) {
            return;
        }
        class_1542 itemEntity = (class_1542)class_12972;
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71370(), Create.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.method_56673());
            itemEntity.method_5652((class_11372)view);
            if (view.method_71475().method_68083("PickupDelay", 0) != Short.MAX_VALUE) {
                return;
            }
            this.method_31472();
        }
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.box == null) {
            return super.method_55694(pose);
        }
        return class_4048.method_18385((float)PackageItem.getWidth(this.box), (float)PackageItem.getHeight(this.box));
    }

    public class_1799 getBox() {
        return this.box;
    }

    public static boolean centerPackage(class_1297 entity, class_243 target) {
        if (!(entity instanceof PackageEntity)) {
            return true;
        }
        PackageEntity packageEntity = (PackageEntity)entity;
        return packageEntity.decreaseInsertionTimer(target);
    }

    public boolean decreaseInsertionTimer(@Nullable class_243 targetSpot) {
        if (targetSpot != null) {
            this.method_18799(this.method_18798().method_1021(0.75).method_18805(1.0, 0.25, 1.0));
            class_243 pos = this.method_19538().method_1019(targetSpot.method_1020(this.method_19538()).method_1021((double)0.2f));
            this.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            float yawTarget = (int)this.method_36454() / 90 * 90;
            this.method_36456(AngleHelper.angleLerp(0.5, this.method_36454(), yawTarget));
        }
        this.insertionDelay = Math.max(this.insertionDelay - 3, 0);
        return this.insertionDelay == 0;
    }

    public void setBox(class_1799 box) {
        this.box = box.method_7972();
        this.method_18382();
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_30949(class_1297 pEntity) {
        return pEntity instanceof PackageEntity && pEntity.method_5829().field_1325 < this.method_5829().field_1322 + 0.125;
    }

    public class_1269 method_5688(class_1657 pPlayer, class_1268 pHand) {
        if (!pPlayer.method_5998(pHand).method_7960()) {
            return super.method_5688(pPlayer, pHand);
        }
        if (pPlayer.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        pPlayer.method_6122(pHand, this.box);
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.2f, 0.75f + this.method_37908().field_9229.method_43057());
        this.method_5650(class_1297.class_5529.field_26999);
        return class_1269.field_5812;
    }

    public void method_5697(class_1297 entityIn) {
        boolean isOtherPackage = entityIn instanceof PackageEntity;
        if (!isOtherPackage && this.tossedBy.get() != null) {
            this.tossedBy = new WeakReference<Object>(null);
        }
        if (isOtherPackage) {
            if (entityIn.method_5829().field_1322 < this.method_5829().field_1325) {
                super.method_5697(entityIn);
            }
        } else if (entityIn.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entityIn);
        }
    }

    public class_243 method_52538(class_1297 entity) {
        return this.method_19538().method_1031(0.0, (double)entity.method_18377(this.method_18376()).comp_2186(), 0.0);
    }

    protected class_243 method_52533(class_1297 entity, class_4048 dimensions, float partialTick) {
        return super.method_52533(entity, dimensions, partialTick).method_1031(0.0, 0.125, 0.0);
    }

    protected void method_5622(class_2680 state) {
        super.method_5622(state);
        if (!this.method_5805()) {
            return;
        }
        if (state.method_26204() == class_2246.field_10382 || state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            this.destroy(this.method_48923().method_48824());
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        class_1665 persistentProjectileEntity;
        if (this.method_37908().field_9236 || !this.method_5805()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42242)) {
            this.method_5650(class_1297.class_5529.field_26998);
            return false;
        }
        if (source.equals(this.method_48923().method_48822()) && (this.method_5765() || this.insertionDelay < 20)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42250)) {
            return false;
        }
        if (this.method_5679((class_3218)this.method_37908(), source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42249)) {
            this.destroy(source);
            this.method_5650(class_1297.class_5529.field_26998);
            return false;
        }
        if (source.method_48789(class_8103.field_42246)) {
            if (this.method_5809()) {
                this.takeDamage(source, 0.15f);
            } else {
                this.method_20803(100);
            }
            return false;
        }
        class_1297 class_12972 = source.method_5526();
        boolean shotCanPierce = class_12972 instanceof class_1665 ? (persistentProjectileEntity = (class_1665)class_12972).method_7447() > 0 : false;
        class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!player.method_31549().field_7476) {
                return false;
            }
        }
        this.destroy(source);
        this.method_5650(class_1297.class_5529.field_26998);
        return shotCanPierce;
    }

    private void takeDamage(class_1282 source, float amount) {
        float hp = this.method_6032();
        if ((hp -= amount) <= 0.5f) {
            this.destroy(source);
            this.method_5650(class_1297.class_5529.field_26998);
        } else {
            this.method_6033(hp);
        }
    }

    private void destroy(class_1282 source) {
        AllSoundEvents.PACKAGE_POP.playOnServer(this.method_37908(), (class_2382)this.method_24515());
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.method_16080(serverLevel, source);
            serverLevel.method_14178().method_18754((class_1297)this, (class_2596)new PackageDestroyPacket(this.method_5829().method_1005(), this.box));
        }
    }

    protected void method_16080(class_3218 level, class_1282 pDamageSource) {
        super.method_16080(level, pDamageSource);
        ItemStackHandler contents = PackageItem.getContents(this.box);
        int size = contents.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1826 sei;
            class_1299 entitytype;
            class_1297 entity;
            class_1799 itemstack = contents.method_5438(i);
            class_1792 class_17922 = itemstack.method_7909();
            if (class_17922 instanceof class_1826 && (entity = (entitytype = (sei = (class_1826)class_17922).method_8015((class_7225.class_7874)this.method_56673(), itemstack)).method_5894(level, itemstack, null, this.method_24515(), class_3730.field_16465, false, false)) != null) {
                itemstack.method_7934(1);
            }
            if (itemstack.method_7960()) continue;
            class_1542 entityIn = new class_1542((class_1937)level, this.method_23317(), this.method_23318(), this.method_23321(), itemstack);
            level.method_8649((class_1297)entityIn);
        }
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.box = view.method_71426("Box", class_1799.field_24671).orElse(class_1799.field_8037);
        this.method_18382();
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        if (!this.box.method_7960()) {
            view.method_71468("Box", class_1799.field_24671, (Object)this.box);
        }
    }

    public class_1799 method_6118(class_1304 pSlot) {
        if (pSlot == class_1304.field_6173) {
            return this.getBox();
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 pSlot, class_1799 pStack) {
        if (pSlot == class_1304.field_6173) {
            this.setBox(pStack);
        }
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public class_1268 method_6058() {
        return class_1268.field_5808;
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new PackageSpawnPacket(this, entityTrackerEntry);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        PackageSpawnPacket spawnPacket = (PackageSpawnPacket)packet;
        this.setBox(spawnPacket.getBox());
    }

    public float method_6017() {
        return 1.5f;
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_40968, class_3417.field_40968);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return null;
    }

    @Nullable
    protected class_3414 method_6002() {
        return null;
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_5753() {
        return this.box.method_57826(class_9334.field_54273) || super.method_5753();
    }
}

