/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_10355;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;

public interface BasinRecipe
extends class_1860<BasinInput> {
    public static final Map<class_1867, List<SizedIngredient>> SHAPELESS_CACHE = new IdentityHashMap<class_1867, List<SizedIngredient>>();
    public static final Map<class_1869, List<SizedIngredient>> SHAPED_CACHE = new IdentityHashMap<class_1869, List<SizedIngredient>>();

    public static boolean matchCraftingRecipe(BasinInput input, class_1867 recipe, class_1937 world) {
        return BasinRecipe.matchCraftingRecipe(input, recipe, world, SHAPELESS_CACHE, SizedIngredient::of);
    }

    public static boolean matchCraftingRecipe(BasinInput input, class_1869 recipe, class_1937 world) {
        return BasinRecipe.matchCraftingRecipe(input, recipe, world, SHAPED_CACHE, SizedIngredient::of);
    }

    private static <T extends class_3955> boolean matchCraftingRecipe(BasinInput input, T recipe, class_1937 world, Map<T, List<SizedIngredient>> ingredientCache, Function<T, List<SizedIngredient>> recipeToIngredients) {
        ServerFilteringBehaviour filter = input.filter();
        if (filter == null) {
            return false;
        }
        class_1799 result = recipe.method_8116(null, (class_7225.class_7874)world.method_30349());
        if (!filter.test(result)) {
            return false;
        }
        List<SizedIngredient> ingredients = ingredientCache.computeIfAbsent(recipe, recipeToIngredients);
        if (ingredients.isEmpty()) {
            return false;
        }
        List<class_1799> outputs = BasinRecipe.tryCraft(input, ingredients);
        if (outputs == null) {
            return false;
        }
        outputs.add(result);
        return input.acceptOutputs(outputs, List.of(), true);
    }

    @Nullable
    public static List<class_1799> tryCraft(BasinInput input, List<SizedIngredient> ingredients) {
        int ingredientIndex;
        if (ingredients.isEmpty()) {
            return new ArrayList<class_1799>();
        }
        ArrayList<class_1799> usings = new ArrayList<class_1799>();
        LinkedList<class_1799> inputs = new LinkedList<class_1799>();
        int ingredientSize = ingredients.size();
        class_1263 inventory = input.items();
        int itemIndex = 0;
        int inventorySize = inventory.method_5439();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.getCount();
            while (itemIndex < inventorySize) {
                class_1799 stack = inventory.method_5438(itemIndex);
                if (!stack.method_7960()) {
                    if (ingredient.test(stack)) {
                        int count = stack.method_7947();
                        if (count > remainder) {
                            usings.add(stack.method_46651(remainder));
                            ++itemIndex;
                            continue block0;
                        }
                        usings.add(stack);
                        if (count == remainder) {
                            ++itemIndex;
                            continue block0;
                        }
                        remainder -= count;
                    } else {
                        inputs.add(stack);
                    }
                }
                ++itemIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                class_1799 stack = (class_1799)iterator.next();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.method_7947();
                if (count > remainder) {
                    usings.add(stack.method_46651(remainder));
                    ++ingredientIndex;
                    break block0;
                }
                usings.add(stack);
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return null;
        }
        while (ingredientIndex < ingredientSize) {
            block18: {
                SizedIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.getCount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    class_1799 stack = (class_1799)iterator.next();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                    } else {
                        usings.add(stack);
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block18;
                }
                return null;
            }
            ++ingredientIndex;
        }
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (class_1799 stack : usings) {
            class_1792 item = stack.method_7909();
            int count = stack.method_7947();
            for (int i = 0; i < count; ++i) {
                class_1799 remainder = item.method_7858();
                if (remainder == class_1799.field_8037) continue;
                outputs.add(remainder);
            }
        }
        return outputs;
    }

    public static boolean matchFluidIngredient(BasinInput input, @Nullable FluidIngredient ingredient) {
        if (ingredient == null) {
            return false;
        }
        int remainder = ingredient.amount();
        for (FluidStack stack : input.fluids()) {
            if (!ingredient.test(stack)) continue;
            int amount = stack.getAmount();
            if (amount >= remainder) {
                return true;
            }
            remainder -= amount;
        }
        return false;
    }

    public static boolean matchFluidIngredient(BasinInput input, List<FluidIngredient> ingredients) {
        int ingredientIndex;
        if (ingredients.isEmpty()) {
            return true;
        }
        LinkedList<FluidStack> inputs = new LinkedList<FluidStack>();
        int ingredientSize = ingredients.size();
        FluidInventory inventory = input.fluids();
        int fluidIndex = 0;
        int inventorySize = inventory.size();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.amount();
            while (fluidIndex < inventorySize) {
                FluidStack stack = inventory.getStack(fluidIndex);
                if (!stack.isEmpty()) {
                    if (ingredient.test(stack)) {
                        int amount = stack.getAmount();
                        if (amount >= remainder) {
                            ++fluidIndex;
                            continue block0;
                        }
                        remainder -= amount;
                    } else {
                        inputs.add(stack);
                    }
                }
                ++fluidIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                FluidStack stack = (FluidStack)iterator.next();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.getAmount();
                if (count >= remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return false;
        }
        while (ingredientIndex < ingredientSize) {
            block12: {
                FluidIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.amount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    FluidStack stack = (FluidStack)iterator.next();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count < remainder) {
                        remainder -= count;
                        continue;
                    }
                    break block12;
                }
                return false;
            }
            ++ingredientIndex;
        }
        return true;
    }

    public static boolean applyCraftingRecipe(BasinInput input, class_1869 recipe, class_1937 world) {
        return BasinRecipe.applyCraftingRecipe(input, recipe, world, SHAPED_CACHE, SizedIngredient::of);
    }

    public static boolean applyCraftingRecipe(BasinInput input, class_1867 recipe, class_1937 world) {
        return BasinRecipe.applyCraftingRecipe(input, recipe, world, SHAPELESS_CACHE, SizedIngredient::of);
    }

    private static <T extends class_3955> boolean applyCraftingRecipe(BasinInput input, T recipe, class_1937 world, Map<T, List<SizedIngredient>> ingredientCache, Function<T, List<SizedIngredient>> recipeToIngredients) {
        ArrayDeque<Runnable> changes;
        List<SizedIngredient> ingredients = ingredientCache.computeIfAbsent(recipe, recipeToIngredients);
        List<class_1799> outputs = BasinRecipe.prepareCraft(input, ingredients, changes = new ArrayDeque<Runnable>());
        if (outputs == null) {
            return false;
        }
        outputs.add(recipe.method_8116(null, (class_7225.class_7874)world.method_30349()));
        if (!input.acceptOutputs(outputs, List.of(), true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, List.of(), false);
    }

    @Nullable
    public static List<class_1799> prepareCraft(BasinInput input, List<SizedIngredient> ingredients, Deque<Runnable> changes) {
        int ingredientIndex;
        if (ingredients.isEmpty()) {
            return new ArrayList<class_1799>();
        }
        ArrayList<class_1799> usings = new ArrayList<class_1799>();
        LinkedList<IntObjectPair> inputs = new LinkedList<IntObjectPair>();
        int ingredientSize = ingredients.size();
        class_1263 inventory = input.items();
        int itemIndex = 0;
        int inventorySize = inventory.method_5439();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.getCount();
            while (itemIndex < inventorySize) {
                class_1799 stack = inventory.method_5438(itemIndex);
                if (!stack.method_7960()) {
                    if (ingredient.test(stack)) {
                        int count = stack.method_7947();
                        if (count > remainder) {
                            usings.add(stack.method_46651(remainder));
                            int newCount = count - remainder;
                            changes.add(() -> stack.method_7939(newCount));
                            ++itemIndex;
                            continue block0;
                        }
                        usings.add(stack);
                        int slot = itemIndex++;
                        changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                        if (count == remainder) continue block0;
                        remainder -= count;
                    } else {
                        inputs.add(IntObjectPair.of((int)itemIndex, (Object)stack));
                    }
                }
                ++itemIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                IntObjectPair pair = (IntObjectPair)iterator.next();
                class_1799 stack = (class_1799)pair.right();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.method_7947();
                if (count > remainder) {
                    usings.add(stack.method_46651(remainder));
                    int newCount = count - remainder;
                    changes.add(() -> stack.method_7939(newCount));
                    ++ingredientIndex;
                    break block0;
                }
                usings.add(stack);
                int slot = pair.leftInt();
                changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return null;
        }
        while (ingredientIndex < ingredientSize) {
            block17: {
                SizedIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.getCount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    IntObjectPair pair = (IntObjectPair)iterator.next();
                    class_1799 stack = (class_1799)pair.right();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                        int newCount = count - remainder;
                        changes.add(() -> stack.method_7939(newCount));
                    } else {
                        usings.add(stack);
                        int slot = pair.leftInt();
                        changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block17;
                }
                return null;
            }
            ++ingredientIndex;
        }
        changes.add(() -> ((class_1263)inventory).method_5431());
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (class_1799 stack : usings) {
            class_1792 item = stack.method_7909();
            int count = stack.method_7947();
            for (int i = 0; i < count; ++i) {
                class_1799 remainder = item.method_7858();
                if (remainder == class_1799.field_8037) continue;
                outputs.add(remainder);
            }
        }
        return outputs;
    }

    public static boolean prepareFluidCraft(BasinInput input, FluidIngredient ingredient, Deque<Runnable> changes) {
        if (ingredient == null) {
            return true;
        }
        FluidInventory inventory = input.fluids();
        int remainder = ingredient.amount();
        int fluidInventorySize = inventory.size();
        for (int fluidIndex = 0; fluidIndex < fluidInventorySize; ++fluidIndex) {
            FluidStack stack = inventory.getStack(fluidIndex);
            if (!ingredient.test(stack)) continue;
            int amount = stack.getAmount();
            if (amount > remainder) {
                int newAmount = amount - remainder;
                changes.add(() -> stack.setAmount(newAmount));
                return true;
            }
            int slot = fluidIndex;
            changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
            if (remainder == amount) {
                return true;
            }
            remainder -= amount;
        }
        return false;
    }

    public static boolean prepareFluidCraft(BasinInput input, List<FluidIngredient> ingredients, Deque<Runnable> changes) {
        int ingredientIndex;
        if (ingredients.isEmpty()) {
            return true;
        }
        LinkedList<IntObjectPair> inputs = new LinkedList<IntObjectPair>();
        int ingredientSize = ingredients.size();
        FluidInventory inventory = input.fluids();
        int fluidIndex = 0;
        int inventorySize = inventory.size();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.amount();
            while (fluidIndex < inventorySize) {
                FluidStack stack = inventory.getStack(fluidIndex);
                if (!stack.isEmpty()) {
                    if (ingredient.test(stack)) {
                        int count = stack.getAmount();
                        if (count > remainder) {
                            int newAmount = count - remainder;
                            changes.add(() -> stack.setAmount(newAmount));
                            ++fluidIndex;
                            continue block0;
                        }
                        int slot = fluidIndex++;
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count == remainder) continue block0;
                        remainder -= count;
                    } else {
                        inputs.add(IntObjectPair.of((int)fluidIndex, (Object)stack));
                    }
                }
                ++fluidIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                IntObjectPair pair = (IntObjectPair)iterator.next();
                FluidStack stack = (FluidStack)pair.right();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.getAmount();
                if (count > remainder) {
                    int newAmount = count - remainder;
                    changes.add(() -> stack.setAmount(newAmount));
                    ++ingredientIndex;
                    break block0;
                }
                int slot = pair.leftInt();
                changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return false;
        }
        while (ingredientIndex < ingredientSize) {
            block15: {
                FluidIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.amount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    IntObjectPair pair = (IntObjectPair)iterator.next();
                    FluidStack stack = (FluidStack)pair.right();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count > remainder) {
                        int newAmount = count - remainder;
                        changes.add(() -> stack.setAmount(newAmount));
                    } else {
                        int slot = pair.leftInt();
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block15;
                }
                return false;
            }
            ++ingredientIndex;
        }
        return true;
    }

    public int getIngredientSize();

    public List<SizedIngredient> getIngredients();

    public List<FluidIngredient> getFluidIngredients();

    public boolean apply(BasinInput var1);

    default public class_9887 method_61671() {
        return class_9887.field_52597;
    }

    default public class_10355 method_64668() {
        return null;
    }

    default public boolean method_8118() {
        return true;
    }

    default public class_1799 craft(BasinInput input, class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }
}

