/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.schematics.cannon;

import com.google.common.collect.Sets;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.equipment.clipboard.ClipboardOverrides;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;

public class MaterialChecklist {
    public static final int MAX_ENTRIES_PER_PAGE = 5;
    public static final int MAX_ENTRIES_PER_CLIPBOARD_PAGE = 7;
    public Object2IntMap<class_1792> gathered = new Object2IntArrayMap();
    public Object2IntMap<class_1792> required = new Object2IntArrayMap();
    public Object2IntMap<class_1792> damageRequired = new Object2IntArrayMap();
    public boolean blocksNotLoaded;

    public void warnBlockNotLoaded() {
        this.blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty()) {
            return;
        }
        if (requirement.isInvalid()) {
            return;
        }
        for (ItemRequirement.StackRequirement stack : requirement.getRequiredItems()) {
            if (stack.usage == ItemRequirement.ItemUseType.DAMAGE) {
                this.putOrIncrement(this.damageRequired, stack.stack);
            }
            if (stack.usage != ItemRequirement.ItemUseType.CONSUME) continue;
            this.putOrIncrement(this.required, stack.stack);
        }
    }

    private void putOrIncrement(Object2IntMap<class_1792> map, class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8162) {
            return;
        }
        if (map.containsKey((Object)item)) {
            map.put((Object)item, map.getInt((Object)item) + stack.method_7947());
        } else {
            map.put((Object)item, stack.method_7947());
        }
    }

    public void collect(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (this.required.containsKey((Object)item) || this.damageRequired.containsKey((Object)item)) {
            if (this.gathered.containsKey((Object)item)) {
                this.gathered.put((Object)item, this.gathered.getInt((Object)item) + stack.method_7947());
            } else {
                this.gathered.put((Object)item, stack.method_7947());
            }
        }
    }

    public class_1799 createWrittenBook() {
        class_5250 textComponent;
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        ArrayList<class_9262> pages = new ArrayList<class_9262>();
        int itemsWritten = 0;
        if (this.blocksNotLoaded) {
            textComponent = class_2561.method_43470((String)("\n" + String.valueOf(class_124.field_1061)));
            textComponent = textComponent.method_10852((class_2561)class_2561.method_43471((String)"create.materialChecklist.blocksNotLoaded"));
            pages.add(class_9262.method_57137((Object)textComponent));
        }
        ArrayList keys = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        Collections.sort(keys, (item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = item1.method_63680().getString().toLowerCase(locale);
            String name2 = item2.method_63680().getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        textComponent = class_2561.method_43473();
        ArrayList<class_1792> completed = new ArrayList<class_1792>();
        for (class_1792 item : keys) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completed.add(item);
                continue;
            }
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.method_10852((class_2561)class_2561.method_43470((String)"\n >>>").method_27692(class_124.field_1078));
                pages.add(class_9262.method_57137((Object)textComponent));
                textComponent = class_2561.method_43473();
            }
            ++itemsWritten;
            textComponent.method_10852((class_2561)this.entry(new class_1799((class_1935)item), amount, true, true));
        }
        for (class_1792 item : completed) {
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.method_10852((class_2561)class_2561.method_43470((String)"\n >>>").method_27692(class_124.field_1077));
                pages.add(class_9262.method_57137((Object)textComponent));
                textComponent = class_2561.method_43473();
            }
            ++itemsWritten;
            textComponent.method_10852((class_2561)this.entry(new class_1799((class_1935)item), this.getRequiredAmount(item), false, true));
        }
        pages.add(class_9262.method_57137((Object)textComponent));
        class_9302 contents = new class_9302(class_9262.method_57137((Object)(String.valueOf(class_124.field_1078) + "Material Checklist")), "Schematicannon", 0, pages, true);
        book.method_57379(class_9334.field_49606, (Object)contents);
        textComponent = class_2561.method_43471((String)"create.materialChecklist").method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_10978(Boolean.FALSE));
        book.method_57379(class_9334.field_49631, (Object)textComponent);
        return book;
    }

    public class_1799 createWrittenClipboard() {
        class_1799 clipboard = AllItems.CLIPBOARD.method_7854();
        int itemsWritten = 0;
        ArrayList<List<ClipboardEntry>> pages = new ArrayList<List<ClipboardEntry>>();
        ArrayList<ClipboardEntry> currentPage = new ArrayList<ClipboardEntry>();
        if (this.blocksNotLoaded) {
            currentPage.add(new ClipboardEntry(false, class_2561.method_43471((String)"create.materialChecklist.blocksNotLoaded").method_27692(class_124.field_1061)));
        }
        ArrayList keys = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        keys.sort((item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = item1.method_63680().getString().toLowerCase(locale);
            String name2 = item2.method_63680().getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        ArrayList<class_1792> completed = new ArrayList<class_1792>();
        for (class_1792 item : keys) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completed.add(item);
                continue;
            }
            if (itemsWritten == 7) {
                itemsWritten = 0;
                currentPage.add(new ClipboardEntry(false, class_2561.method_43470((String)">>>").method_27692(class_124.field_1063)));
                pages.add(currentPage);
                currentPage = new ArrayList();
            }
            ++itemsWritten;
            currentPage.add(new ClipboardEntry(false, this.entry(new class_1799((class_1935)item), amount, true, false)).displayItem(new class_1799((class_1935)item), amount));
        }
        for (class_1792 item : completed) {
            if (itemsWritten == 7) {
                itemsWritten = 0;
                currentPage.add(new ClipboardEntry(true, class_2561.method_43470((String)">>>").method_27692(class_124.field_1077)));
                pages.add(currentPage);
                currentPage = new ArrayList();
            }
            ++itemsWritten;
            currentPage.add(new ClipboardEntry(true, this.entry(new class_1799((class_1935)item), this.getRequiredAmount(item), false, false)).displayItem(new class_1799((class_1935)item), 0));
        }
        pages.add(currentPage);
        ClipboardEntry.saveAll(pages, clipboard);
        ClipboardOverrides.switchTo(ClipboardType.WRITTEN, clipboard);
        clipboard.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"create.materialChecklist").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        clipboard.method_57379(AllDataComponents.CLIPBOARD_READ_ONLY, (Object)class_3902.field_17274);
        return clipboard;
    }

    public int getRequiredAmount(class_1792 item) {
        int amount = this.required.getOrDefault((Object)item, 0);
        if (this.damageRequired.containsKey((Object)item)) {
            amount = (int)((double)amount + Math.ceil((float)this.damageRequired.getInt((Object)item) / (float)new class_1799((class_1935)item).method_7936()));
        }
        return amount;
    }

    private class_5250 entry(class_1799 item, int amount, boolean unfinished, boolean forBook) {
        int stacks = amount / 64;
        int remainder = amount % 64;
        class_5250 tc = class_2561.method_43473();
        tc.method_10852((class_2561)class_2561.method_43471((String)item.method_7909().method_7876()).method_10862(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10612(item))));
        if (!unfinished && forBook) {
            tc.method_27693(" \u2714");
        }
        if (!unfinished || forBook) {
            tc.method_27692(unfinished ? class_124.field_1078 : class_124.field_1077);
        }
        return tc.method_10852((class_2561)class_2561.method_43470((String)("\n x" + amount)).method_27692(class_124.field_1074)).method_10852((class_2561)class_2561.method_43470((String)(" | " + stacks + "\u25a4 +" + remainder + (forBook ? "\n" : ""))).method_27692(class_124.field_1080));
    }
}

