/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedInvWrapper
implements class_1278 {
    protected final class_1263[] itemHandler;
    protected final int[] baseIndex;
    private final boolean[] sideInventory;
    protected final int[] slots;

    public CombinedInvWrapper(class_1263 ... itemHandler) {
        this.itemHandler = itemHandler;
        int length = itemHandler.length;
        this.baseIndex = new int[length];
        this.sideInventory = new boolean[length];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            class_1263 inventory = itemHandler[i];
            this.baseIndex[i] = index += inventory.method_5439();
            this.sideInventory[i] = inventory instanceof class_1278;
        }
        this.slots = SlotRangeCache.get(index);
    }

    protected int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    protected class_1263 getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.itemHandler.length) {
            return null;
        }
        return this.itemHandler[index];
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    public int[] method_5494(class_2350 side) {
        return this.slots;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        int index = this.getIndexForSlot(slot);
        class_1263 handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return false;
        }
        if (handler.method_5437(slot, stack)) {
            if (this.sideInventory[index]) {
                return ((class_1278)handler).method_5492(slot, stack, dir);
            }
            return true;
        }
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        int index = this.getIndexForSlot(slot);
        class_1263 handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return false;
        }
        if (this.sideInventory[index]) {
            return ((class_1278)handler).method_5493(slot, stack, dir);
        }
        return true;
    }

    public int method_5439() {
        return this.slots.length;
    }

    public class_1799 method_5438(int slot) {
        int index = this.getIndexForSlot(slot);
        class_1263 handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return class_1799.field_8037;
        }
        slot = this.getSlotFromIndex(slot, index);
        return handler.method_5438(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        int index = this.getIndexForSlot(slot);
        class_1263 handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return;
        }
        slot = this.getSlotFromIndex(slot, index);
        handler.method_5447(slot, stack);
    }

    public int insert(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (class_1263 handler : this.itemHandler) {
            int insert = handler.insert(stack, remaining, side);
            if (remaining == insert) {
                this.markInventoryDirty();
                return maxAmount;
            }
            if (insert == 0) continue;
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markInventoryDirty();
        return maxAmount - remaining;
    }

    public int extract(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (class_1263 handler : this.itemHandler) {
            int extract = handler.extract(stack, remaining, side);
            if (remaining == extract) {
                this.markInventoryDirty();
                return maxAmount;
            }
            if (extract == 0) continue;
            remaining -= extract;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markInventoryDirty();
        return maxAmount - remaining;
    }

    public class_1799 extract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int size = this.itemHandler.length;
        for (int i = 0; i < size; ++i) {
            class_1799 findStack = this.itemHandler[i].extract(predicate, maxAmount, side);
            if (findStack == class_1799.field_8037) continue;
            int extract = findStack.method_7947();
            if (extract == maxAmount) {
                this.markInventoryDirty();
                return findStack;
            }
            if (++i == size) {
                this.markInventoryDirty();
                return findStack;
            }
            int remaining = maxAmount - extract;
            while (i < size) {
                extract = this.itemHandler[i].extract(findStack, remaining, side);
                if (remaining == extract) {
                    this.markInventoryDirty();
                    findStack.method_7939(maxAmount);
                    return findStack;
                }
                if (extract != 0) {
                    remaining -= extract;
                }
                ++i;
            }
            this.markInventoryDirty();
            findStack.method_7939(maxAmount - remaining);
            return findStack;
        }
        return class_1799.field_8037;
    }

    public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int size = this.itemHandler.length;
        for (int i = 0; i < size; ++i) {
            class_1799 findStack = this.itemHandler[i].count(predicate, maxAmount, side);
            if (findStack.method_7960()) continue;
            int count = findStack.method_7947();
            if (count == maxAmount) {
                this.itemHandler[i].extract(findStack, count, side);
                this.markInventoryDirty();
                return findStack;
            }
            if (++i == size) break;
            int[] extracts = new int[size];
            extracts[i] = count;
            int remaining = maxAmount - count;
            while (i < size) {
                int extract = this.itemHandler[i].count(findStack, remaining, side);
                if (extract != 0) {
                    extracts[i] = extract;
                    if (remaining > extract) {
                        remaining -= extract;
                    } else {
                        for (int j = 0; j <= i; ++j) {
                            extract = extracts[j];
                            if (extract == 0) continue;
                            this.itemHandler[j].extract(findStack, extract, side);
                        }
                        this.markInventoryDirty();
                        findStack.method_7939(maxAmount);
                        return findStack;
                    }
                }
                ++i;
            }
        }
        return class_1799.field_8037;
    }

    public int countAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        for (class_1263 inventory : this.itemHandler) {
            if ((count += inventory.countAll(predicate, maxAmount, side)) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    public int extractAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        for (class_1263 inventory : this.itemHandler) {
            int extract = inventory.extractAll(predicate, remaining, side);
            if (extract < remaining) {
                remaining -= extract;
                continue;
            }
            this.markInventoryDirty();
            return maxAmount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markInventoryDirty();
        return maxAmount - remaining;
    }

    public void markInventoryDirty() {
    }

    public void method_5431() {
        for (class_1263 inventory : this.itemHandler) {
            inventory.method_5431();
        }
        this.markInventoryDirty();
    }

    @NotNull
    public java.util.Iterator<class_1799> iterator(class_2350 side) {
        if (this.itemHandler.length == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator(side);
    }

    class Iterator
    implements java.util.Iterator<class_1799> {
        private int index;
        private final class_2350 side;
        private java.util.Iterator<class_1799> iterator;

        public Iterator(class_2350 side) {
            this.side = side;
            this.iterator = CombinedInvWrapper.this.itemHandler[this.index].iterator(side);
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            do {
                ++this.index;
                if (this.index >= CombinedInvWrapper.this.itemHandler.length) {
                    return false;
                }
                this.iterator = CombinedInvWrapper.this.itemHandler[this.index].iterator(this.side);
            } while (!this.iterator.hasNext());
            return true;
        }

        @Override
        public class_1799 next() {
            if (this.hasNext()) {
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }
    }
}

