/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.zurrtum.create.infrastructure.items.ItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_9326;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryWrapper<T extends Storage<ItemVariant>, S extends StorageView<ItemVariant>>
implements ItemInventory {
    protected T storage;
    protected int capacity;

    public InventoryWrapper(T storage) {
        this.storage = storage;
        this.init();
    }

    public static class_1263 of(Storage<ItemVariant> storage) {
        InventoryWrapper inventory;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            inventory = new Slotted((SlottedStorage<ItemVariant>)slottedStorage);
        } else {
            inventory = new Direct(storage);
        }
        if (storage.supportsInsertion() && storage.supportsExtraction()) {
            return inventory;
        }
        return new Filter(inventory);
    }

    public void method_5448() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                view.extract((Object)((ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
            }
            transaction.commit();
        }
    }

    public int count(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount);
    }

    public int count(class_1799 stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long extract = this.storage.extract((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)maxAmount, (TransactionContext)transaction);
            transaction.abort();
            int n = (int)extract;
            return n;
        }
    }

    public class_1799 count(Predicate<class_1799> predicate) {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                class_1799 class_17992 = this.directCopy(stack, (int)extract);
                return class_17992;
            }
            transaction.abort();
        }
        return class_1799.field_8037;
    }

    public class_1799 count(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                class_1799 class_17992 = this.directCopy(stack, (int)extract);
                return class_17992;
            }
            transaction.abort();
        }
        return class_1799.field_8037;
    }

    public int countAll(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        long count = 0L;
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                if (!predicate.test(((ItemVariantImpl)variant).getCachedStack()) || (count += view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction)) < (long)maxAmount) continue;
                transaction.abort();
                int n = maxAmount;
                return n;
            }
            transaction.abort();
        }
        return (int)count;
    }

    public class_1799 countAny() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                class_1799 class_17992 = this.directCopy(stack, (int)extract);
                return class_17992;
            }
            transaction.abort();
        }
        return class_1799.field_8037;
    }

    public class_1799 countAny(int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                class_1799 class_17992 = this.directCopy(stack, (int)extract);
                return class_17992;
            }
            transaction.abort();
        }
        return class_1799.field_8037;
    }

    public int countSpace(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount);
    }

    public int countSpace(class_1799 stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)maxAmount, (TransactionContext)transaction);
            transaction.abort();
            int n = (int)insert;
            return n;
        }
    }

    public boolean countSpace(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            class_1799 stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.method_7947()) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue()) == count;
        }
        try (Transaction transaction = Transaction.openOuter();){
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                long insert = this.storage.insert((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)count, (TransactionContext)transaction);
                if (insert >= (long)count) continue;
                transaction.abort();
                boolean bl = false;
                return bl;
            } while (iterator.hasNext());
            transaction.abort();
            boolean bl = true;
            return bl;
        }
    }

    public int countSpace(class_1799 stack, int maxAmount, int start, int end) {
        return this.countSpace(stack, maxAmount);
    }

    public boolean countSpace(List<class_1799> stacks, int start, int end) {
        return this.countSpace(stacks);
    }

    public int extract(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount);
    }

    public int extract(class_1799 stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long extract = this.storage.extract((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)maxAmount, (TransactionContext)transaction);
            transaction.commit();
            int n = (int)extract;
            return n;
        }
    }

    public class_1799 extract(Predicate<class_1799> predicate) {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                class_1799 class_17992 = this.directCopy(stack, (int)extract);
                return class_17992;
            }
            transaction.abort();
        }
        return class_1799.field_8037;
    }

    public class_1799 extract(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                class_1799 class_17992 = this.directCopy(stack, (int)extract);
                return class_17992;
            }
            transaction.abort();
        }
        return class_1799.field_8037;
    }

    public List<class_1799> extract(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int extract;
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            if (count == (extract = this.extract(stacks.getFirst(), count))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int extract;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count == (extract = this.extract(stack, count))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        try (Transaction transaction = Transaction.openOuter();){
            boolean dirty = false;
            IdentityHashMap<class_1799, ItemVariant> cache = new IdentityHashMap<class_1799, ItemVariant>();
            block8: for (StorageView view : this.storage.nonEmptyViews()) {
                ObjectBidirectionalIterator iterator = entries.fastIterator();
                do {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    class_1799 stack = (class_1799)entry.getKey();
                    int count = entry.getIntValue();
                    ItemVariant variant = cache.computeIfAbsent(stack, ItemVariant::of);
                    long extract = view.extract((Object)variant, (long)count, (TransactionContext)transaction);
                    if (extract == 0L) continue;
                    if (extract == (long)count) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            transaction.commit();
                            List<class_1799> list = List.of();
                            return list;
                        }
                    } else {
                        entry.setValue(count - (int)extract);
                    }
                    dirty = true;
                    continue block8;
                } while (iterator.hasNext());
            }
            if (dirty) {
                ArrayList<class_1799> result = new ArrayList<class_1799>();
                for (Object2IntMap.Entry entry : entries) {
                    class_1799 stack = (class_1799)entry.getKey();
                    int count = entry.getIntValue();
                    if (stack.method_7947() == count) {
                        result.add(stack);
                        continue;
                    }
                    result.add(this.directCopy(stack, count));
                }
                transaction.commit();
                Object object = result;
                return object;
            }
            List<class_1799> list = stacks;
            return list;
        }
    }

    public class_1799 extractAny() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant;
                long extract = view.extract((Object)(variant = (ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                class_1799 class_17992 = this.directCopy(((ItemVariantImpl)variant).getCachedStack(), (int)extract);
                return class_17992;
            }
            transaction.abort();
        }
        return class_1799.field_8037;
    }

    public class_1799 extractAny(int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                class_1799 class_17992 = this.directCopy(((ItemVariantImpl)variant).getCachedStack(), (int)extract);
                return class_17992;
            }
            transaction.abort();
        }
        return class_1799.field_8037;
    }

    public int extractAll(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        long remaining = maxAmount;
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                if (!predicate.test(((ItemVariantImpl)variant).getCachedStack())) continue;
                long extract = view.extract((Object)variant, remaining, (TransactionContext)transaction);
                if (extract == remaining) {
                    transaction.commit();
                    int n = maxAmount;
                    return n;
                }
                remaining -= extract;
            }
            transaction.commit();
        }
        return (int)((long)maxAmount - remaining);
    }

    public int forceInsert(class_1799 stack) {
        return this.insert(stack);
    }

    public int forceInsert(class_1799 stack, int maxAmount) {
        return this.insert(stack, maxAmount);
    }

    public boolean forcePreciseInsert(class_1799 stack) {
        return this.preciseInsert(stack);
    }

    public boolean forcePreciseInsert(class_1799 stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount);
    }

    public int method_5444() {
        return this.capacity;
    }

    protected abstract S getSlot(int var1);

    public class_1799 method_5438(int slot) {
        if (slot >= this.method_5439()) {
            return class_1799.field_8037;
        }
        S view = this.getSlot(slot);
        if (view == null) {
            return class_1799.field_8037;
        }
        ItemVariant variant = (ItemVariant)view.getResource();
        return new class_1799(variant.getRegistryEntry(), (int)view.getAmount(), variant.getComponents());
    }

    protected void init() {
        int max = 0;
        for (StorageView view : this.storage) {
            long capacity = view.getCapacity();
            if ((long)max <= capacity) continue;
            max = (int)capacity;
        }
        this.capacity = max;
    }

    protected abstract void insert(S var1, ItemVariant var2, int var3, Transaction var4);

    public int insert(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount);
    }

    public int insert(class_1799 stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)maxAmount, (TransactionContext)transaction);
            transaction.commit();
            int n = (int)insert;
            return n;
        }
    }

    public List<class_1799> insert(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            if (count == (insert = this.insert(stacks.getFirst(), count))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        try (Transaction transaction = Transaction.openOuter();){
            boolean dirty = false;
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                long insert = this.storage.insert((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)count, (TransactionContext)transaction);
                if (insert == (long)count) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        transaction.commit();
                        List<class_1799> list = List.of();
                        return list;
                    }
                    dirty = true;
                    continue;
                }
                if (insert == 0L) continue;
                entry.setValue(count - (int)insert);
                dirty = true;
            } while (iterator.hasNext());
            if (dirty) {
                ArrayList<class_1799> result = new ArrayList<class_1799>();
                for (Object2IntMap.Entry entry : entries) {
                    class_1799 stack = (class_1799)entry.getKey();
                    int count = entry.getIntValue();
                    if (stack.method_7947() == count) {
                        result.add(stack);
                        continue;
                    }
                    result.add(this.directCopy(stack, count));
                }
                transaction.commit();
                Object object = result;
                return object;
            }
            List<class_1799> list = stacks;
            return list;
        }
    }

    public int insert(class_1799 stack, int maxAmount, int start, int end) {
        return this.insert(stack, maxAmount);
    }

    public List<class_1799> insert(List<class_1799> stacks, int start, int end) {
        return this.insert(stacks);
    }

    public int insertExist(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insertExist(stack, maxAmount);
    }

    public int insertExist(class_1799 stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)maxAmount, (TransactionContext)transaction);
            transaction.commit();
            int n = (int)insert;
            return n;
        }
    }

    @Override
    public boolean method_5442() {
        java.util.Iterator iterator = this.storage.nonEmptyViews().iterator();
        if (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return false;
        }
        return true;
    }

    @NotNull
    public java.util.Iterator<class_1799> iterator() {
        return this.storage.supportsExtraction() ? new Iterator((Storage<ItemVariant>)this.storage) : Collections.emptyIterator();
    }

    public boolean preciseExtract(class_1799 stack) {
        if (stack.method_7960()) {
            return true;
        }
        try (Transaction transaction = Transaction.openOuter();){
            int amount = stack.method_7947();
            long extract = this.storage.extract((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)amount, (TransactionContext)transaction);
            if (extract < (long)amount) {
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                long extract;
                ItemVariant variant = (ItemVariant)view.getResource();
                class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack) || (extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction)) == 0L) continue;
                if (extract == (long)maxAmount) {
                    transaction.commit();
                    class_1799 class_17992 = this.directCopy(stack, maxAmount);
                    return class_17992;
                }
                transaction.abort();
            }
        }
        return class_1799.field_8037;
    }

    public boolean preciseInsert(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount);
    }

    public boolean preciseInsert(class_1799 stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)maxAmount, (TransactionContext)transaction);
            if (insert < (long)maxAmount) {
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    public boolean preciseInsert(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst());
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((class_1799)entry.getKey(), entry.getIntValue());
        }
        try (Transaction transaction = Transaction.openOuter();){
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                long insert = this.storage.insert((Object)ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), (long)count, (TransactionContext)transaction);
                if (insert >= (long)count) continue;
                transaction.abort();
                boolean bl = false;
                return bl;
            } while (iterator.hasNext());
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public class_1799 method_5441(int slot) {
        if (slot >= this.method_5439()) {
            return class_1799.field_8037;
        }
        S view = this.getSlot(slot);
        if (view == null) {
            return class_1799.field_8037;
        }
        ItemVariant variant = (ItemVariant)view.getResource();
        long amount = view.getAmount();
        if (variant.isBlank() || amount == 0L) {
            return class_1799.field_8037;
        }
        try (Transaction transaction = Transaction.openOuter();){
            amount = view.extract((Object)variant, amount, (TransactionContext)transaction);
            transaction.commit();
        }
        return new class_1799(variant.getRegistryEntry(), (int)amount, variant.getComponents());
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        if (slot >= this.method_5439()) {
            return class_1799.field_8037;
        }
        S view = this.getSlot(slot);
        if (view == null) {
            return class_1799.field_8037;
        }
        ItemVariant variant = (ItemVariant)view.getResource();
        if (variant.isBlank() || view.getAmount() == 0L) {
            return class_1799.field_8037;
        }
        try (Transaction transaction = Transaction.openOuter();){
            amount = (int)view.extract((Object)variant, (long)amount, (TransactionContext)transaction);
            transaction.commit();
        }
        return new class_1799(variant.getRegistryEntry(), amount, variant.getComponents());
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot >= this.method_5439()) {
            return;
        }
        S view = this.getSlot(slot);
        if (view == null) {
            return;
        }
        ItemVariant variant = (ItemVariant)view.getResource();
        try (Transaction transaction = Transaction.openOuter();){
            if (variant.isBlank() || view.getAmount() == 0L) {
                if (stack.method_7960()) {
                    return;
                }
                this.insert(view, ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), stack.method_7947(), transaction);
            } else if (variant.matches(stack)) {
                int targetCount;
                int amount = stack.method_7947();
                if (amount == (targetCount = (int)view.getAmount())) {
                    return;
                }
                int change = targetCount - amount;
                if (amount < targetCount) {
                    this.insert(view, variant, change, transaction);
                } else {
                    view.extract((Object)variant, (long)change, (TransactionContext)transaction);
                }
            } else {
                view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                this.insert(view, ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380()), stack.method_7947(), transaction);
            }
            transaction.commit();
        }
    }

    public boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update) {
        for (StorageView view : this.storage.nonEmptyViews()) {
            ItemVariant variant = (ItemVariant)view.getResource();
            class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
            if (!predicate.test(stack)) continue;
            Transaction transaction = Transaction.openOuter();
            try {
                long amount = view.getAmount();
                class_1799 replace = update.apply(new class_1799(variant.getRegistryEntry(), (int)amount, variant.getComponents()));
                if (class_1799.method_31577((class_1799)stack, (class_1799)replace)) {
                    int count = replace.method_7947();
                    if ((long)count == amount) {
                        boolean bl = true;
                        return bl;
                    }
                    long change = (long)count < amount ? view.extract((Object)variant, amount - (long)count, (TransactionContext)transaction) : this.storage.insert((Object)variant, (long)count - amount, (TransactionContext)transaction);
                    if (change == 0L) continue;
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
                long extract = view.extract((Object)variant, amount, (TransactionContext)transaction);
                if (extract != 0L) {
                    if (replace.method_7960()) {
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                    long insert = this.storage.insert((Object)ItemVariant.of((class_1935)replace.method_7909(), (class_9326)replace.method_57380()), (long)replace.method_7947(), (TransactionContext)transaction);
                    if (insert != 0L) {
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                }
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        return false;
    }

    public Stream<class_1799> stream() {
        return this.storage.supportsExtraction() ? ItemInventory.super.stream() : Stream.empty();
    }

    protected static class Slotted
    extends InventoryWrapper<SlottedStorage<ItemVariant>, SingleSlotStorage<ItemVariant>> {
        public Slotted(SlottedStorage<ItemVariant> storage) {
            super(storage);
        }

        @Override
        protected SingleSlotStorage<ItemVariant> getSlot(int slot) {
            return ((SlottedStorage)this.storage).getSlot(slot);
        }

        @Override
        protected void insert(SingleSlotStorage<ItemVariant> view, ItemVariant variant, int amount, Transaction transaction) {
            view.insert((Object)variant, (long)amount, (TransactionContext)transaction);
        }

        @Override
        public int insertExist(class_1799 stack) {
            if (stack.method_7960()) {
                return 0;
            }
            try (Transaction transaction = Transaction.openOuter();){
                ArrayList<SingleSlotStorage> emptys = new ArrayList<SingleSlotStorage>();
                ItemVariant variant = ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380());
                int maxAmount = stack.method_7947();
                long remaining = maxAmount;
                int size = ((SlottedStorage)this.storage).getSlotCount();
                for (int i = 0; i < size; ++i) {
                    SingleSlotStorage target = ((SlottedStorage)this.storage).getSlot(i);
                    if (target.getAmount() == 0L || target.isResourceBlank()) {
                        emptys.add(target);
                        continue;
                    }
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.commit();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                for (SingleSlotStorage target : emptys) {
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.commit();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                transaction.commit();
                int n = maxAmount - (int)remaining;
                return n;
            }
        }

        @Override
        public int countSpace(class_1799 stack, int maxAmount, int start, int end) {
            try (Transaction transaction = Transaction.openOuter();){
                ItemVariant variant = ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380());
                long remaining = maxAmount;
                for (int i = start; i <= end; ++i) {
                    SingleSlotStorage target = ((SlottedStorage)this.storage).getSlot(i);
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.abort();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                transaction.abort();
                int n = maxAmount - (int)remaining;
                return n;
            }
        }

        @Override
        public boolean countSpace(List<class_1799> stacks, int start, int end) {
            int listSize = stacks.size();
            if (listSize == 0) {
                return true;
            }
            if (listSize == 1) {
                int count;
                class_1799 stack = stacks.getFirst();
                return this.countSpace(stack, count = stack.method_7947(), start, end) == count;
            }
            Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
            for (class_1799 stack : stacks) {
                map.merge((Object)stack, stack.method_7947(), Integer::sum);
            }
            Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
            if (entries.size() == 1) {
                int count;
                Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
                class_1799 stack = (class_1799)entry.getKey();
                return this.countSpace(stack, count = entry.getIntValue(), start, end) == count;
            }
            try (Transaction transaction = Transaction.openOuter();){
                ObjectBidirectionalIterator iterator = entries.fastIterator();
                do {
                    SingleSlotStorage target;
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    class_1799 stack = (class_1799)entry.getKey();
                    int count = entry.getIntValue();
                    ItemVariant variant = ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380());
                    long remaining = count;
                    for (int i = start; i <= end && (remaining -= (target = ((SlottedStorage)this.storage).getSlot(i)).insert((Object)variant, remaining, (TransactionContext)transaction)) != 0L; ++i) {
                    }
                    if (remaining == 0L) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        transaction.abort();
                        boolean bl = true;
                        return bl;
                    }
                    if (remaining == (long)count) continue;
                    entry.setValue((int)remaining);
                } while (iterator.hasNext());
                transaction.abort();
                boolean bl = false;
                return bl;
            }
        }

        @Override
        public int insert(class_1799 stack, int maxAmount, int start, int end) {
            try (Transaction transaction = Transaction.openOuter();){
                ItemVariant variant = ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380());
                long remaining = maxAmount;
                for (int i = start; i <= end; ++i) {
                    SingleSlotStorage target = ((SlottedStorage)this.storage).getSlot(i);
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.commit();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                transaction.commit();
                int n = maxAmount - (int)remaining;
                return n;
            }
        }

        @Override
        public List<class_1799> insert(List<class_1799> stacks) {
            int listSize = stacks.size();
            if (listSize == 0) {
                return stacks;
            }
            if (listSize == 1) {
                int insert;
                class_1799 stack = stacks.getFirst();
                int count = stack.method_7947();
                if (count == (insert = this.insert(stacks.getFirst(), count))) {
                    return List.of();
                }
                if (insert == 0) {
                    return stacks;
                }
                return List.of(this.directCopy(stack, count - insert));
            }
            Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
            for (class_1799 stack : stacks) {
                map.merge((Object)stack, stack.method_7947(), Integer::sum);
            }
            Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
            if (entries.size() == 1) {
                int insert;
                Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                if (count == (insert = this.insert(stack, count))) {
                    return List.of();
                }
                if (insert == 0) {
                    return stacks;
                }
                return List.of(this.directCopy(stack, count - insert));
            }
            try (Transaction transaction = Transaction.openOuter();){
                boolean dirty = false;
                IdentityHashMap<class_1799, ItemVariant> cache = new IdentityHashMap<class_1799, ItemVariant>();
                int size = ((SlottedStorage)this.storage).getSlotCount();
                block8: for (int i = 0; i < size; ++i) {
                    SingleSlotStorage slot = ((SlottedStorage)this.storage).getSlot(i);
                    ObjectBidirectionalIterator iterator = entries.fastIterator();
                    do {
                        Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                        class_1799 stack = (class_1799)entry.getKey();
                        int count = entry.getIntValue();
                        ItemVariant variant = cache.computeIfAbsent(stack, ItemVariant::of);
                        long insert = slot.insert((Object)variant, (long)count, (TransactionContext)transaction);
                        if (insert == 0L) continue;
                        if (insert == (long)count) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                transaction.commit();
                                List<class_1799> list = List.of();
                                return list;
                            }
                        } else {
                            entry.setValue(count - (int)insert);
                        }
                        dirty = true;
                        continue block8;
                    } while (iterator.hasNext());
                }
                if (dirty) {
                    ArrayList<class_1799> result = new ArrayList<class_1799>();
                    for (Object2IntMap.Entry entry : entries) {
                        class_1799 stack = (class_1799)entry.getKey();
                        int count = entry.getIntValue();
                        if (stack.method_7947() == count) {
                            result.add(stack);
                            continue;
                        }
                        result.add(this.directCopy(stack, count));
                    }
                    transaction.commit();
                    Object object = result;
                    return object;
                }
                List<class_1799> list = stacks;
                return list;
            }
        }

        @Override
        public List<class_1799> insert(List<class_1799> stacks, int start, int end) {
            int listSize = stacks.size();
            if (listSize == 0) {
                return stacks;
            }
            if (listSize == 1) {
                int insert;
                class_1799 stack = stacks.getFirst();
                int count = stack.method_7947();
                if (count == (insert = this.insert(stacks.getFirst(), count, start, end))) {
                    return List.of();
                }
                if (insert == 0) {
                    return stacks;
                }
                return List.of(this.directCopy(stack, count - insert));
            }
            Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
            for (class_1799 stack : stacks) {
                map.merge((Object)stack, stack.method_7947(), Integer::sum);
            }
            Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
            if (entries.size() == 1) {
                int insert;
                Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                if (count == (insert = this.insert(stack, count, start, end))) {
                    return List.of();
                }
                if (insert == 0) {
                    return stacks;
                }
                return List.of(this.directCopy(stack, count - insert));
            }
            try (Transaction transaction = Transaction.openOuter();){
                boolean dirty = false;
                ObjectBidirectionalIterator iterator = entries.fastIterator();
                do {
                    SingleSlotStorage target;
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    class_1799 stack = (class_1799)entry.getKey();
                    int count = entry.getIntValue();
                    ItemVariant variant = ItemVariant.of((class_1935)stack.method_7909(), (class_9326)stack.method_57380());
                    long remaining = count;
                    for (int i = start; i <= end && (remaining -= (target = ((SlottedStorage)this.storage).getSlot(i)).insert((Object)variant, remaining, (TransactionContext)transaction)) != 0L; ++i) {
                    }
                    if (remaining == 0L) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            transaction.commit();
                            List<class_1799> list = List.of();
                            return list;
                        }
                        dirty = true;
                        continue;
                    }
                    if (remaining == (long)count) continue;
                    entry.setValue((int)remaining);
                    dirty = true;
                } while (iterator.hasNext());
                if (dirty) {
                    ArrayList<class_1799> result = new ArrayList<class_1799>();
                    for (Object2IntMap.Entry entry : entries) {
                        class_1799 stack = (class_1799)entry.getKey();
                        int count = entry.getIntValue();
                        if (stack.method_7947() == count) {
                            result.add(stack);
                            continue;
                        }
                        result.add(this.directCopy(stack, count));
                    }
                    transaction.commit();
                    Object object = result;
                    return object;
                }
                List<class_1799> list = stacks;
                return list;
            }
        }

        @Override
        public boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update) {
            int size = ((SlottedStorage)this.storage).getSlotCount();
            for (int i = 0; i < size; ++i) {
                SingleSlotStorage slot = ((SlottedStorage)this.storage).getSlot(i);
                ItemVariant variant = (ItemVariant)slot.getResource();
                class_1799 stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                try (Transaction transaction = Transaction.openOuter();){
                    long amount = slot.getAmount();
                    class_1799 replace = update.apply(new class_1799(variant.getRegistryEntry(), (int)amount, variant.getComponents()));
                    if (class_1799.method_31577((class_1799)stack, (class_1799)replace)) {
                        int count = replace.method_7947();
                        if ((long)count == amount) {
                            boolean bl = true;
                            return bl;
                        }
                        long change = (long)count < amount ? slot.extract((Object)variant, amount - (long)count, (TransactionContext)transaction) : slot.insert((Object)variant, (long)count - amount, (TransactionContext)transaction);
                        if (change == 0L) continue;
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                    long extract = slot.extract((Object)variant, amount, (TransactionContext)transaction);
                    if (extract != 0L) {
                        if (replace.method_7960()) {
                            transaction.commit();
                            boolean bl = true;
                            return bl;
                        }
                        long insert = slot.insert((Object)ItemVariant.of((class_1935)replace.method_7909(), (class_9326)replace.method_57380()), (long)replace.method_7947(), (TransactionContext)transaction);
                        if (insert != 0L) {
                            transaction.commit();
                            boolean bl = true;
                            return bl;
                        }
                    }
                    transaction.abort();
                    boolean bl = false;
                    return bl;
                }
            }
            return false;
        }

        public int method_5439() {
            return ((SlottedStorage)this.storage).getSlotCount();
        }
    }

    protected static class Direct
    extends InventoryWrapper<Storage<ItemVariant>, StorageView<ItemVariant>> {
        private int size;

        public Direct(Storage<ItemVariant> storage) {
            super(storage);
        }

        @Override
        protected StorageView<ItemVariant> getSlot(int slot) {
            int current = 0;
            for (StorageView view : this.storage) {
                if (current == slot) {
                    return view;
                }
                ++current;
            }
            return null;
        }

        @Override
        protected void init() {
            int count = 0;
            int max = 0;
            for (StorageView view : this.storage) {
                long capacity = view.getCapacity();
                if ((long)max < capacity) {
                    max = (int)capacity;
                }
                ++count;
            }
            this.size = count;
            this.capacity = max;
        }

        @Override
        protected void insert(StorageView<ItemVariant> view, ItemVariant variant, int amount, Transaction transaction) {
            this.storage.insert((Object)variant, (long)amount, (TransactionContext)transaction);
        }

        public int method_5439() {
            return this.size;
        }
    }

    public static class Filter
    implements class_1278 {
        private final int[] slots;
        private final boolean canInsert;
        private final boolean canExtract;
        private final InventoryWrapper<?, ?> inventory;

        public Filter(InventoryWrapper<?, ?> inventory) {
            this.inventory = inventory;
            this.slots = SlotRangeCache.get(inventory.method_5439());
            this.canInsert = inventory.storage.supportsInsertion();
            this.canExtract = inventory.storage.supportsExtraction();
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return this.canExtract;
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return this.canInsert;
        }

        public void method_5448() {
            if (!this.canExtract) {
                return;
            }
            this.inventory.method_5448();
        }

        public int count(class_1799 stack, class_2350 side) {
            return this.count(stack);
        }

        public int count(class_1799 stack) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.count(stack);
        }

        public int count(class_1799 stack, int maxAmount, class_2350 side) {
            return this.count(stack, maxAmount);
        }

        public int count(class_1799 stack, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.count(stack, maxAmount);
        }

        public class_1799 count(Predicate<class_1799> predicate, class_2350 side) {
            return this.count(predicate);
        }

        public class_1799 count(Predicate<class_1799> predicate) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.count(predicate);
        }

        public class_1799 count(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
            return this.count(predicate, maxAmount);
        }

        public class_1799 count(Predicate<class_1799> predicate, int maxAmount) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.count(predicate, maxAmount);
        }

        public int countAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
            return this.countAll(predicate, maxAmount);
        }

        public int countAll(Predicate<class_1799> predicate, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.countAll(predicate, maxAmount);
        }

        public class_1799 countAny(class_2350 side) {
            return this.countAny();
        }

        public class_1799 countAny() {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.countAny();
        }

        public class_1799 countAny(int maxAmount, class_2350 side) {
            return this.countAny(maxAmount);
        }

        public class_1799 countAny(int maxAmount) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.countAny(maxAmount);
        }

        public int countSpace(class_1799 stack, class_2350 side) {
            return this.countSpace(stack);
        }

        public int countSpace(class_1799 stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.countSpace(stack);
        }

        public int countSpace(class_1799 stack, int maxAmount, class_2350 side) {
            return this.countSpace(stack, maxAmount);
        }

        public int countSpace(class_1799 stack, int maxAmount) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.countSpace(stack, maxAmount);
        }

        public boolean countSpace(List<class_1799> stacks, class_2350 side) {
            return this.countSpace(stacks);
        }

        public boolean countSpace(List<class_1799> stacks) {
            if (!this.canInsert) {
                return false;
            }
            return this.inventory.countSpace(stacks);
        }

        public int extract(class_1799 stack, class_2350 side) {
            return this.extract(stack);
        }

        public int extract(class_1799 stack) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.extract(stack);
        }

        public int extract(class_1799 stack, int maxAmount, class_2350 side) {
            return this.extract(stack, maxAmount);
        }

        public int extract(class_1799 stack, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.extract(stack, maxAmount);
        }

        public class_1799 extract(Predicate<class_1799> predicate, class_2350 side) {
            return this.extract(predicate);
        }

        public class_1799 extract(Predicate<class_1799> predicate) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.extract(predicate);
        }

        public class_1799 extract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
            return this.extract(predicate, maxAmount);
        }

        public class_1799 extract(Predicate<class_1799> predicate, int maxAmount) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.extract(predicate, maxAmount);
        }

        public List<class_1799> extract(List<class_1799> stacks, class_2350 side) {
            return this.extract(stacks);
        }

        public List<class_1799> extract(List<class_1799> stacks) {
            if (!this.canExtract) {
                return stacks;
            }
            return this.inventory.extract(stacks);
        }

        public int extractAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
            return this.extractAll(predicate, maxAmount);
        }

        public int extractAll(Predicate<class_1799> predicate, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.extractAll(predicate, maxAmount);
        }

        public class_1799 extractAny(class_2350 side) {
            return this.extractAny();
        }

        public class_1799 extractAny() {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.extractAny();
        }

        public class_1799 extractAny(int maxAmount, class_2350 side) {
            return this.extractAny(maxAmount);
        }

        public class_1799 extractAny(int maxAmount) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.extractAny(maxAmount);
        }

        public int forceInsert(class_1799 stack) {
            return this.inventory.forceInsert(stack);
        }

        public int forceInsert(class_1799 stack, int maxAmount) {
            return this.inventory.forceInsert(stack, maxAmount);
        }

        public boolean forcePreciseInsert(class_1799 stack) {
            return this.inventory.forcePreciseInsert(stack);
        }

        public boolean forcePreciseInsert(class_1799 stack, int maxAmount) {
            return this.inventory.forcePreciseInsert(stack, maxAmount);
        }

        public int[] method_5494(class_2350 side) {
            return this.slots;
        }

        public int method_5444() {
            return this.inventory.method_5444();
        }

        public class_1799 method_5438(int slot) {
            return this.inventory.method_5438(slot);
        }

        public int insert(class_1799 stack, class_2350 side) {
            return this.insert(stack);
        }

        public int insert(class_1799 stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insert(stack);
        }

        public int insert(class_1799 stack, int maxAmount, class_2350 side) {
            return this.insert(stack, maxAmount);
        }

        public int insert(class_1799 stack, int maxAmount) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insert(stack, maxAmount);
        }

        public int insert(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
            return this.insert(stack, maxAmount);
        }

        public int insert(class_1799 stack, int maxAmount, int start, int end) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insert(stack, maxAmount, start, end);
        }

        public List<class_1799> insert(List<class_1799> stacks, class_2350 side) {
            return this.insert(stacks);
        }

        public List<class_1799> insert(List<class_1799> stacks) {
            if (!this.canInsert) {
                return stacks;
            }
            return this.inventory.insert(stacks);
        }

        public List<class_1799> insert(List<class_1799> stacks, int start, int end, class_2350 side) {
            return this.insert(stacks, start, end);
        }

        public List<class_1799> insert(List<class_1799> stacks, int start, int end) {
            if (!this.canInsert) {
                return stacks;
            }
            return this.inventory.insert(stacks, start, end);
        }

        public int insertExist(class_1799 stack, class_2350 side) {
            return this.insertExist(stack);
        }

        public int insertExist(class_1799 stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insertExist(stack);
        }

        public int insertExist(class_1799 stack, int maxAmount, class_2350 side) {
            if (!this.canInsert) {
                return 0;
            }
            return this.insertExist(stack, maxAmount);
        }

        public int insertExist(class_1799 stack, int maxAmount) {
            return this.inventory.insertExist(stack, maxAmount);
        }

        public boolean method_5442() {
            return this.inventory.method_5442();
        }

        @NotNull
        public java.util.Iterator<class_1799> iterator() {
            return this.inventory.iterator();
        }

        @NotNull
        public java.util.Iterator<class_1799> iterator(class_2350 side) {
            return this.inventory.iterator();
        }

        public boolean preciseExtract(class_1799 stack, class_2350 side) {
            return this.preciseExtract(stack);
        }

        public boolean preciseExtract(class_1799 stack) {
            if (!this.canExtract) {
                return stack.method_7960();
            }
            return this.inventory.preciseExtract(stack);
        }

        public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
            return this.preciseExtract(predicate, maxAmount);
        }

        public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.preciseExtract(predicate, maxAmount);
        }

        public boolean preciseInsert(class_1799 stack, class_2350 side) {
            return this.preciseInsert(stack);
        }

        public boolean preciseInsert(class_1799 stack) {
            if (!this.canInsert) {
                return stack.method_7960();
            }
            return this.inventory.preciseInsert(stack);
        }

        public boolean preciseInsert(class_1799 stack, int maxAmount, class_2350 side) {
            return this.preciseInsert(stack, maxAmount);
        }

        public boolean preciseInsert(class_1799 stack, int maxAmount) {
            if (!this.canInsert) {
                return stack.method_7960();
            }
            return this.inventory.preciseInsert(stack, maxAmount);
        }

        public boolean preciseInsert(List<class_1799> stacks, class_2350 side) {
            return this.preciseInsert(stacks);
        }

        public boolean preciseInsert(List<class_1799> stacks) {
            if (!this.canInsert) {
                return false;
            }
            return this.inventory.preciseInsert(stacks);
        }

        public class_1799 method_5441(int slot) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.method_5441(slot);
        }

        public class_1799 method_5434(int slot, int amount) {
            if (!this.canExtract) {
                return class_1799.field_8037;
            }
            return this.inventory.method_5434(slot, amount);
        }

        public void method_5447(int slot, class_1799 stack) {
            this.inventory.method_5447(slot, stack);
        }

        public int method_5439() {
            return this.inventory.method_5439();
        }

        public Stream<class_1799> stream() {
            return this.inventory.stream();
        }

        public Stream<class_1799> stream(class_2350 side) {
            return this.inventory.stream();
        }
    }

    static class Iterator
    implements java.util.Iterator<class_1799> {
        private final java.util.Iterator<StorageView<ItemVariant>> iterator;

        public Iterator(Storage<ItemVariant> storage) {
            this.iterator = storage.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public class_1799 next() {
            StorageView<ItemVariant> view = this.iterator.next();
            if (view.getAmount() == 0L || view.isResourceBlank()) {
                return class_1799.field_8037;
            }
            ItemVariant variant = (ItemVariant)view.getResource();
            return new class_1799(variant.getRegistryEntry(), (int)view.getAmount(), variant.getComponents());
        }
    }
}

