/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.DataFixer;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.content.contraptions.ContraptionHandler;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsServerHandler;
import com.zurrtum.create.content.contraptions.minecart.CouplingPhysics;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.kinetics.chainConveyor.ServerChainConveyorHandler;
import com.zurrtum.create.content.kinetics.drill.CobbleGenOptimisation;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerServerHandler;
import com.zurrtum.create.foundation.utility.ServerSpeedProvider;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.worldgen.AllPlacedFeatures;
import java.net.Proxy;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3283;
import net.minecraft.class_3949;
import net.minecraft.class_3950;
import net.minecraft.class_5455;
import net.minecraft.class_6904;
import net.minecraft.class_7497;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    public abstract class_5455.class_6890 method_30611();

    @Inject(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="TAIL")})
    void tick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        MinecraftServer server = (MinecraftServer)this;
        Create.SCHEMATIC_RECEIVER.tick();
        ServerSpeedProvider.serverTick(server);
        Create.RAILWAYS.sync.serverTick(server);
        ServerChainConveyorHandler.tick(server);
        TickBasedCache.tick();
    }

    @Inject(method={"runServer()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;shutdown()V")})
    private void serverStopping(CallbackInfo ci) {
        Create.SCHEMATIC_RECEIVER.shutdown();
    }

    @Inject(method={"tickWorlds(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;tick(Ljava/util/function/BooleanSupplier;)V", shift=At.Shift.AFTER)})
    private void onServerWorldTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci, @Local class_3218 world) {
        ContraptionHandler.tick((class_1937)world);
        CapabilityMinecartController.tick((class_1937)world);
        CouplingPhysics.tick((class_1937)world);
        LinkedControllerServerHandler.tick((class_1936)world);
        ControlsServerHandler.tick((class_1936)world);
        Create.RAILWAYS.tick(world);
        Create.LOGISTICS.tick((class_1937)world);
    }

    @WrapOperation(method={"createWorlds(Lnet/minecraft/server/WorldGenerationProgressListener;)V"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")})
    private <K, V> V onLoad(Map<K, V> map, K key, V value, Operation<V> original) {
        Object result = original.call(new Object[]{map, key, value});
        class_1937 world = (class_1937)value;
        Create.REDSTONE_LINK_NETWORK_HANDLER.onLoadWorld((class_1936)world);
        Create.TORQUE_PROPAGATOR.onLoadWorld((class_1936)world);
        return (V)result;
    }

    @Inject(method={"createWorlds(Lnet/minecraft/server/WorldGenerationProgressListener;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/ServerWorldProperties;isInitialized()Z")})
    private void onLoadOverworld(class_3949 worldGenerationProgressListener, CallbackInfo ci, @Local class_3218 world) {
        MinecraftServer server = (MinecraftServer)this;
        Create.RAILWAYS.levelLoaded(server);
        Create.LOGISTICS.levelLoaded(server);
    }

    @Inject(method={"shutdown()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;close()V")})
    private void onUnload(CallbackInfo ci, @Local class_3218 world) {
        Create.REDSTONE_LINK_NETWORK_HANDLER.onUnloadWorld((class_1936)world);
        Create.TORQUE_PROPAGATOR.onUnloadWorld((class_1936)world);
        WorldAttached.invalidateWorld((class_1936)world);
        CobbleGenOptimisation.invalidateWorld((class_1936)world);
    }

    @Inject(method={"runServer()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;exit()V")})
    private void onStopServer(CallbackInfo ci) {
        Create.SERVER = null;
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/SaveLoader;saveProperties()Lnet/minecraft/world/SaveProperties;")})
    private void addBiomeFeatures(Thread serverThread, class_32.class_5143 session, class_3283 dataPackManager, class_6904 saveLoader, Proxy proxy, DataFixer dataFixer, class_7497 apiServices, class_3950 worldGenerationProgressListenerFactory, CallbackInfo ci) {
        if (this instanceof class_3176) {
            AllPlacedFeatures.register((class_5455)this.method_30611());
        }
    }
}

