package com.zurrtum.create.api.behaviour.display;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public abstract class DisplaySource {
    public static final SimpleRegistry.Multi<class_2248, DisplaySource> BY_BLOCK = SimpleRegistry.Multi.create();
    public static final SimpleRegistry.Multi<class_2591<?>, DisplaySource> BY_BLOCK_ENTITY = SimpleRegistry.Multi.create();

    public static final List<class_5250> EMPTY = ImmutableList.of(class_2561.method_43473());
    public static final class_5250 EMPTY_LINE = class_2561.method_43473();
    public static final class_5250 WHITESPACE = class_5244.method_48320();
    public Object attachRender;

    @SuppressWarnings("unchecked")
    public <T> T getAttachRender() {
        return (T) attachRender;
    }

    public abstract List<class_5250> provideText(DisplayLinkContext context, DisplayTargetStats stats);

    public void transferData(DisplayLinkContext context, DisplayTarget activeTarget, int line) {
        DisplayTargetStats stats = activeTarget.provideStats(context);

        if (activeTarget instanceof DisplayBoardTarget fddt) {
            List<List<class_5250>> flapDisplayText = provideFlapDisplayText(context, stats);
            fddt.acceptFlapText(line, flapDisplayText, context);
        }

        List<class_5250> text = provideText(context, stats);
        if (text.isEmpty())
            text = EMPTY;

        if (activeTarget.requiresComponentSanitization())
            for (class_5250 component : text)
                if (NBTProcessors.textComponentHasClickEvent(component))
                    return; // Naughty

        activeTarget.acceptText(line, text, context);
    }

    public void onSignalReset(DisplayLinkContext context) {
    }

    public void populateData(DisplayLinkContext context) {
    }

    public int getPassiveRefreshTicks() {
        return 100;
    }

    public boolean shouldPassiveReset() {
        return true;
    }

    protected final class_2960 getId() {
        return CreateRegistries.DISPLAY_SOURCE.method_10221(this);
    }

    protected String getTranslationKey() {
        return this.getId().method_12832();
    }

    public class_2561 getName() {
        return class_2561.method_43471(this.getId().method_12836() + ".display_source." + getTranslationKey());
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout, int lineIndex) {
        loadFlapDisplayLayout(context, flapDisplay, layout);
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {
        if (!layout.isLayout("Default"))
            layout.loadDefault(flapDisplay.getMaxCharCount());
    }

    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        return provideText(context, stats).stream().map(Arrays::asList).toList();
    }

    /**
     * Get the DisplaySource with the given ID, accounting for legacy names.
     */
    @Nullable
    public static DisplaySource get(@Nullable class_2960 id) {
        if (id == null)
            return null;
        return CreateRegistries.DISPLAY_SOURCE.method_63535(id);
    }

    /**
     * Get all DisplaySources applicable to the block at the given location, checking both the Block and BlockEntity.
     * Returns an empty list if none are present, not null.
     */
    public static List<DisplaySource> getAll(class_1936 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        List<DisplaySource> byBlock = BY_BLOCK.get(state);

        class_2586 be = level.method_8321(pos);
        if (be == null)
            return byBlock;

        List<DisplaySource> byBe = BY_BLOCK_ENTITY.get(be.method_11017());

        if (byBlock.isEmpty()) {
            if (byBe.isEmpty()) {
                // none
                return List.of();
            } else {
                // only BlockEntity
                return byBe;
            }
        } else if (byBe.isEmpty()) {
            // only Block
            return byBlock;
        } else {
            // both present, combine
            List<DisplaySource> combined = new ArrayList<>(byBlock);
            combined.addAll(byBe);
            return combined;
        }
    }
}
