package com.zurrtum.create.api.equipment.potatoCannon;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileEntityHitAction.Type;
import com.zurrtum.create.api.registry.CreateRegistryKeys;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes.Billboard;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes.TowardMotion;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes.Tumble;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6880.class_6883;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

// TODO: 1.21.7 - Move into api package
public record PotatoCannonProjectileType(
    class_6885<class_1792> items, int reloadTicks, int damage, int split, float knockback, float drag, float velocityMultiplier,
    float gravityMultiplier, float soundPitch, boolean sticky, class_1799 dropStack, PotatoProjectileRenderMode renderMode,
    Optional<PotatoProjectileEntityHitAction> preEntityHit, Optional<PotatoProjectileEntityHitAction> onEntityHit,
    Optional<PotatoProjectileBlockHitAction> onBlockHit
) {
    public static final Codec<PotatoCannonProjectileType> CODEC = RecordCodecBuilder.create(i -> i.group(
        class_6895.method_40340(class_7924.field_41197).fieldOf("items").forGetter(PotatoCannonProjectileType::items),
        Codec.INT.optionalFieldOf("reload_ticks", 10).forGetter(PotatoCannonProjectileType::reloadTicks),
        Codec.INT.optionalFieldOf("damage", 1).forGetter(PotatoCannonProjectileType::damage),
        Codec.INT.optionalFieldOf("split", 1).forGetter(PotatoCannonProjectileType::split),
        Codec.FLOAT.optionalFieldOf("knockback", 1f).forGetter(PotatoCannonProjectileType::knockback),
        Codec.FLOAT.optionalFieldOf("drag", .99f).forGetter(PotatoCannonProjectileType::drag),
        Codec.FLOAT.optionalFieldOf("velocity_multiplier", 1f).forGetter(PotatoCannonProjectileType::velocityMultiplier),
        Codec.FLOAT.optionalFieldOf("gravity_multiplier", 1f).forGetter(PotatoCannonProjectileType::gravityMultiplier),
        Codec.FLOAT.optionalFieldOf("sound_pitch", 1f).forGetter(PotatoCannonProjectileType::soundPitch),
        Codec.BOOL.optionalFieldOf("sticky", false).forGetter(PotatoCannonProjectileType::sticky),
        class_1799.field_24671.optionalFieldOf("drop_stack", class_1799.field_8037).forGetter(PotatoCannonProjectileType::dropStack),
        PotatoProjectileRenderMode.CODEC.optionalFieldOf("render_mode", Billboard.INSTANCE).forGetter(PotatoCannonProjectileType::renderMode),
        PotatoProjectileEntityHitAction.CODEC.optionalFieldOf("pre_entity_hit").forGetter(p -> p.preEntityHit),
        PotatoProjectileEntityHitAction.CODEC.optionalFieldOf("on_entity_hit").forGetter(p -> p.onEntityHit),
        PotatoProjectileBlockHitAction.CODEC.optionalFieldOf("on_block_hit").forGetter(p -> p.onBlockHit)
    ).apply(i, PotatoCannonProjectileType::new));

    @SuppressWarnings("deprecation")
    public static Optional<class_6883<PotatoCannonProjectileType>> getTypeForItem(class_5455 registryAccess, class_1792 item) {
        // Cache this if it causes performance issues, but it probably won't
        return registryAccess.method_30530(CreateRegistryKeys.POTATO_PROJECTILE_TYPE).method_42017()
            .filter(ref -> ref.comp_349().items.method_40241(item.method_40131())).findFirst();
    }

    public boolean preEntityHit(class_1799 stack, class_3966 ray) {
        return preEntityHit.map(i -> i.execute(stack, ray, Type.PRE_HIT)).orElse(false);
    }

    public boolean onEntityHit(class_1799 stack, class_3966 ray) {
        return onEntityHit.map(i -> i.execute(stack, ray, Type.ON_HIT)).orElse(false);
    }

    public boolean onBlockHit(class_1936 level, class_1799 stack, class_3965 ray) {
        return onBlockHit.map(i -> i.execute(level, stack, ray)).orElse(false);
    }

    // Copy the stack so it's not mutated and lost
    @Override
    public class_1799 dropStack() {
        return dropStack.method_7972();
    }

    public static class Builder {
        private final List<class_6880<class_1792>> items = new ArrayList<>();
        private int reloadTicks = 10;
        private int damage = 1;
        private int split = 1;
        private float knockback = 1f;
        private float drag = 0.99f;
        private float velocityMultiplier = 1f;
        private float gravityMultiplier = 1f;
        private float soundPitch = 1f;
        private boolean sticky = false;
        private class_1799 dropStack = class_1799.field_8037;
        private PotatoProjectileRenderMode renderMode = Billboard.INSTANCE;
        private PotatoProjectileEntityHitAction preEntityHit = null;
        private PotatoProjectileEntityHitAction onEntityHit = null;
        private PotatoProjectileBlockHitAction onBlockHit = null;

        public Builder reloadTicks(int reload) {
            this.reloadTicks = reload;
            return this;
        }

        public Builder damage(int damage) {
            this.damage = damage;
            return this;
        }

        public Builder splitInto(int split) {
            this.split = split;
            return this;
        }

        public Builder knockback(float knockback) {
            this.knockback = knockback;
            return this;
        }

        public Builder drag(float drag) {
            this.drag = drag;
            return this;
        }

        public Builder velocity(float velocity) {
            this.velocityMultiplier = velocity;
            return this;
        }

        public Builder gravity(float modifier) {
            this.gravityMultiplier = modifier;
            return this;
        }

        public Builder soundPitch(float pitch) {
            this.soundPitch = pitch;
            return this;
        }

        public Builder sticky() {
            this.sticky = true;
            return this;
        }

        public Builder dropStack(class_1799 stack) {
            this.dropStack = stack;
            return this;
        }

        public Builder renderMode(PotatoProjectileRenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        public Builder renderBillboard() {
            renderMode(Billboard.INSTANCE);
            return this;
        }

        public Builder renderTumbling() {
            renderMode(Tumble.INSTANCE);
            return this;
        }

        public Builder renderTowardMotion(int spriteAngle, float spin) {
            renderMode(new TowardMotion(spriteAngle, spin));
            return this;
        }

        public Builder preEntityHit(PotatoProjectileEntityHitAction entityHitAction) {
            this.preEntityHit = entityHitAction;
            return this;
        }

        public Builder onEntityHit(PotatoProjectileEntityHitAction entityHitAction) {
            this.onEntityHit = entityHitAction;
            return this;
        }

        public Builder onBlockHit(PotatoProjectileBlockHitAction blockHitAction) {
            this.onBlockHit = blockHitAction;
            return this;
        }

        @SuppressWarnings("deprecation")
        public Builder addItems(class_1935... items) {
            for (class_1935 provider : items)
                this.items.add(provider.method_8389().method_40131());
            return this;
        }

        public PotatoCannonProjectileType build() {
            return new PotatoCannonProjectileType(
                class_6885.method_40242(items),
                reloadTicks,
                damage,
                split,
                knockback,
                drag,
                velocityMultiplier,
                gravityMultiplier,
                soundPitch,
                sticky,
                dropStack,
                renderMode,
                Optional.ofNullable(preEntityHit),
                Optional.ofNullable(onEntityHit),
                Optional.ofNullable(onBlockHit)
            );
        }
    }
}
