package com.zurrtum.create.client.catnip.gui;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import org.joml.Matrix3x2fStack;

import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;

public abstract class AbstractSimiScreen extends class_437 {

    protected static final Color BACKGROUND_COLOR = new Color(0x50_101010, true);

    protected int windowWidth, windowHeight;
    protected int windowXOffset, windowYOffset;
    protected int guiLeft, guiTop;

    protected AbstractSimiScreen(class_2561 title) {
        super(title);
    }

    protected AbstractSimiScreen() {
        this(class_5244.field_39003);
    }

    /**
     * This method must be called before {@code super.init()}!
     */
    protected void setWindowSize(int width, int height) {
        windowWidth = width;
        windowHeight = height;
    }

    /**
     * This method must be called before {@code super.init()}!
     */
    protected void setWindowOffset(int xOffset, int yOffset) {
        windowXOffset = xOffset;
        windowYOffset = yOffset;
    }

    @Override
    protected void method_25426() {
        guiLeft = (field_22789 - windowWidth) / 2;
        guiTop = (field_22790 - windowHeight) / 2;
        guiLeft += windowXOffset;
        guiTop += windowYOffset;
    }

    @Override
    public void method_25393() {
        for (class_364 listener : method_25396()) {
            if (listener instanceof TickableGuiEventListener tickable) {
                tickable.tick();
            }
        }
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @SuppressWarnings("unchecked")
    protected <W extends class_364 & class_4068 & class_6379> void addRenderableWidgets(W... widgets) {
        for (W widget : widgets) {
            method_37063(widget);
        }
    }

    protected <W extends class_364 & class_4068 & class_6379> void addRenderableWidgets(Collection<W> widgets) {
        for (W widget : widgets) {
            method_37063(widget);
        }
    }

    protected void removeWidgets(class_364... widgets) {
        for (class_364 widget : widgets) {
            method_37066(widget);
        }
    }

    protected void removeWidgets(Collection<? extends class_364> widgets) {
        for (class_364 widget : widgets) {
            method_37066(widget);
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = NavigatableSimiScreen.currentlyRenderingPreviousScreen ? 0 : AnimationTickHolder.getPartialTicksUI(field_22787.method_61966());
        Matrix3x2fStack poseStack = graphics.method_51448();

        poseStack.pushMatrix();

        prepareFrame();

        renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
        renderWindow(graphics, mouseX, mouseY, partialTicks);

        for (class_4068 renderable : getRenderables())
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);

        renderWindowForeground(graphics, mouseX, mouseY, partialTicks);

        endFrame();

        poseStack.popMatrix();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean keyPressed = super.method_25404(keyCode, scanCode, modifiers);
        if (keyPressed || method_25399() != null)
            return keyPressed;

        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }

        boolean consumed = false;

        for (class_364 widget : method_25396()) {
            if (widget instanceof AbstractSimiWidget simiWidget) {
                if (simiWidget.method_25404(keyCode, scanCode, modifiers))
                    consumed = true;
            }
        }

        return consumed;
    }

    protected void prepareFrame() {
    }

    protected void renderWindowBackground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        method_57735(graphics);
    }

    protected abstract void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks);

    protected void renderWindowForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        for (class_4068 widget : getRenderables()) {
            if (widget instanceof AbstractSimiWidget simiWidget && simiWidget.method_49606() && simiWidget.field_22764) {
                List<class_2561> tooltip = simiWidget.getToolTip();
                if (tooltip.isEmpty())
                    continue;
                int ttx = simiWidget.lockedTooltipX == -1 ? mouseX : simiWidget.lockedTooltipX + simiWidget.method_46426();
                int tty = simiWidget.lockedTooltipY == -1 ? mouseY : simiWidget.lockedTooltipY + simiWidget.method_46427();
                graphics.method_51434(field_22793, tooltip, ttx, tty);
            }
        }
    }

    protected void endFrame() {
    }

    @Deprecated
    protected void debugWindowArea(class_332 graphics) {
        graphics.method_25294(guiLeft + windowWidth, guiTop + windowHeight, guiLeft, guiTop, 0xD3D3D3D3);
    }

    protected List<class_4068> getRenderables() {
        return this.field_33816;
    }

    @Override
    public class_364 method_25399() {
        class_364 focused = super.method_25399();
        if (focused instanceof class_339 && !focused.method_25370())
            focused = null;
        method_25395(focused);
        return focused;
    }

}
