package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

import static com.zurrtum.create.Create.MOD_ID;

public record ArrowRenderState(
    Matrix3x2f pose, float r, float g, float b, float a, float length, class_8030 bounds
) implements class_11244 {
    private static final RenderPipeline TRIANGLE_FAN = RenderPipeline.builder(class_10799.field_60125)
        .withVertexShader("core/position_color").withFragmentShader("core/position_color").withBlend(BlendFunction.TRANSLUCENT)
        .withLocation(class_2960.method_60655(MOD_ID, "pipeline/triangle_fan"))
        .withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27381).build();

    public ArrowRenderState(Matrix3x2f pose, int size, float r, float g, float b, float a, float length) {
        this(pose, r, g, b, a, length, new class_8030(0, 0, size, size).method_71523(pose));
    }

    @Override
    public RenderPipeline comp_4055() {
        return TRIANGLE_FAN;
    }

    @Override
    public void method_70917(class_4588 vertexConsumer, float depth) {
        vertexConsumer.method_70815(pose, 0, -(10 + length), depth).method_22915(r, g, b, a);

        vertexConsumer.method_70815(pose, -10, -3, 0).method_22915(r, g, b, 0f);
        vertexConsumer.method_70815(pose, -4, -7, 0).method_22915(r, g, b, 0f);
        vertexConsumer.method_70815(pose, -0, -8, 0).method_22915(r, g, b, 0f);

        vertexConsumer.method_70815(pose, -0, -8, 0).method_22915(r, g, b, 0f);

        vertexConsumer.method_70815(pose, 0, -8, 0).method_22915(r, g, b, 0f);
        vertexConsumer.method_70815(pose, 4, -7, 0).method_22915(r, g, b, 0f);
        vertexConsumer.method_70815(pose, 10, -3, 0).method_22915(r, g, b, 0f);

        vertexConsumer.method_70815(pose, 10, -3, 0).method_22915(r, g, b, 0f);
        vertexConsumer.method_70815(pose, 10, -3, 0).method_22915(r, g, b, 0f);
        vertexConsumer.method_70815(pose, 10, -3, 0).method_22915(r, g, b, 0f);
    }

    @Override
    public class_11231 comp_4056() {
        return class_11231.method_70899();
    }

    @Override
    public @Nullable class_8030 comp_4069() {
        return null;
    }
}
