package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.catnip.theme.Color;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

import java.awt.geom.Point2D;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_8030;

import static com.zurrtum.create.Create.MOD_ID;

public record RadialSectorRenderState(
    Matrix3x2f pose, int width, int height, List<Point2D> innerPoints, List<Point2D> outerPoints, int outerRed, int outerGreen, int outerBlue,
    int outerAlpha, int innerRed, int innerGreen, int innerBlue, int innerAlpha, class_8030 bounds
) implements class_11244 {
    public static final RenderPipeline POSITION_COLOR_STRIP = RenderPipeline.builder(class_10799.field_56860)
        .withLocation(class_2960.method_60655(MOD_ID, "pipeline/position_color_strip")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withCull(false)
        .withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).build();

    public RadialSectorRenderState(
        Matrix3x2f pose,
        int width,
        int height,
        List<Point2D> innerPoints,
        List<Point2D> outerPoints,
        Color outerColor,
        Color innerColor
    ) {
        this(
            pose,
            width,
            height,
            innerPoints,
            outerPoints,
            outerColor.getRed(),
            outerColor.getGreen(),
            outerColor.getBlue(),
            outerColor.getAlpha(),
            innerColor.getRed(),
            innerColor.getGreen(),
            innerColor.getBlue(),
            innerColor.getAlpha(),
            new class_8030(0, 0, width, height).method_71523(pose)
        );
    }

    @Override
    public RenderPipeline comp_4055() {
        return POSITION_COLOR_STRIP;
    }

    @Override
    public void method_70917(class_4588 vertexConsumer, float depth) {
        for (int i = 0; i < innerPoints.size(); i++) {
            Point2D point = outerPoints.get(i);
            vertexConsumer.method_70815(pose, (float) point.getX(), (float) point.getY(), 0).method_1336(outerRed, outerGreen, outerBlue, outerAlpha);

            point = innerPoints.get(i);
            vertexConsumer.method_70815(pose, (float) point.getX(), (float) point.getY(), 0).method_1336(innerRed, innerGreen, innerBlue, innerAlpha);
        }
    }

    @Override
    public class_11231 comp_4056() {
        return class_11231.method_70899();
    }

    @Override
    public @Nullable class_8030 comp_4069() {
        return null;
    }
}
