package com.zurrtum.create.client.catnip.gui.widget;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.TickableGuiEventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_6382;

public abstract class AbstractSimiWidget extends class_339 implements TickableGuiEventListener {

    public static final Color HEADER_RGB = new Color(0x5391e1, false);
    public static final Color HINT_RGB = new Color(0x96b7e0, false);

    public static final Couple<Color> COLOR_IDLE = Couple.create(new Color(0xdd_8ab6d6, true), new Color(0x90_8ab6d6, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_HOVER = Couple.create(new Color(0xff_9abbd3, true), new Color(0xd0_9abbd3, true))
        .map(Color::setImmutable);
    public static final Couple<Color> COLOR_CLICK = Couple.create(new Color(0xff_ffffff, true), new Color(0xee_ffffff, true))
        .map(Color::setImmutable);
    public static final Couple<Color> COLOR_DISABLED = Couple.create(new Color(0x80_909090, true), new Color(0x60_909090, true))
        .map(Color::setImmutable);
    public static final Couple<Color> COLOR_SUCCESS = Couple.create(new Color(0xcc_88f788, true), new Color(0xcc_20cc20, true))
        .map(Color::setImmutable);
    public static final Couple<Color> COLOR_FAIL = Couple.create(new Color(0xcc_f78888, true), new Color(0xcc_cc2020, true)).map(Color::setImmutable);

    protected float z;
    protected boolean wasHovered = false;
    protected List<class_2561> toolTip = new LinkedList<>();
    protected BiConsumer<Integer, Integer> onClick = (_$, _$$) -> {
    };

    public int lockedTooltipX = -1;
    public int lockedTooltipY = -1;

    protected AbstractSimiWidget(int x, int y) {
        this(x, y, 16, 16);
    }

    protected AbstractSimiWidget(int x, int y, int width, int height) {
        this(x, y, width, height, class_5244.field_39003);
    }

    protected AbstractSimiWidget(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
    }

    public <T extends AbstractSimiWidget> T withCallback(BiConsumer<Integer, Integer> cb) {
        this.onClick = cb;
        //noinspection unchecked
        return (T) this;
    }

    public <T extends AbstractSimiWidget> T withCallback(Runnable cb) {
        return withCallback((_$, _$$) -> cb.run());
    }

    public <T extends AbstractSimiWidget> T atZLevel(float z) {
        this.z = z;
        //noinspection unchecked
        return (T) this;
    }

    public <T extends AbstractSimiWidget> T setActive(boolean active) {
        this.field_22763 = active;
        return (T) this;
    }

    public List<class_2561> getToolTip() {
        return toolTip;
    }

    @Override
    public void tick() {
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (field_22764) {
            field_22762 = method_25405(mouseX, mouseY);
            method_48579(graphics, mouseX, mouseY, partialTicks);
            wasHovered = method_25367();
        }
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        beforeRender(graphics, mouseX, mouseY, partialTicks);
        doRender(graphics, mouseX, mouseY, partialTicks);
        afterRender(graphics, mouseX, mouseY, partialTicks);
    }

    protected void beforeRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_51448().pushMatrix();
    }

    protected void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void afterRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_51448().popMatrix();
    }

    public void runCallback(double mouseX, double mouseY) {
        onClick.accept((int) mouseX, (int) mouseY);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        runCallback(mouseX, mouseY);
    }

    @Override
    public void method_47399(class_6382 pNarrationElementOutput) {
        method_37021(pNarrationElementOutput);
    }

    public void method_53533(int value) {
        this.field_22759 = value;
    }
}
