package com.zurrtum.create.client.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.content.redstone.nixieTube.NixieTubeRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;

public class ContraptionControlsMovementRender implements MovementRenderBehaviour {
    private static final ThreadLocal<Random> RANDOM = ThreadLocal.withInitial(Random::new);

    @Override
    public void renderInContraption(
        MovementContext ctx,
        VirtualRenderWorld renderWorld,
        ContraptionMatrices matrices,
        class_4597 buffer
    ) {

        if (!(ctx.temporaryData instanceof ContraptionControlsMovement.ElevatorFloorSelection efs))
            return;
        if (!ctx.state.method_27852(AllBlocks.CONTRAPTION_CONTROLS))
            return;

        class_310 mc = class_310.method_1551();
        class_1297 cameraEntity = mc.method_1560();
        float playerDistance = (float) (ctx.position == null || cameraEntity == null ? 0 : ctx.position.method_1025(cameraEntity.method_33571()));

        float flicker = RANDOM.get().nextFloat();
        Couple<Integer> couple = DyeHelper.getDyeColors(efs.targetYEqualsSelection ? class_1767.field_7952 : class_1767.field_7946);
        int brightColor = couple.getFirst();
        int darkColor = couple.getSecond();
        int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4) | 0xFF000000;
        class_327 fontRenderer = mc.field_1772;
        float shadowOffset = .5f;

        String text = efs.currentShortName;
        String description = efs.currentLongName;
        class_4587 ms = matrices.getViewProjection();
        var msr = TransformStack.of(ms);

        float buttondepth = 0;
        if (ctx.contraption.presentBlockEntities.get(ctx.localPos) instanceof ContraptionControlsBlockEntity cbe)
            buttondepth = -1 / 24f * cbe.button.getValue(AnimationTickHolder.getPartialTicks(renderWorld));

        ms.method_22903();
        msr.translate(ctx.localPos);
        ms.method_46416(0, buttondepth, 0);
        class_4588 vc = buffer.getBuffer(class_1921.method_23577());
        CachedBuffers.partialFacing(
            AllPartialModels.CONTRAPTION_CONTROLS_BUTTON,
            ctx.state,
            ctx.state.method_11654(ContraptionControlsBlock.field_11177).method_10153()
        ).light(class_761.method_23794(renderWorld, ctx.localPos)).useLevelLight(ctx.world, matrices.getWorld()).renderInto(ms, vc);
        ms.method_22909();

        ms.method_22903();
        msr.translate(ctx.localPos);
        msr.rotateCentered(AngleHelper.rad(AngleHelper.horizontalAngle(ctx.state.method_11654(ContraptionControlsBlock.field_11177))), class_2350.field_11036);
        ms.method_46416(0.275f + 0.125f, 1 + 2 / 16f, 0.5f);
        msr.rotate(AngleHelper.rad(67.5f), class_2350.field_11039);

        if (!text.isBlank() && playerDistance < 100) {
            int actualWidth = fontRenderer.method_1727(text);
            int width = Math.max(actualWidth, 12);
            float scale = 1 / (5f * (width - .5f));
            float heightCentering = (width - 8f) / 2;

            ms.method_22903();
            ms.method_46416(0, .15f, buttondepth - .25f);
            ms.method_22905(scale, -scale, scale);
            ms.method_46416((float) Math.max(0, width - actualWidth) / 2, heightCentering, 0);
            NixieTubeRenderer.drawInWorldString(fontRenderer, ms, buffer, text, flickeringBrightColor);
            ms.method_46416(shadowOffset, shadowOffset, -1 / 16f);
            NixieTubeRenderer.drawInWorldString(fontRenderer, ms, buffer, text, Color.mixColors(darkColor, 0, .35f) | 0xFF000000);
            ms.method_22909();
        }

        if (!description.isBlank() && playerDistance < 20) {
            int actualWidth = fontRenderer.method_1727(description);
            int width = Math.max(actualWidth, 55);
            float scale = 1 / (3f * (width - .5f));
            float heightCentering = (width - 8f) / 2;

            ms.method_22903();
            ms.method_46416(-.0635f, 0.06f, buttondepth - .25f);
            ms.method_22905(scale, -scale, scale);
            ms.method_46416((float) Math.max(0, width - actualWidth) / 2, heightCentering, 0);
            NixieTubeRenderer.drawInWorldString(fontRenderer, ms, buffer, description, flickeringBrightColor);
            ms.method_22909();
        }

        ms.method_22909();

    }
}
