package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.flywheel.api.material.CardinalLightingMode;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.visual.*;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualEmbedding;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.ModelUtil;
import com.zurrtum.create.client.flywheel.lib.model.baked.BlockModelBuilder;
import com.zurrtum.create.client.flywheel.lib.task.ForEachPlan;
import com.zurrtum.create.client.flywheel.lib.task.NestedPlan;
import com.zurrtum.create.client.flywheel.lib.task.PlanMap;
import com.zurrtum.create.client.flywheel.lib.task.RunnablePlan;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.foundation.utility.worldWrappers.WrappedBlockAndTintGetter;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.Contraption.RenderedBlocks;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import org.apache.commons.lang3.tuple.MutablePair;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4587;

public class ContraptionVisual<E extends AbstractContraptionEntity> extends AbstractEntityVisual<E> implements DynamicVisual, TickableVisual, LightUpdatedVisual, ShaderLightVisual {
    protected static final int LIGHT_PADDING = 1;

    protected final VisualEmbedding embedding;
    protected final List<BlockEntityVisual<?>> children = new ArrayList<>();
    protected final List<ActorVisual> actors = new ArrayList<>();
    protected final PlanMap<DynamicVisual, DynamicVisual.Context> dynamicVisuals = new PlanMap<>();
    protected final PlanMap<TickableVisual, TickableVisual.Context> tickableVisuals = new PlanMap<>();
    protected VirtualRenderWorld virtualRenderWorld;
    protected Model model;
    protected TransformedInstance structure;
    protected SectionCollector sectionCollector;
    protected long minSection, maxSection;
    protected long minBlock, maxBlock;

    private final class_4587 contraptionMatrix = new class_4587();

    public ContraptionVisual(VisualizationContext ctx, E entity, float partialTick) {
        super(ctx, entity, partialTick);
        embedding = ctx.createEmbedding(class_2382.field_11176);

        setEmbeddingMatrices(partialTick);

        Contraption contraption = entity.getContraption();
        // The contraption could be null if it wasn't synced (ex. too much data)
        if (contraption == null)
            return;

        setupModel(contraption);

        setupChildren(partialTick, contraption);

        setupActors(partialTick, contraption);
    }

    // Must be called before setup children or setup actors as this creates the render world
    private void setupModel(Contraption contraption) {
        virtualRenderWorld = ContraptionRenderInfo.get(contraption).getRenderWorld();

        RenderedBlocks blocks = contraption.getRenderedBlocks();
        class_1920 modelWorld = new WrappedBlockAndTintGetter(virtualRenderWorld) {
            @Override
            public class_2680 method_8320(class_2338 pos) {
                return blocks.lookup().apply(pos);
            }
        };

        model = new BlockModelBuilder(modelWorld, blocks.positions()).materialFunc((renderType, shaded) -> {
            Material material = ModelUtil.getMaterial(renderType, shaded);
            if (material != null && material.cardinalLightingMode() == CardinalLightingMode.ENTITY) {
                return SimpleMaterial.builderOf(material).cardinalLightingMode(CardinalLightingMode.CHUNK).build();
            } else {
                return material;
            }
        }).build();

        var instancer = embedding.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model);

        // Null in ctor, so we need to create it
        // But we can steal it if it already exists
        if (structure == null) {
            structure = instancer.createInstance();
        } else {
            instancer.stealInstance(structure);
        }

        structure.setChanged();

    }

    private void setupChildren(float partialTick, Contraption contraption) {
        children.forEach(BlockEntityVisual::delete);
        children.clear();
        for (class_2586 be : contraption.getRenderedBEs()) {
            setupVisualizer(be, partialTick);
        }
    }

    private void setupActors(float partialTick, Contraption contraption) {
        actors.forEach(ActorVisual::delete);
        actors.clear();
        for (var actor : contraption.getActors()) {
            setupActor(actor, partialTick);
        }
    }

    @SuppressWarnings("unchecked")
    protected <T extends class_2586> void setupVisualizer(T be, float partialTicks) {
        BlockEntityVisualizer<? super T> visualizer = (BlockEntityVisualizer<? super T>) VisualizerRegistry.getVisualizer(be.method_11017());
        if (visualizer == null) {
            return;
        }

        class_1937 level = be.method_10997();
        be.method_31662(virtualRenderWorld);
        BlockEntityVisual<? super T> visual = visualizer.createVisual(this.embedding, be, partialTicks);

        children.add(visual);

        if (visual instanceof DynamicVisual dynamic) {
            dynamicVisuals.add(dynamic, dynamic.planFrame());
        }

        if (visual instanceof TickableVisual tickable) {
            tickableVisuals.add(tickable, tickable.planTick());
        }

        be.method_31662(level);
    }

    private void setupActor(MutablePair<class_3499.class_3501, MovementContext> actor, float partialTick) {
        MovementContext context = actor.getRight();
        if (context == null) {
            return;
        }
        if (context.world == null) {
            context.world = level;
        }

        class_3499.class_3501 blockInfo = actor.getLeft();

        MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get(blockInfo.comp_1342());
        if (movementBehaviour == null || movementBehaviour.attachRender == null) {
            return;
        }
        MovementRenderBehaviour render = (MovementRenderBehaviour) movementBehaviour.attachRender;
        var visual = render.createVisual(this.embedding, virtualRenderWorld, context);

        if (visual == null) {
            return;
        }

        actors.add(visual);
    }

    @Override
    public Plan<TickableVisual.Context> planTick() {
        return NestedPlan.of(ForEachPlan.of(() -> actors, ActorVisual::tick), tickableVisuals);
    }

    @Override
    public Plan<DynamicVisual.Context> planFrame() {
        return NestedPlan.of(RunnablePlan.of(this::beginFrame), ForEachPlan.of(() -> actors, ActorVisual::beginFrame), dynamicVisuals);
    }

    protected void beginFrame(DynamicVisual.Context context) {
        var partialTick = context.partialTick();
        setEmbeddingMatrices(partialTick);

        if (hasMovedSections()) {
            sectionCollector.sections(collectLightSections());
        }

        if (hasMovedBlocks()) {
            updateLight(partialTick);
        }

        var contraption = entity.getContraption();
        if (contraption.deferInvalidate) {
            setupModel(contraption);
            setupChildren(partialTick, contraption);
            setupActors(partialTick, contraption);

            contraption.deferInvalidate = false;
        }
    }

    private void setEmbeddingMatrices(float partialTick) {
        var origin = renderOrigin();
        double x;
        double y;
        double z;
        if (entity.isPrevPosInvalid()) {
            // When the visual is created the entity's old position is often zero
            x = entity.method_23317() - origin.method_10263();
            y = entity.method_23318() - origin.method_10264();
            z = entity.method_23321() - origin.method_10260();

        } else {
            x = class_3532.method_16436(partialTick, entity.field_6014, entity.method_23317()) - origin.method_10263();
            y = class_3532.method_16436(partialTick, entity.field_6036, entity.method_23318()) - origin.method_10264();
            z = class_3532.method_16436(partialTick, entity.field_5969, entity.method_23321()) - origin.method_10260();
        }

        contraptionMatrix.method_34426();
        contraptionMatrix.method_22904(x, y, z);
        transform(contraptionMatrix, partialTick);

        embedding.transforms(contraptionMatrix.method_23760().method_23761(), contraptionMatrix.method_23760().method_23762());
    }

    public void transform(class_4587 contraptionMatrix, float partialTick) {
    }

    @Override
    public void updateLight(float partialTick) {
    }

    public LongSet collectLightSections() {
        var boundingBox = entity.method_5829();

        var minSectionX = minLightSection(boundingBox.field_1323);
        var minSectionY = minLightSection(boundingBox.field_1322);
        var minSectionZ = minLightSection(boundingBox.field_1321);
        int maxSectionX = maxLightSection(boundingBox.field_1320);
        int maxSectionY = maxLightSection(boundingBox.field_1325);
        int maxSectionZ = maxLightSection(boundingBox.field_1324);

        minSection = class_4076.method_18685(minSectionX, minSectionY, minSectionZ);
        maxSection = class_4076.method_18685(maxSectionX, maxSectionY, maxSectionZ);

        LongSet longSet = new LongArraySet();

        for (int x = 0; x <= maxSectionX - minSectionX; x++) {
            for (int y = 0; y <= maxSectionY - minSectionY; y++) {
                for (int z = 0; z <= maxSectionZ - minSectionZ; z++) {
                    longSet.add(class_4076.method_18678(minSection, x, y, z));
                }
            }
        }

        return longSet;
    }

    protected boolean hasMovedBlocks() {
        var boundingBox = entity.method_5829();

        int minX = minLight(boundingBox.field_1323);
        int minY = minLight(boundingBox.field_1322);
        int minZ = minLight(boundingBox.field_1321);
        int maxX = maxLight(boundingBox.field_1320);
        int maxY = maxLight(boundingBox.field_1325);
        int maxZ = maxLight(boundingBox.field_1324);

        return minBlock != class_2338.method_10064(minX, minY, minZ) || maxBlock != class_2338.method_10064(maxX, maxY, maxZ);
    }

    protected boolean hasMovedSections() {
        var boundingBox = entity.method_5829();

        var minSectionX = minLightSection(boundingBox.field_1323);
        var minSectionY = minLightSection(boundingBox.field_1322);
        var minSectionZ = minLightSection(boundingBox.field_1321);
        int maxSectionX = maxLightSection(boundingBox.field_1320);
        int maxSectionY = maxLightSection(boundingBox.field_1325);
        int maxSectionZ = maxLightSection(boundingBox.field_1324);

        return minSection != class_4076.method_18685(minSectionX, minSectionY, minSectionZ) || maxSection != class_4076.method_18685(
            maxSectionX,
            maxSectionY,
            maxSectionZ
        );
    }

    @Override
    public void setSectionCollector(SectionCollector collector) {
        this.sectionCollector = collector;
    }

    @Override
    protected void _delete() {
        children.forEach(BlockEntityVisual::delete);

        actors.forEach(ActorVisual::delete);

        if (structure != null) {
            structure.delete();
        }

        embedding.delete();
    }

    public static int minLight(double aabbPos) {
        return class_3532.method_15357(aabbPos) - LIGHT_PADDING;
    }

    public static int maxLight(double aabbPos) {
        return class_3532.method_15384(aabbPos) + LIGHT_PADDING;
    }

    public static int minLightSection(double aabbPos) {
        return class_4076.method_18675(minLight(aabbPos));
    }

    public static int maxLightSection(double aabbPos) {
        return class_4076.method_18675(maxLight(aabbPos));
    }
}
