package com.zurrtum.create.client.content.equipment.goggles;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.equipment.goggles.IProxyHoveringInformation;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.api.goggles.IHaveCustomOverlayIcon;
import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.api.goggles.IHaveHoveringInformation;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.outliner.Outline;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.catnip.outliner.Outliner.OutlineEntry;
import com.zurrtum.create.client.content.contraptions.IDisplayAssemblyExceptions;
import com.zurrtum.create.client.content.trains.entity.TrainRelocatorClient;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.gui.RemovedGuiUtils;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.client.infrastructure.config.CClient;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.zurrtum.create.content.equipment.goggles.GogglesItem;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.joml.Matrix3x2fStack;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_9779;

public class GoggleOverlayRenderer {

    private static final Map<Object, OutlineEntry> outlines = Outliner.getInstance().getOutlines();

    public static int hoverTicks = 0;
    public static class_2338 lastHovered = null;

    public static void renderOverlay(class_310 mc, class_332 guiGraphics, class_9779 deltaTracker) {
        class_239 objectMouseOver = mc.field_1765;
        if (!(objectMouseOver instanceof class_3965 result)) {
            lastHovered = null;
            hoverTicks = 0;
            return;
        }

        for (OutlineEntry entry : outlines.values()) {
            if (!entry.isAlive())
                continue;
            Outline outline = entry.getOutline();
            if (outline instanceof ValueBox && !((ValueBox) outline).isPassive)
                return;
        }

        class_638 world = mc.field_1687;
        class_2338 pos = result.method_17777();

        int prevHoverTicks = hoverTicks;
        hoverTicks++;
        lastHovered = pos;

        pos = proxiedOverlayPosition(world, pos);

        TooltipBehaviour<?> be = BlockEntityBehaviour.get(world, pos, TooltipBehaviour.TYPE);
        boolean wearingGoggles = GogglesItem.isWearingGoggles(mc.field_1724);

        boolean isShifting = mc.field_1724.method_5715();

        boolean hasGoggleInformation = be instanceof IHaveGoggleInformation;
        boolean hasHoveringInformation = be instanceof IHaveHoveringInformation;

        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;

        class_1799 item = new class_1799(AllItems.GOGGLES);
        List<class_2561> tooltip = new ArrayList<>();

        if (be instanceof IHaveCustomOverlayIcon customOverlayIcon)
            item = customOverlayIcon.getIcon(isShifting);

        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation) be;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, isShifting);
        }

        if (hasHoveringInformation) {
            if (!tooltip.isEmpty())
                tooltip.add(class_5244.field_39003);
            IHaveHoveringInformation hte = (IHaveHoveringInformation) be;
            hoverAddedInformation = hte.addToTooltip(tooltip, isShifting);

            if (goggleAddedInformation && !hoverAddedInformation)
                tooltip.remove(tooltip.size() - 1);
        }

        if (be instanceof IDisplayAssemblyExceptions) {
            boolean exceptionAdded = ((IDisplayAssemblyExceptions) be).addExceptionToTooltip(tooltip);
            if (exceptionAdded) {
                hasHoveringInformation = true;
                hoverAddedInformation = true;
            }
        }

        if (!hasHoveringInformation)
            if (hasHoveringInformation = hoverAddedInformation = TrainRelocatorClient.addToTooltip(tooltip))
                hoverTicks = prevHoverTicks + 1;

        // break early if goggle or hover returned false when present
        if ((hasGoggleInformation && !goggleAddedInformation) && (hasHoveringInformation && !hoverAddedInformation)) {
            hoverTicks = 0;
            return;
        }

        // check for piston poles if goggles are worn
        class_2680 state = world.method_8320(pos);
        if (wearingGoggles && state.method_27852(AllBlocks.PISTON_EXTENSION_POLE)) {
            class_2350[] directions = Iterate.directionsInAxis(state.method_11654(PistonExtensionPoleBlock.field_10927).method_10166());
            int poles = 1;
            boolean pistonFound = false;
            for (class_2350 dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles(world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.method_8320(pos.method_10079(dir, attachedPoles + 1)).method_26204() instanceof MechanicalPistonBlock;
            }

            if (!pistonFound) {
                hoverTicks = 0;
                return;
            }
            if (!tooltip.isEmpty())
                tooltip.add(class_5244.field_39003);

            CreateLang.translate("gui.goggles.pole_length").text(" " + poles).forGoggles(tooltip);
        }

        if (tooltip.isEmpty()) {
            hoverTicks = 0;
            return;
        }

        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();

        int tooltipTextWidth = 0;
        for (class_5348 textLine : tooltip) {
            int textLineWidth = mc.field_1772.method_27525(textLine);
            if (textLineWidth > tooltipTextWidth)
                tooltipTextWidth = textLineWidth;
        }

        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2; // gap between title lines and next lines
            tooltipHeight += (tooltip.size() - 1) * 10;
        }

        int width = guiGraphics.method_51421();
        int height = guiGraphics.method_51443();

        CClient cfg = AllConfigs.client();
        int posX = width / 2 + cfg.overlayOffsetX.get();
        int posY = height / 2 + cfg.overlayOffsetY.get();

        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);

        float fade = class_3532.method_15363((hoverTicks + deltaTracker.method_60637(false)) / 24f, 0, 1);
        Boolean useCustom = cfg.overlayCustomColor.get();
        Color colorBackground = useCustom ? new Color(cfg.overlayBackgroundColor.get()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(.75f);
        Color colorBorderTop = useCustom ? new Color(cfg.overlayBorderColorTop.get()) : BoxElement.COLOR_VANILLA_BORDER.getFirst().copy();
        Color colorBorderBot = useCustom ? new Color(cfg.overlayBorderColorBot.get()) : BoxElement.COLOR_VANILLA_BORDER.getSecond().copy();

        if (fade < 1) {
            poseStack.translate((float) (Math.pow(1 - fade, 3) * Math.signum(cfg.overlayOffsetX.get() + .5f) * 8), 0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }

        //TODO
        //        if (!Mods.MODERNUI.isLoaded()) {
        //            // default tooltip rendering when modernUI is not loaded
        //            RemovedGuiUtils.drawHoveringText(
        //                guiGraphics,
        //                tooltip,
        //                posX,
        //                posY,
        //                width,
        //                height,
        //                -1,
        //                colorBackground.getRGB(),
        //                colorBorderTop.getRGB(),
        //                colorBorderBot.getRGB(),
        //                mc.textRenderer
        //            );
        //
        //            poseStack.pop();
        //
        //            return;
        //        }

        /*
         * special handling for modernUI
         *
         * their tooltip handler causes the overlay to jiggle each frame,
         * if the mouse is moving, guiScale is anything but 1 and exactPositioning is enabled
         *
         * this is a workaround to fix this behavior
         */
        class_312 mouseHandler = mc.field_1729;
        class_1041 window = mc.method_22683();
        double guiScale = window.method_4495();
        double cursorX = mouseHandler.method_1603();
        double cursorY = mouseHandler.method_1604();
        mouseHandler.field_1795 = Math.round(cursorX / guiScale) * guiScale;
        mouseHandler.field_1794 = Math.round(cursorY / guiScale) * guiScale;

        RemovedGuiUtils.drawHoveringText(
            guiGraphics,
            tooltip,
            posX,
            posY,
            width,
            height,
            -1,
            colorBackground.getRGB(),
            colorBorderTop.getRGB(),
            colorBorderBot.getRGB(),
            mc.field_1772
        );

        guiGraphics.method_51427(item, posX + 10, posY - 16);

        mouseHandler.field_1795 = cursorX;
        mouseHandler.field_1794 = cursorY;
        poseStack.popMatrix();

    }

    public static class_2338 proxiedOverlayPosition(class_1937 level, class_2338 pos) {
        class_2680 targetedState = level.method_8320(pos);
        if (targetedState.method_26204() instanceof IProxyHoveringInformation proxy)
            return proxy.getInformationSource(level, pos, targetedState);
        return pos;
    }

}
