package com.zurrtum.create.client.content.equipment.toolbox;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class ToolboxRenderer extends SmartBlockEntityRenderer<ToolboxBlockEntity> {

    public ToolboxRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        ToolboxBlockEntity blockEntity,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {

        class_2680 blockState = blockEntity.method_11010();
        class_2350 facing = blockState.method_11654(ToolboxBlock.field_11177).method_10153();
        SuperByteBuffer lid = CachedBuffers.partial(AllPartialModels.TOOLBOX_LIDS.get(blockEntity.getColor()), blockState);
        SuperByteBuffer drawer = CachedBuffers.partial(AllPartialModels.TOOLBOX_DRAWER, blockState);

        float lidAngle = blockEntity.lid.getValue(partialTicks);
        float drawerOffset = blockEntity.drawers.getValue(partialTicks);

        class_4588 builder = buffer.getBuffer(class_1921.method_23579());
        lid.center().rotateYDegrees(-facing.method_10144()).uncenter().translate(0, 6 / 16f, 12 / 16f).rotateXDegrees(135 * lidAngle)
            .translate(0, -6 / 16f, -12 / 16f).light(light).renderInto(ms, builder);

        for (int offset : Iterate.zeroAndOne) {
            drawer.center().rotateYDegrees(-facing.method_10144()).uncenter()
                .translate(0, offset * 1 / 8f, -drawerOffset * .175f * (2 - offset)).light(light).renderInto(ms, builder);
        }

    }

}
