package com.zurrtum.create.client.content.kinetics.base;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.kinetics.KineticDebugger;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;

public class KineticBlockEntityRenderer<T extends KineticBlockEntity> extends SafeBlockEntityRenderer<T> {

    public static final SuperByteBufferCache.Compartment<class_2680> KINETIC_BLOCK = new SuperByteBufferCache.Compartment<>();
    public static boolean rainbowMode = false;

    public KineticBlockEntityRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(T be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        class_2680 state = getRenderedBlockState(be);
        class_1921 type = getRenderType(be, state);
        renderRotatingBuffer(be, getRotatedModel(be, state), ms, buffer.getBuffer(type), light);
    }

    protected class_2680 getRenderedBlockState(T be) {
        return be.method_11010();
    }

    protected class_1921 getRenderType(T be, class_2680 state) {
        return class_4696.method_29359(state);
    }

    protected SuperByteBuffer getRotatedModel(T be, class_2680 state) {
        return CachedBuffers.block(KINETIC_BLOCK, state);
    }

    public static void renderRotatingKineticBlock(KineticBlockEntity be, class_2680 renderedState, class_4587 ms, class_4588 buffer, int light) {
        SuperByteBuffer superByteBuffer = CachedBuffers.block(KINETIC_BLOCK, renderedState);
        renderRotatingBuffer(be, superByteBuffer, ms, buffer, light);
    }

    public static void renderRotatingBuffer(KineticBlockEntity be, SuperByteBuffer superBuffer, class_4587 ms, class_4588 buffer, int light) {
        standardKineticRotationTransform(superBuffer, be, light).renderInto(ms, buffer);
    }

    public static float getAngleForBe(KineticBlockEntity be, final class_2338 pos, class_2351 axis) {
        float time = AnimationTickHolder.getRenderTime(be.method_10997());
        float offset = getRotationOffsetForPosition(be, pos, axis);
        float angle = ((time * be.getSpeed() * 3f / 10 + offset) % 360) / 180 * (float) Math.PI;
        return angle;
    }

    public static SuperByteBuffer standardKineticRotationTransform(SuperByteBuffer buffer, KineticBlockEntity be, int light) {
        final class_2338 pos = be.method_11016();
        class_2351 axis = ((IRotate) be.method_11010().method_26204()).getRotationAxis(be.method_11010());
        return kineticRotationTransform(buffer, be, axis, getAngleForBe(be, pos, axis), light);
    }

    public static SuperByteBuffer kineticRotationTransform(SuperByteBuffer buffer, KineticBlockEntity be, class_2351 axis, float angle, int light) {
        buffer.light(light);
        buffer.rotateCentered(angle, class_2350.method_10156(class_2352.field_11056, axis));

        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            buffer.color(be.hasNetwork() ? Color.generateFromLong(be.network) : Color.WHITE);
        } else {
            float overStressedEffect = be.effects.overStressedEffect;
            if (overStressedEffect != 0)
                if (overStressedEffect > 0)
                    buffer.color(Color.WHITE.mixWith(Color.RED, overStressedEffect));
                else
                    buffer.color(Color.WHITE.mixWith(Color.SPRING_GREEN, -overStressedEffect));
            else
                buffer.color(Color.WHITE);
        }

        return buffer;
    }

    public static float getRotationOffsetForPosition(KineticBlockEntity be, final class_2338 pos, final class_2351 axis) {
        return KineticBlockEntityVisual.rotationOffset(be.method_11010(), axis, pos) + be.getRotationAngleOffset(axis);
    }

    public static class_2680 shaft(class_2351 axis) {
        return AllBlocks.SHAFT.method_9564().method_11657(class_2741.field_12496, axis);
    }

    public static class_2351 getRotationAxisOf(KineticBlockEntity be) {
        return ((IRotate) be.method_11010().method_26204()).getRotationAxis(be.method_11010());
    }

}
