package com.zurrtum.create.client.content.kinetics.belt;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.render.ShadowRenderHelper;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.kinetics.belt.*;
import com.zurrtum.create.content.kinetics.belt.transport.BeltInventory;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.util.math.*;
import java.util.Random;
import java.util.function.Supplier;

public class BeltRenderer extends SafeBlockEntityRenderer<BeltBlockEntity> {

    public BeltRenderer(class_5614.class_5615 context) {
    }

    @Override
    public boolean method_3563(/*BeltBlockEntity be*/) {
        //TODO
        //        return be.isController();
        return true;
    }

    @Override
    protected void renderSafe(BeltBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        if (!VisualizationManager.supportsVisualization(be.method_10997())) {

            class_2680 blockState = be.method_11010();
            if (!blockState.method_27852(AllBlocks.BELT))
                return;

            BeltSlope beltSlope = blockState.method_11654(BeltBlock.SLOPE);
            BeltPart part = blockState.method_11654(BeltBlock.PART);
            class_2350 facing = blockState.method_11654(BeltBlock.HORIZONTAL_FACING);
            class_2352 axisDirection = facing.method_10171();

            boolean downward = beltSlope == BeltSlope.DOWNWARD;
            boolean upward = beltSlope == BeltSlope.UPWARD;
            boolean diagonal = downward || upward;
            boolean start = part == BeltPart.START;
            boolean end = part == BeltPart.END;
            boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
            boolean alongX = facing.method_10166() == class_2350.class_2351.field_11048;

            class_4587 localTransforms = new class_4587();
            var msr = TransformStack.of(localTransforms);
            class_4588 vb = buffer.getBuffer(class_1921.method_23577());
            float renderTick = AnimationTickHolder.getRenderTime(be.method_10997());

            msr.center().rotateYDegrees(AngleHelper.horizontalAngle(facing) + (upward ? 180 : 0) + (sideways ? 270 : 0))
                .rotateZDegrees(sideways ? 90 : 0).rotateXDegrees(!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90 : 0).uncenter();

            if (downward || beltSlope == BeltSlope.VERTICAL && axisDirection == class_2352.field_11056) {
                boolean b = start;
                start = end;
                end = b;
            }

            class_1767 color = be.color.orElse(null);

            for (boolean bottom : Iterate.trueAndFalse) {

                PartialModel beltPartial = getBeltPartial(diagonal, start, end, bottom);

                SuperByteBuffer beltBuffer = CachedBuffers.partial(beltPartial, blockState).light(light);

                SpriteShiftEntry spriteShift = getSpriteShiftEntry(color, diagonal, bottom);

                // UV shift
                float speed = be.getSpeed();
                if (speed != 0 || be.color.isPresent()) {
                    float time = renderTick * axisDirection.method_10181();
                    if (diagonal && (downward ^ alongX) || !sideways && !diagonal && alongX || sideways && axisDirection == class_2352.field_11060)
                        speed = -speed;

                    float scrollMult = diagonal ? 3f / 8f : 0.5f;

                    float spriteSize = spriteShift.getTarget().method_4575() - spriteShift.getTarget().method_4593();

                    double scroll = speed * time / (31.5 * 16) + (bottom ? 0.5 : 0.0);
                    scroll = scroll - Math.floor(scroll);
                    scroll = scroll * spriteSize * scrollMult;

                    beltBuffer.shiftUVScrolling(spriteShift, (float) scroll);
                }

                beltBuffer.transform(localTransforms).renderInto(ms, vb);

                // Diagonal belt do not have a separate bottom model
                if (diagonal)
                    break;
            }

            if (be.hasPulley()) {
                class_2350 dir = sideways ? class_2350.field_11036 : blockState.method_11654(BeltBlock.HORIZONTAL_FACING).method_10170();

                Supplier<class_4587> matrixStackSupplier = () -> {
                    class_4587 stack = new class_4587();
                    var stacker = TransformStack.of(stack);
                    stacker.center();
                    if (dir.method_10166() == class_2350.class_2351.field_11048)
                        stacker.rotateYDegrees(90);
                    if (dir.method_10166() == class_2350.class_2351.field_11052)
                        stacker.rotateXDegrees(90);
                    stacker.rotateXDegrees(90);
                    stacker.uncenter();
                    return stack;
                };

                SuperByteBuffer superBuffer = CachedBuffers.partialDirectional(AllPartialModels.BELT_PULLEY, blockState, dir, matrixStackSupplier);
                KineticBlockEntityRenderer.standardKineticRotationTransform(superBuffer, be, light).renderInto(ms, vb);
            }
        }

        renderItems(be, partialTicks, ms, buffer, light, overlay);
    }

    public static SpriteShiftEntry getSpriteShiftEntry(class_1767 color, boolean diagonal, boolean bottom) {
        if (color != null) {
            return (diagonal ? AllSpriteShifts.DYED_DIAGONAL_BELTS : bottom ? AllSpriteShifts.DYED_OFFSET_BELTS : AllSpriteShifts.DYED_BELTS).get(
                color);
        } else
            return diagonal ? AllSpriteShifts.BELT_DIAGONAL : bottom ? AllSpriteShifts.BELT_OFFSET : AllSpriteShifts.BELT;
    }

    public static PartialModel getBeltPartial(boolean diagonal, boolean start, boolean end, boolean bottom) {
        if (diagonal) {
            if (start)
                return AllPartialModels.BELT_DIAGONAL_START;
            if (end)
                return AllPartialModels.BELT_DIAGONAL_END;
            return AllPartialModels.BELT_DIAGONAL_MIDDLE;
        } else if (bottom) {
            if (start)
                return AllPartialModels.BELT_START_BOTTOM;
            if (end)
                return AllPartialModels.BELT_END_BOTTOM;
            return AllPartialModels.BELT_MIDDLE_BOTTOM;
        } else {
            if (start)
                return AllPartialModels.BELT_START;
            if (end)
                return AllPartialModels.BELT_END;
            return AllPartialModels.BELT_MIDDLE;
        }
    }

    protected void renderItems(BeltBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (!be.isController())
            return;
        if (be.beltLength == 0)
            return;

        ms.method_22903();

        class_2350 beltFacing = be.getBeltFacing();
        class_2382 directionVec = beltFacing.method_62675();
        class_243 beltStartOffset = class_243.method_24954(directionVec).method_1021(-.5).method_1031(.5, 15 / 16f, .5);
        ms.method_22904(beltStartOffset.field_1352, beltStartOffset.field_1351, beltStartOffset.field_1350);
        BeltSlope slope = be.method_11010().method_11654(BeltBlock.SLOPE);
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : slope == BeltSlope.UPWARD ? 1 : 0;
        boolean slopeAlongX = beltFacing.method_10166() == class_2350.class_2351.field_11048;
        boolean onContraption = be.method_10997() instanceof WrappedLevel;

        BeltInventory inventory = be.getInventory();
        for (TransportedItemStack transported : inventory.getTransportedItems())
            renderItem(
                be,
                partialTicks,
                ms,
                buffer,
                light,
                overlay,
                beltFacing,
                directionVec,
                slope,
                verticality,
                slopeAlongX,
                onContraption,
                transported,
                beltStartOffset
            );
        if (inventory.getLazyClientItem() != null)
            renderItem(
                be,
                partialTicks,
                ms,
                buffer,
                light,
                overlay,
                beltFacing,
                directionVec,
                slope,
                verticality,
                slopeAlongX,
                onContraption,
                inventory.getLazyClientItem(),
                beltStartOffset
            );

        ms.method_22909();
    }

    private void renderItem(
        BeltBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay,
        class_2350 beltFacing,
        class_2382 directionVec,
        BeltSlope slope,
        int verticality,
        boolean slopeAlongX,
        boolean onContraption,
        TransportedItemStack transported,
        class_243 beltStartOffset
    ) {
        class_310 mc = class_310.method_1551();
        class_918 itemRenderer = mc.method_1480();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();

        float offset = class_3532.method_16439(partialTicks, transported.prevBeltPosition, transported.beltPosition);
        float sideOffset = class_3532.method_16439(partialTicks, transported.prevSideOffset, transported.sideOffset);
        float verticalMovement = verticality;

        if (be.getSpeed() == 0) {
            offset = transported.beltPosition;
            sideOffset = transported.sideOffset;
        }

        if (offset < .5)
            verticalMovement = 0;
        else
            verticalMovement = verticality * (Math.min(offset, be.beltLength - .5f) - .5f);
        class_243 offsetVec = class_243.method_24954(directionVec).method_1021(offset);
        if (verticalMovement != 0)
            offsetVec = offsetVec.method_1031(0, verticalMovement, 0);
        boolean onSlope = slope != BeltSlope.HORIZONTAL && class_3532.method_15363(offset, .5f, be.beltLength - .5f) == offset;
        boolean tiltForward = (slope == BeltSlope.DOWNWARD ^ beltFacing.method_10171() == class_2352.field_11056) == (beltFacing.method_10166() == class_2350.class_2351.field_11051);
        float slopeAngle = onSlope ? tiltForward ? -45 : 45 : 0;

        class_2338 pos = be.method_11016();
        class_243 itemPos = beltStartOffset.method_1031(pos.method_10263(), pos.method_10264(), pos.method_10260()).method_1019(offsetVec);

        if (this.shouldCullItem(itemPos, be.method_10997())) {
            return;
        }

        ms.method_22903();
        TransformStack.of(ms).nudge(transported.angle);
        ms.method_22904(offsetVec.field_1352, offsetVec.field_1351, offsetVec.field_1350);

        boolean alongX = beltFacing.method_10170().method_10166() == class_2350.class_2351.field_11048;
        if (!alongX)
            sideOffset *= -1;
        ms.method_46416(alongX ? sideOffset : 0, 0, alongX ? 0 : sideOffset);

        int stackLight;
        if (onContraption) {
            stackLight = light;
        } else {
            int segment = (int) Math.floor(offset);
            mutablePos.method_10101(pos).method_10100(directionVec.method_10263() * segment, verticality * segment, directionVec.method_10260() * segment);
            stackLight = class_761.method_23794(be.method_10997(), mutablePos);
        }

        boolean renderUpright = BeltHelper.isItemUpright(transported.stack);
        itemRenderer.field_55296.method_65598(
            itemRenderer.field_55297,
            transported.stack,
            class_811.field_4319,
            be.method_10997(),
            null,
            0
        );
        boolean blockItem = itemRenderer.field_55297.method_65608();

        int count = 0;
        if (be.method_10997() instanceof PonderLevel || mc.field_1724.method_5836(1.0F).method_1022(itemPos) < 16)
            count = class_3532.method_15351(transported.stack.method_7947()) / 2;

        Random r = new Random(transported.angle);

        boolean slopeShadowOnly = renderUpright && onSlope;
        float slopeOffset = 1 / 8f;
        if (slopeShadowOnly)
            ms.method_22903();
        if (!renderUpright || slopeShadowOnly)
            ms.method_22907((slopeAlongX ? class_7833.field_40718 : class_7833.field_40714).rotationDegrees(slopeAngle));
        if (onSlope)
            ms.method_46416(0, slopeOffset, 0);
        ms.method_22903();
        ms.method_46416(0, -1 / 8f + 0.005f, 0);
        ShadowRenderHelper.renderShadow(ms, buffer, .75f, .2f);
        ms.method_22909();
        if (slopeShadowOnly) {
            ms.method_22909();
            ms.method_46416(0, slopeOffset, 0);
        }

        if (renderUpright) {
            class_1297 renderViewEntity = mc.field_1719;
            if (renderViewEntity != null) {
                class_243 positionVec = renderViewEntity.method_19538();
                class_243 vectorForOffset = BeltHelper.getVectorForOffset(be, offset);
                class_243 diff = vectorForOffset.method_1020(positionVec);
                float yRot = (float) (class_3532.method_15349(diff.field_1352, diff.field_1350) + Math.PI);
                ms.method_22907(class_7833.field_40716.rotation(yRot));
            }
            ms.method_22904(0, 3 / 32d, 1 / 16f);
        }

        for (int i = 0; i <= count; i++) {
            ms.method_22903();

            boolean box = PackageItem.isPackage(transported.stack);
            ms.method_22907(class_7833.field_40716.rotationDegrees(transported.angle));
            if (!blockItem && !renderUpright) {
                ms.method_22904(0, -.09375, 0);
                ms.method_22907(class_7833.field_40714.rotationDegrees(90));
            }

            if (blockItem && !box)
                ms.method_46416(r.nextFloat() * .0625f * i, 0, r.nextFloat() * .0625f * i);

            if (box) {
                ms.method_46416(0, 4 / 16f, 0);
                ms.method_22905(1.5f, 1.5f, 1.5f);
            } else {
                ms.method_22905(.5f, .5f, .5f);
            }

            itemRenderer.field_55297.method_65604(ms, buffer, light, overlay);
            ms.method_22909();

            if (!renderUpright) {
                if (!blockItem)
                    ms.method_22907(class_7833.field_40716.rotationDegrees(10));
                ms.method_22904(0, blockItem ? 1 / 64d : 1 / 16d, 0);
            } else
                ms.method_46416(0, 0, -1 / 16f);

        }

        ms.method_22909();
    }
}
