package com.zurrtum.create.client.content.kinetics.crank;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlock;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlockEntity;
import org.joml.Quaternionf;

import java.util.function.Consumer;
import net.minecraft.class_1767;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public class ValveHandleVisual extends KineticBlockEntityVisual<ValveHandleBlockEntity> implements SimpleDynamicVisual {
    private final TransformedInstance crank;

    public ValveHandleVisual(VisualizationContext modelManager, ValveHandleBlockEntity blockEntity, float partialTick) {
        super(modelManager, blockEntity, partialTick);

        class_2680 state = blockEntity.method_11010();
        class_1767 color = null;
        if (state != null && state.method_26204() instanceof ValveHandleBlock vhb)
            color = vhb.color;

        crank = instancerProvider().instancer(
            InstanceTypes.TRANSFORMED,
            Models.partial(color == null ? AllPartialModels.VALVE_HANDLE : AllPartialModels.DYED_VALVE_HANDLES.get(color))
        ).createInstance();

        rotateCrank(partialTick);
    }

    @Override
    public void beginFrame(Context ctx) {
        rotateCrank(ctx.partialTick());
    }

    private void rotateCrank(float pt) {
        var facing = blockState.method_11654(class_2741.field_12525);
        float angle = ValveHandleRenderer.getValveHandleIndependentAngle(blockEntity, pt);

        crank.setIdentityTransform().translate(getVisualPosition()).center()
            .rotate(angle, class_2350.method_10156(class_2350.class_2352.field_11056, facing.method_10166()))
            .rotate(new Quaternionf().rotateTo(0, 1, 0, facing.method_10148(), facing.method_10164(), facing.method_10165())).uncenter().setChanged();
    }

    @Override
    protected void _delete() {
        crank.delete();
    }

    @Override
    public void updateLight(float partialTick) {
        relight(crank);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(crank);
    }
}
