package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.DepotBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class DepotRenderer extends SafeBlockEntityRenderer<DepotBlockEntity> {

    public DepotRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(DepotBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        renderItemsOf(be, partialTicks, ms, buffer, light, overlay, be.depotBehaviour);
    }

    public static void renderItemsOf(
        SmartBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay,
        DepotBehaviour depotBehaviour
    ) {

        TransportedItemStack transported = depotBehaviour.heldItem;
        var msr = TransformStack.of(ms);
        class_243 itemPosition = VecHelper.getCenterOf(be.method_11016());

        ms.method_22903();
        ms.method_46416(.5f, 15 / 16f, .5f);

        boolean hasTransported = transported != null && !transported.stack.method_7960();
        if (hasTransported)
            depotBehaviour.incoming.add(transported);

        // Render main items
        for (TransportedItemStack tis : depotBehaviour.incoming) {
            ms.method_22903();
            msr.nudge(0);
            float offset = class_3532.method_16439(partialTicks, tis.prevBeltPosition, tis.beltPosition);
            float sideOffset = class_3532.method_16439(partialTicks, tis.prevSideOffset, tis.sideOffset);

            if (tis.insertedFrom.method_10166().method_10179()) {
                class_243 offsetVec = class_243.method_24954(tis.insertedFrom.method_10153().method_62675()).method_1021(.5f - offset);
                ms.method_22904(offsetVec.field_1352, offsetVec.field_1351, offsetVec.field_1350);
                boolean alongX = tis.insertedFrom.method_10170().method_10166() == class_2350.class_2351.field_11048;
                if (!alongX)
                    sideOffset *= -1;
                ms.method_46416(alongX ? sideOffset : 0, 0, alongX ? 0 : sideOffset);
            }

            class_1799 itemStack = tis.stack;
            int angle = tis.angle;
            Random r = new Random(0);
            renderItem(ms, buffer, light, overlay, itemStack, angle, r, itemPosition, false, null);
            ms.method_22909();
        }

        if (hasTransported)
            depotBehaviour.incoming.remove(transported);

        // Render output items
        for (int i = 0; i < depotBehaviour.processingOutputBuffer.method_5439(); i++) {
            class_1799 stack = depotBehaviour.processingOutputBuffer.method_5438(i);
            if (stack.method_7960())
                continue;
            ms.method_22903();
            msr.nudge(i);

            boolean renderUpright = BeltHelper.isItemUpright(stack);
            msr.rotateYDegrees(360 / 8f * i);
            ms.method_46416(.35f, 0, 0);
            if (renderUpright)
                msr.rotateYDegrees(-(360 / 8f * i));
            Random r = new Random(i + 1);
            int angle = (int) (360 * r.nextFloat());
            renderItem(ms, buffer, light, overlay, stack, renderUpright ? angle + 90 : angle, r, itemPosition, false, null);
            ms.method_22909();
        }

        ms.method_22909();
    }

    public static void renderItem(
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay,
        class_1799 itemStack,
        int angle,
        Random r,
        class_243 itemPosition,
        boolean alwaysUpright,
        BiConsumer<PoseTransformStack, Boolean> transform
    ) {
        class_918 itemRenderer = class_310.method_1551().method_1480();
        itemRenderer.field_55296.method_65598(itemRenderer.field_55297, itemStack, class_811.field_4319, null, null, 0);
        boolean blockItem = itemRenderer.field_55297.method_65608();
        var msr = TransformStack.of(ms);
        if (transform != null) {
            transform.accept(msr, blockItem);
        }
        int count = class_3532.method_15351(itemStack.method_7947()) / 2;
        boolean renderUpright = BeltHelper.isItemUpright(itemStack) || alwaysUpright && !blockItem;

        ms.method_22903();
        msr.rotateYDegrees(angle);

        if (renderUpright) {
            class_1297 renderViewEntity = class_310.method_1551().field_1719;
            if (renderViewEntity != null) {
                class_243 positionVec = renderViewEntity.method_19538();
                class_243 vectorForOffset = itemPosition;
                class_243 diff = vectorForOffset.method_1020(positionVec);
                float yRot = (float) (class_3532.method_15349(diff.field_1352, diff.field_1350) + Math.PI);
                ms.method_22907(class_7833.field_40716.rotation(yRot));
            }
            ms.method_22904(0, 3 / 32d, -1 / 16f);
        }

        for (int i = 0; i <= count; i++) {
            ms.method_22903();
            if (blockItem && r != null)
                ms.method_46416(r.nextFloat() * .0625f * i, 0, r.nextFloat() * .0625f * i);

            if (PackageItem.isPackage(itemStack) && !alwaysUpright) {
                ms.method_46416(0, 4 / 16f, 0);
                ms.method_22905(1.5f, 1.5f, 1.5f);
            } else if (blockItem && alwaysUpright) {
                ms.method_46416(0, 1 / 16f, 0);
                ms.method_22905(.755f, .755f, .755f);
            } else
                ms.method_22905(.5f, .5f, .5f);

            if (!blockItem && !renderUpright) {
                ms.method_46416(0, -3 / 16f, 0);
                msr.rotateXDegrees(90);
            }
            itemRenderer.field_55297.method_65604(ms, buffer, light, overlay);
            ms.method_22909();

            if (!renderUpright) {
                if (!blockItem)
                    msr.rotateYDegrees(10);
                ms.method_22904(0, blockItem ? 1 / 64d : 1 / 16d, 0);
            } else
                ms.method_46416(0, 0, -1 / 16f);
        }

        ms.method_22909();
    }

}
