package com.zurrtum.create.client.content.logistics.packagePort.frogport;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7923;

public class FrogportRenderer extends SmartBlockEntityRenderer<FrogportBlockEntity> {

    public FrogportRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        FrogportBlockEntity blockEntity,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        SuperByteBuffer body = CachedBuffers.partial(AllPartialModels.FROGPORT_BODY, blockEntity.method_11010());

        float yaw = blockEntity.getYaw();

        float headPitch = 80;
        float tonguePitch = 0;
        float tongueLength = 0;
        float headPitchModifier = 1;

        boolean hasTarget = blockEntity.target != null;
        boolean animating = blockEntity.isAnimationInProgress();
        boolean depositing = blockEntity.currentlyDepositing;

        class_243 diff = class_243.field_1353;

        if (blockEntity.addressFilter != null && !blockEntity.addressFilter.isBlank()) {
            renderNameplateOnHover(blockEntity, class_2561.method_43470(blockEntity.addressFilter), 1, ms, buffer, light);
        }

        if (VisualizationManager.supportsVisualization(blockEntity.method_10997())) {
            return;
        }

        if (hasTarget) {
            diff = blockEntity.target.getExactTargetLocation(blockEntity, blockEntity.method_10997(), blockEntity.method_11016())
                .method_1023(0, animating && depositing ? 0 : 0.75, 0).method_1020(class_243.method_24953(blockEntity.method_11016()));
            tonguePitch = (float) class_3532.method_15349(diff.field_1351, diff.method_18805(1, 0, 1).method_1033() + (3 / 16f)) * class_3532.field_29848;
            tongueLength = Math.max((float) diff.method_1033(), 1);
            headPitch = class_3532.method_15363(tonguePitch * 2, 60, 100);
        }

        if (animating) {
            float progress = blockEntity.animationProgress.getValue(partialTicks);
            float scale = 1;
            float itemDistance = 0;

            if (depositing) {
                double modifier = Math.max(0, 1 - Math.pow((progress - 0.25) * 4 - 1, 4));
                itemDistance = (float) Math.max(tongueLength * Math.min(1, (progress - 0.25) * 3), tongueLength * modifier);
                tongueLength *= Math.max(0, 1 - Math.pow((progress * 1.25 - 0.25) * 4 - 1, 4));
                headPitchModifier = (float) Math.max(0, 1 - Math.pow((progress * 1.25) * 2 - 1, 4));
                scale = 0.25f + progress * 3 / 4;

            } else {
                tongueLength *= Math.pow(Math.max(0, 1 - progress * 1.25), 5);
                headPitchModifier = 1 - (float) Math.min(1, Math.max(0, (Math.pow(progress * 1.5, 2) - 0.5) * 2));
                scale = (float) Math.max(0.5, 1 - progress * 1.25);
                itemDistance = tongueLength;
            }

            renderPackage(blockEntity, ms, buffer, light, overlay, diff, scale, itemDistance);

        } else {
            tongueLength = 0;
            float anticipation = blockEntity.anticipationProgress.getValue(partialTicks);
            headPitchModifier = anticipation > 0 ? (float) Math.max(0, 1 - Math.pow((anticipation * 1.25) * 2 - 1, 4)) : 0;
        }

        headPitch *= headPitchModifier;

        headPitch = Math.max(headPitch, blockEntity.manualOpenAnimationProgress.getValue(partialTicks) * 60);
        tongueLength = Math.max(tongueLength, blockEntity.manualOpenAnimationProgress.getValue(partialTicks) * 0.25f);


        class_1921 cutoutMipped = class_1921.method_23579();
        body.center().rotateYDegrees(yaw).uncenter().light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(cutoutMipped));

        SuperByteBuffer head = CachedBuffers.partial(
            blockEntity.goggles ? AllPartialModels.FROGPORT_HEAD_GOGGLES : AllPartialModels.FROGPORT_HEAD,
            blockEntity.method_11010()
        );

        head.center().rotateYDegrees(yaw).uncenter().translate(8 / 16f, 10 / 16f, 11 / 16f).rotateXDegrees(headPitch)
            .translateBack(8 / 16f, 10 / 16f, 11 / 16f);

        head.light(light)
            //			.color(color)
            .overlay(overlay).renderInto(ms, buffer.getBuffer(cutoutMipped));

        SuperByteBuffer tongue = CachedBuffers.partial(AllPartialModels.FROGPORT_TONGUE, blockEntity.method_11010());

        tongue.center().rotateYDegrees(yaw).uncenter().translate(8 / 16f, 10 / 16f, 11 / 16f).rotateXDegrees(tonguePitch)
            .scale(1f, 1f, tongueLength / (7 / 16f)).translateBack(8 / 16f, 10 / 16f, 11 / 16f);

        tongue.light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(cutoutMipped));

        // hat

        //		SuperByteBuffer hatBuffer = CachedBuffers.partial(AllPartialModels.TRAIN_HAT, blockEntity.getBlockState());
        //		hatBuffer
        //			.translate(8 / 16f, 14 / 16f, 8 / 16f)
        //			.rotateYDegrees(yaw + 180)
        //			.translate(0, 0, -3 / 16f)
        //			.rotateX(-4)
        //			.translateBack(0, 0, -3 / 16f)
        //			.translate(0, 0, 1 / 16f)
        //			.light(light)
        //			.color(color)
        //			.overlay(overlay)
        //			.renderInto(ms, buffer.getBuffer(RenderType.solid()));

    }

    private void renderPackage(
        FrogportBlockEntity blockEntity,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay,
        class_243 diff,
        float scale,
        float itemDistance
    ) {
        if (blockEntity.animatedPackage == null)
            return;
        if (scale < 0.45)
            return;
        class_2960 key = class_7923.field_41178.method_10221(blockEntity.animatedPackage.method_7909());
        if (key == class_7923.field_41178.method_10137())
            return;
        SuperByteBuffer rigBuffer = CachedBuffers.partial(AllPartialModels.PACKAGE_RIGGING.get(key), blockEntity.method_11010());
        SuperByteBuffer boxBuffer = CachedBuffers.partial(AllPartialModels.PACKAGES.get(key), blockEntity.method_11010());

        boolean animating = blockEntity.isAnimationInProgress();
        boolean depositing = blockEntity.currentlyDepositing;

        for (SuperByteBuffer buf : new SuperByteBuffer[]{boxBuffer, rigBuffer}) {
            buf.translate(0, 3 / 16f, 0).translate(diff.method_1029().method_1021(itemDistance).method_1023(0, animating && depositing ? 0.75 : 0, 0))
                .center().scale(scale).uncenter().light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(class_1921.method_23581()));
            if (!blockEntity.currentlyDepositing)
                break;
        }
    }

}
