package com.zurrtum.create.client.content.logistics.packagePort.postbox;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.transform.Transform;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlock;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;

public class PostboxRenderer extends SmartBlockEntityRenderer<PostboxBlockEntity> {

    public PostboxRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        PostboxBlockEntity blockEntity,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {

        if (blockEntity.addressFilter != null && !blockEntity.addressFilter.isBlank()) {
            renderNameplateOnHover(blockEntity, class_2561.method_43470(blockEntity.addressFilter), 1, ms, buffer, light);
        }

        SuperByteBuffer sbb = CachedBuffers.partial(AllPartialModels.POSTBOX_FLAG, blockEntity.method_11010());

        sbb.light(light).overlay(overlay)
            .rotateCentered(
                class_3532.field_29847 * (180 - blockEntity.method_11010().method_11654(PostboxBlock.field_11177).method_10144()),
                class_7833.field_40716
            );

        transformFlag(sbb, blockEntity, partialTicks);

        sbb.renderInto(ms, buffer.getBuffer(class_1921.method_23581()));
    }

    public static void transformFlag(Transform<?> flag, PostboxBlockEntity be, float partialTicks) {
        float value = be.flag.getValue(partialTicks);
        float progress = (float) (Math.pow(Math.min(value * 5, 1), 2));
        if (be.flag.getChaseTarget() > 0 && !be.flag.settled() && progress == 1) {
            float wiggleProgress = (value - .2f) / .8f;
            progress += (Math.sin(wiggleProgress * (2 * class_3532.field_29844) * 4) / 8f) / Math.max(1, 8f * wiggleProgress);
        }
        flag.translate(0, 10 / 16f, 2 / 16f);
        flag.rotateXDegrees(-progress * 90);
        flag.translateBack(0, 10 / 16f, 2 / 16f);
    }

}
