package com.zurrtum.create.client.content.logistics.tunnel;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.FlapStuffs;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class BeltTunnelRenderer extends SmartBlockEntityRenderer<BeltTunnelBlockEntity> {

    public BeltTunnelRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(BeltTunnelBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        SuperByteBuffer flapBuffer = CachedBuffers.partial(AllPartialModels.BELT_TUNNEL_FLAP, be.method_11010());
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());

        for (class_2350 direction : Iterate.directions) {
            if (!be.flaps.containsKey(direction))
                continue;

            float f = be.flaps.get(direction).getValue(partialTicks);

            FlapStuffs.renderFlaps(ms, vb, flapBuffer, FlapStuffs.TUNNEL_PIVOT, direction, f, 0, light);
        }

    }

}
