package com.zurrtum.create.client.content.redstone.nixieTube;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.redstone.nixieTube.DoubleFaceAttachedBlock.DoubleAttachFace;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_382;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4597.class_4598;
import net.minecraft.class_5614;
import net.minecraft.class_765;

public class NixieTubeRenderer extends SafeBlockEntityRenderer<NixieTubeBlockEntity> {
    public NixieTubeRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(NixieTubeBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        ms.method_22903();
        class_2680 blockState = be.method_11010();
        DoubleAttachFace face = blockState.method_11654(NixieTubeBlock.FACE);
        float yRot = AngleHelper.horizontalAngle(blockState.method_11654(NixieTubeBlock.field_11177)) - 90 + (face == DoubleAttachFace.WALL_REVERSED ? 180 : 0);
        float xRot = face == DoubleAttachFace.WALL ? -90 : face == DoubleAttachFace.WALL_REVERSED ? 90 : 0;

        var msr = TransformStack.of(ms);
        msr.center().rotateYDegrees(yRot).rotateZDegrees(xRot).uncenter();
        class_310 mc = class_310.method_1551();

        if (be.signalState != null) {
            renderAsSignal(mc, be, partialTicks, ms, buffer, light, overlay);
            ms.method_22909();
            return;
        }

        msr.center();

        float height = face == DoubleAttachFace.CEILING ? 5 : 3;
        float scale = 1 / 20f;

        Couple<String> s = be.getDisplayedStrings();
        class_1767 color = NixieTubeBlock.colorOf(be.method_11010());

        ms.method_22903();
        ms.method_46416(-4 / 16f, 0, 0);
        ms.method_22905(scale, -scale, scale);
        drawTube(mc, ms, buffer, s.getFirst(), height, color);
        ms.method_22909();

        ms.method_22903();
        ms.method_46416(4 / 16f, 0, 0);
        ms.method_22905(scale, -scale, scale);
        drawTube(mc, ms, buffer, s.getSecond(), height, color);
        ms.method_22909();

        ms.method_22909();
    }

    public static void drawTube(class_310 mc, class_4587 ms, class_4597 buffer, String c, float height, class_1767 color) {
        class_327 fontRenderer = mc.field_1772;
        float charWidth = fontRenderer.method_1727(c);
        float shadowOffset = .5f;
        float flicker = mc.field_1687.field_9229.method_43057();
        Couple<Integer> couple = DyeHelper.getDyeColors(color);
        int brightColor = couple.getFirst() | 0xFF000000;
        int darkColor = couple.getSecond() | 0xFF000000;
        int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4);

        ms.method_22903();
        ms.method_46416((charWidth - shadowOffset) / -2f, -height, 0);
        drawInWorldString(fontRenderer, ms, buffer, c, flickeringBrightColor);
        ms.method_22903();
        ms.method_46416(shadowOffset, shadowOffset, -1 / 16f);
        drawInWorldString(fontRenderer, ms, buffer, c, darkColor);
        ms.method_22909();
        ms.method_22909();

        ms.method_22903();
        ms.method_22905(-1, 1, 1);
        ms.method_46416((charWidth - shadowOffset) / -2f, -height, 0);
        drawInWorldString(fontRenderer, ms, buffer, c, darkColor);
        ms.method_22903();
        ms.method_46416(-shadowOffset, shadowOffset, -1 / 16f);
        drawInWorldString(fontRenderer, ms, buffer, c, Color.mixColors(darkColor, 0, .35f));
        ms.method_22909();
        ms.method_22909();
    }

    public static void drawInWorldString(class_327 fontRenderer, class_4587 ms, class_4597 buffer, String c, int color) {
        fontRenderer.method_27521(
            c,
            0,
            0,
            color,
            false,
            ms.method_23760().method_23761(),
            buffer,
            class_327.class_6415.field_33993,
            0,
            class_765.field_32767
        );
        if (buffer instanceof class_4598 immediate) {
            class_382 texturedglyph = fontRenderer.method_27526(class_2583.field_24359).method_22943();
            immediate.method_22994(texturedglyph.method_24045(class_327.class_6415.field_33993));
        }
    }

    private void renderAsSignal(
        class_310 mc,
        NixieTubeBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        class_2680 blockState = be.method_11010();
        class_2350 facing = NixieTubeBlock.getFacing(blockState);
        class_243 observerVec = mc.field_1719.method_5836(partialTicks);
        var msr = TransformStack.of(ms);

        if (facing == class_2350.field_11033)
            msr.center().rotateZDegrees(180).uncenter();

        boolean invertTubes = facing == class_2350.field_11033 || blockState.method_11654(NixieTubeBlock.FACE) == DoubleAttachFace.WALL_REVERSED;

        CachedBuffers.partial(AllPartialModels.SIGNAL_PANEL, blockState).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));

        ms.method_22903();
        ms.method_46416(1 / 2f, 7.5f / 16f, 1 / 2f);
        float renderTime = AnimationTickHolder.getRenderTime(be.method_10997());

        for (boolean first : Iterate.trueAndFalse) {
            class_243 lampVec = class_243.method_24953(be.method_11016());
            class_243 diff = lampVec.method_1020(observerVec);

            if (first && !be.signalState.isRedLight(renderTime))
                continue;
            if (!first && !be.signalState.isGreenLight(renderTime) && !be.signalState.isYellowLight(renderTime))
                continue;

            boolean flip = first == invertTubes;
            boolean yellow = be.signalState.isYellowLight(renderTime);

            ms.method_22903();
            ms.method_46416(flip ? 4 / 16f : -4 / 16f, 0, 0);

            if (diff.method_1027() < 96 * 96) {
                boolean vert = first ^ facing.method_10166().method_10179();
                float longSide = yellow ? 1 : 4;
                float longSideGlow = yellow ? 2 : 5.125f;

                CachedBuffers.partial(AllPartialModels.SIGNAL_WHITE_CUBE, blockState).light(0xf000f0).disableDiffuse()
                    .scale(vert ? longSide : 1, vert ? 1 : longSide, 1).renderInto(ms, buffer.getBuffer(PonderRenderTypes.translucent()));

                CachedBuffers.partial(
                        first ? AllPartialModels.SIGNAL_RED_GLOW : yellow ? AllPartialModels.SIGNAL_YELLOW_GLOW : AllPartialModels.SIGNAL_WHITE_GLOW,
                        blockState
                    ).light(0xf000f0).disableDiffuse().scale(vert ? longSideGlow : 2, vert ? 2 : longSideGlow, 2)
                    .renderInto(ms, buffer.getBuffer(RenderTypes.additive()));
            }

            CachedBuffers.partial(
                first ? AllPartialModels.SIGNAL_RED : yellow ? AllPartialModels.SIGNAL_YELLOW : AllPartialModels.SIGNAL_WHITE,
                blockState
            ).light(0xF000F0).disableDiffuse().scale(1 + 1 / 16f).renderInto(ms, buffer.getBuffer(RenderTypes.additive()));

            ms.method_22909();
        }
        ms.method_22909();

    }

    @Override
    public int method_33893() {
        return 128;
    }

}
