package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.client.foundation.utility.RaycastHelper.PredicateTraceResult;
import com.zurrtum.create.content.schematics.SchematicExport;
import com.zurrtum.create.content.schematics.SchematicExport.SchematicExportResult;
import com.zurrtum.create.foundation.utility.CreatePaths;
import com.zurrtum.create.infrastructure.packet.c2s.InstantSchematicPacket;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.util.math.*;
import org.lwjgl.glfw.GLFW;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class SchematicAndQuillHandler {

    private final Object outlineSlot = new Object();

    public class_2338 firstPos;
    public class_2338 secondPos;
    private class_2338 selectedPos;
    private class_2350 selectedFace;
    private int range = 10;

    public boolean mouseScrolled(class_310 mc, double delta) {
        if (!isActive(mc))
            return false;
        if (!class_437.method_25441())
            return false;
        if (secondPos == null)
            range = (int) class_3532.method_15350(range + delta, 1, 100);
        if (selectedFace == null)
            return true;

        class_238 bb = new class_238(class_243.method_24954(firstPos), class_243.method_24954(secondPos));
        class_2382 vec = selectedFace.method_62675();
        class_243 projectedView = mc.field_1773.method_19418().method_19326();
        if (bb.method_1006(projectedView))
            delta *= -1;

        // Round away from zero to avoid an implicit floor
        int intDelta = (int) (delta > 0 ? Math.ceil(delta) : Math.floor(delta));

        int x = vec.method_10263() * intDelta;
        int y = vec.method_10264() * intDelta;
        int z = vec.method_10260() * intDelta;

        class_2352 axisDirection = selectedFace.method_10171();
        if (axisDirection == class_2352.field_11060)
            bb = bb.method_989(-x, -y, -z);

        double maxX = Math.max(bb.field_1320 - x * axisDirection.method_10181(), bb.field_1323);
        double maxY = Math.max(bb.field_1325 - y * axisDirection.method_10181(), bb.field_1322);
        double maxZ = Math.max(bb.field_1324 - z * axisDirection.method_10181(), bb.field_1321);
        bb = new class_238(bb.field_1323, bb.field_1322, bb.field_1321, maxX, maxY, maxZ);

        firstPos = class_2338.method_49637(bb.field_1323, bb.field_1322, bb.field_1321);
        secondPos = class_2338.method_49637(bb.field_1320, bb.field_1325, bb.field_1324);
        class_746 player = mc.field_1724;
        CreateLang.translate("schematicAndQuill.dimensions", (int) bb.method_17939() + 1, (int) bb.method_17940() + 1, (int) bb.method_17941() + 1)
            .sendStatus(player);

        return true;
    }

    public boolean onMouseInput(class_310 mc, int button) {
        if (button != 1)
            return false;
        if (!isActive(mc))
            return false;

        class_746 player = mc.field_1724;

        if (player.method_5715()) {
            discard(mc);
            return true;
        }

        if (secondPos != null) {
            ScreenOpener.open(new SchematicPromptScreen());
            return true;
        }

        if (selectedPos == null) {
            CreateLang.translate("schematicAndQuill.noTarget").sendStatus(player);
            return true;
        }

        if (firstPos != null) {
            secondPos = selectedPos;
            CreateLang.translate("schematicAndQuill.secondPos").sendStatus(player);
            return true;
        }

        firstPos = selectedPos;
        CreateLang.translate("schematicAndQuill.firstPos").sendStatus(player);
        return true;
    }

    public void discard(class_310 mc) {
        firstPos = null;
        secondPos = null;
        CreateLang.translate("schematicAndQuill.abort").sendStatus(mc.field_1724);
    }

    public void tick(class_310 mc) {
        if (!isActive(mc))
            return;

        class_746 player = mc.field_1724;
        if (class_3675.method_15987(mc.method_22683().method_4490(), GLFW.GLFW_KEY_LEFT_CONTROL)) {
            float pt = AnimationTickHolder.getPartialTicks();
            class_243 targetVec = player.method_5836(pt).method_1019(player.method_5720().method_1021(range));
            selectedPos = class_2338.method_49638(targetVec);

        } else {
            class_3965 trace = RaycastHelper.rayTraceRange(player.method_37908(), player, 75);
            if (trace != null && trace.method_17783() == class_240.field_1332) {

                class_2338 hit = trace.method_17777();
                boolean replaceable = player.method_37908().method_8320(hit)
                    .method_26166(new class_1750(new class_1838(player, class_1268.field_5808, trace)));
                if (trace.method_17780().method_10166().method_10178() && !replaceable)
                    hit = hit.method_10093(trace.method_17780());
                selectedPos = hit;
            } else
                selectedPos = null;
        }

        selectedFace = null;
        if (secondPos != null) {
            class_238 bb = new class_238(class_243.method_24954(firstPos), class_243.method_24954(secondPos)).method_1012(1, 1, 1).method_1014(.45f);
            class_243 projectedView = mc.field_1773.method_19418().method_19326();
            boolean inside = bb.method_1006(projectedView);
            PredicateTraceResult result = RaycastHelper.rayTraceUntil(player, 70, pos -> inside ^ bb.method_1006(VecHelper.getCenterOf(pos)));
            selectedFace = result.missed() ? null : inside ? result.getFacing().method_10153() : result.getFacing();
        }

        class_238 currentSelectionBox = getCurrentSelectionBox();
        if (currentSelectionBox != null)
            outliner().chaseAABB(outlineSlot, currentSelectionBox).colored(0x6886c5)
                .withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(1 / 16f)
                .highlightFace(selectedFace);
    }

    private class_238 getCurrentSelectionBox() {
        if (secondPos == null) {
            if (firstPos == null)
                return selectedPos == null ? null : new class_238(selectedPos);
            return selectedPos == null ? new class_238(firstPos) : new class_238(class_243.method_24954(firstPos), class_243.method_24954(selectedPos)).method_1012(1, 1, 1);
        }
        return new class_238(class_243.method_24954(firstPos), class_243.method_24954(secondPos)).method_1012(1, 1, 1);
    }

    private boolean isActive(class_310 mc) {
        return mc != null && mc.field_1687 != null && mc.field_1755 == null && mc.field_1724.method_6047().method_31574(AllItems.SCHEMATIC_AND_QUILL);
    }

    public void saveSchematic(class_310 mc, String string, boolean convertImmediately) {
        SchematicExportResult result = SchematicExport.saveSchematic(CreatePaths.SCHEMATICS_DIR, string, false, mc.field_1687, firstPos, secondPos);
        class_746 player = mc.field_1724;
        if (result == null) {
            CreateLang.translate("schematicAndQuill.failed").style(class_124.field_1061).sendStatus(player);
            return;
        }
        Path file = result.file();
        CreateLang.translate("schematicAndQuill.saved", file.getFileName().toString()).sendStatus(player);
        firstPos = null;
        secondPos = null;
        if (!convertImmediately)
            return;
        try {
            if (!ClientSchematicLoader.validateSizeLimitation(mc, Files.size(file)))
                return;
            player.field_3944.method_52787(new InstantSchematicPacket(result.fileName(), result.origin(), result.bounds()));
        } catch (IOException e) {
            Create.LOGGER.error("Error instantly uploading Schematic file: " + file, e);
        }
    }

    private Outliner outliner() {
        return Outliner.getInstance();
    }

}
