package com.zurrtum.create.client.content.trains.schedule;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.gui.ScreenWithStencils;
import com.zurrtum.create.content.trains.schedule.ScheduleDataEntry;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4597;

public interface IScheduleInput<T extends ScheduleDataEntry> {

    Pair<class_1799, class_2561> getSummary(T input);

    default int slotsTargeted() {
        return 0;
    }

    default List<class_2561> getTitleAs(T input, String type) {
        class_2960 id = input.getId();
        return ImmutableList.of(class_2561.method_43471(id.method_12836() + ".schedule." + type + "." + id.method_12832()));
    }

    default class_1799 getSecondLineIcon() {
        return class_1799.field_8037;
    }

    default void setItem(T input, int slot, class_1799 stack) {
    }

    default class_1799 getItem(T input, int slot) {
        return class_1799.field_8037;
    }

    @Nullable
    default List<class_2561> getSecondLineTooltip(int slot) {
        return null;
    }

    default void initConfigurationWidgets(T input, ModularGuiLineBuilder builder) {
    }

    default boolean renderSpecialIcon(T input, class_332 graphics, int x, int y) {
        return false;
    }

    default boolean renderStencilSpecialIcon(
        T input,
        class_332 graphics,
        class_4597.class_4598 vertexConsumers,
        ScreenWithStencils screen,
        int x,
        int y
    ) {
        return false;
    }

}
