package com.zurrtum.create.client.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.gui.ScreenWithStencils;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.schedule.condition.TimeOfDayCondition;
import org.apache.commons.lang3.mutable.MutableObject;

import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;

public class TimeOfDayConditionRender implements IScheduleInput<TimeOfDayCondition> {
    @Override
    public Pair<class_1799, class_2561> getSummary(TimeOfDayCondition input) {
        return Pair.of(new class_1799(class_1802.field_8615), input.getDigitalDisplay(input.intData("Hour"), input.intData("Minute"), false));
    }

    @Override
    public List<class_2561> getTitleAs(TimeOfDayCondition input, String type) {
        return ImmutableList.of(
            CreateLang.translateDirect("schedule.condition.time_of_day.scheduled"),
            input.getDigitalDisplay(input.intData("Hour"), input.intData("Minute"), false).method_27692(class_124.field_1062)
                .method_10852(class_2561.method_43470(" -> ").method_27692(class_124.field_1063)).method_10852(CreateLang.translatedOptions(
                    "schedule.condition.time_of_day.rotation",
                    "every_24",
                    "every_12",
                    "every_6",
                    "every_4",
                    "every_3",
                    "every_2",
                    "every_1",
                    "every_0_45",
                    "every_0_30",
                    "every_0_15"
                ).get(input.intData("Rotation")).method_27661().method_27692(class_124.field_1080))
        );
    }

    public String twoDigits(int t) {
        return t < 10 ? "0" + t : "" + t;
    }

    private class_2960 getClockTextureId(TimeOfDayCondition input) {
        int displayHr = (input.intData("Hour") + 12) % 24;
        float progress = (displayHr * 60f + input.intData("Minute")) / (24 * 60);
        return class_2960.method_60656("textures/item/clock_" + twoDigits(class_3532.method_15340((int) (progress * 64), 0, 63)) + ".png");
    }

    @Override
    public boolean renderSpecialIcon(TimeOfDayCondition input, class_332 graphics, int x, int y) {
        graphics.method_25290(class_10799.field_56883, getClockTextureId(input), x, y, 0, 0, 16, 16, 16, 16);
        return true;
    }

    @Override
    public boolean renderStencilSpecialIcon(
        TimeOfDayCondition input,
        class_332 graphics,
        class_4597.class_4598 vertexConsumers,
        ScreenWithStencils screen,
        int x,
        int y
    ) {
        screen.drawTexture(vertexConsumers, graphics.method_51448(), getClockTextureId(input), x, y, 100, 0, 0, 16, 16, 16, 16);
        return true;
    }

    @Override
    public void initConfigurationWidgets(TimeOfDayCondition input, ModularGuiLineBuilder builder) {
        MutableObject<ScrollInput> minuteInput = new MutableObject<>();
        MutableObject<ScrollInput> hourInput = new MutableObject<>();
        MutableObject<Label> timeLabel = new MutableObject<>();

        builder.addScrollInput(
            0, 16, (i, l) -> {
                i.withRange(0, 24);
                timeLabel.setValue(l);
                hourInput.setValue(i);
            }, "Hour"
        );

        builder.addScrollInput(
            18, 16, (i, l) -> {
                i.withRange(0, 60);
                minuteInput.setValue(i);
                l.field_22764 = false;
            }, "Minute"
        );

        builder.addSelectionScrollInput(
            52, 62, (i, l) -> {
                i.forOptions(CreateLang.translatedOptions(
                    "schedule.condition.time_of_day.rotation",
                    "every_24",
                    "every_12",
                    "every_6",
                    "every_4",
                    "every_3",
                    "every_2",
                    "every_1",
                    "every_0_45",
                    "every_0_30",
                    "every_0_15"
                )).titled(CreateLang.translateDirect("schedule.condition.time_of_day.rotation"));
            }, "Rotation"
        );

        class_2487 data = input.getData();
        hourInput.getValue().titled(CreateLang.translateDirect("generic.daytime.hour")).calling(t -> {
            data.method_10569("Hour", t);
            timeLabel.getValue().text = input.getDigitalDisplay(t, minuteInput.getValue().getState(), true);
        }).writingTo(null).withShiftStep(6);

        minuteInput.getValue().titled(CreateLang.translateDirect("generic.daytime.minute")).calling(t -> {
            data.method_10569("Minute", t);
            timeLabel.getValue().text = input.getDigitalDisplay(hourInput.getValue().getState(), t, true);
        }).writingTo(null).withShiftStep(15);

        minuteInput.getValue().lockedTooltipX = hourInput.getValue().lockedTooltipX = -15;
        minuteInput.getValue().lockedTooltipY = hourInput.getValue().lockedTooltipY = 35;

        hourInput.getValue().setState(input.intData("Hour"));
        minuteInput.getValue().setState(input.intData("Minute")).onChanged();

        builder.customArea(0, 52);
        builder.customArea(52, 69);
    }
}
