package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackMaterialModels.TrackModelHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4587.class_4665;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;

public class TrackRenderer extends SafeBlockEntityRenderer<TrackBlockEntity> {

    public TrackRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(TrackBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_1937 level = be.method_10997();
        if (VisualizationManager.supportsVisualization(level))
            return;
        class_4588 vb = buffer.getBuffer(class_1921.method_23579());
        be.getConnections().values().forEach(bc -> renderBezierTurn(level, bc, ms, vb));
    }

    public static void renderBezierTurn(class_1937 level, BezierConnection bc, class_4587 ms, class_4588 vb) {
        if (!bc.isPrimary())
            return;

        ms.method_22903();
        class_2338 bePosition = bc.bePositions.getFirst();
        class_2680 air = class_2246.field_10124.method_9564();
        SegmentAngles segment = bc.getBakedSegments(SegmentAngles::new);

        renderGirder(level, bc, ms, vb, bePosition);

        for (int i = 1; i < segment.length; i++) {
            int light = class_761.method_23794(level, segment.lightPosition[i].method_10081(bePosition));

            TrackModelHolder modelHolder = bc.getMaterial().getModelHolder();

            CachedBuffers.partial(modelHolder.tie(), air).mulPose(segment.tieTransform[i].method_23761())
                .mulNormal(segment.tieTransform[i].method_23762()).light(light).renderInto(ms, vb);

            for (boolean first : Iterate.trueAndFalse) {
                class_4665 transform = segment.railTransforms[i].get(first);
                CachedBuffers.partial(first ? modelHolder.leftSegment() : modelHolder.rightSegment(), air).mulPose(transform.method_23761())
                    .mulNormal(transform.method_23762()).light(light).renderInto(ms, vb);
            }
        }

        ms.method_22909();
    }

    private static void renderGirder(class_1937 level, BezierConnection bc, class_4587 ms, class_4588 vb, class_2338 tePosition) {
        if (!bc.hasGirder)
            return;

        class_2680 air = class_2246.field_10124.method_9564();
        GirderAngles segment = bc.getBakedGirders(GirderAngles::new);

        for (int i = 1; i < segment.length; i++) {
            int light = class_761.method_23794(level, segment.lightPosition[i].method_10081(tePosition));

            for (boolean first : Iterate.trueAndFalse) {
                class_4665 beamTransform = segment.beams[i].get(first);
                CachedBuffers.partial(AllPartialModels.GIRDER_SEGMENT_MIDDLE, air).mulPose(beamTransform.method_23761())
                    .mulNormal(beamTransform.method_23762()).light(light).renderInto(ms, vb);

                for (boolean top : Iterate.trueAndFalse) {
                    class_4665 beamCapTransform = segment.beamCaps[i].get(top).get(first);
                    CachedBuffers.partial(top ? AllPartialModels.GIRDER_SEGMENT_TOP : AllPartialModels.GIRDER_SEGMENT_BOTTOM, air)
                        .mulPose(beamCapTransform.method_23761()).mulNormal(beamCapTransform.method_23762()).light(light).renderInto(ms, vb);
                }
            }
        }
    }

    public static class_243 getModelAngles(class_243 normal, class_243 diff) {
        double diffX = diff.method_10216();
        double diffY = diff.method_10214();
        double diffZ = diff.method_10215();
        double len = class_3532.method_15355((float) (diffX * diffX + diffZ * diffZ));
        double yaw = class_3532.method_15349(diffX, diffZ);
        double pitch = class_3532.method_15349(len, diffY) - Math.PI * .5;

        class_243 yawPitchNormal = VecHelper.rotate(VecHelper.rotate(new class_243(0, 1, 0), AngleHelper.deg(pitch), class_2351.field_11048), AngleHelper.deg(yaw), class_2351.field_11052);

        double signum = Math.signum(yawPitchNormal.method_1026(normal));
        if (Math.abs(signum) < 0.5f)
            signum = yawPitchNormal.method_1025(normal) < 0.5f ? -1 : 1;
        double dot = diff.method_1036(normal).method_1029().method_1026(yawPitchNormal);
        double roll = Math.acos(class_3532.method_15350(dot, -1, 1)) * signum;
        return new class_243(pitch, yaw, roll);
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    @Override
    public int method_33893() {
        return 96 * 2;
    }


    public static class SegmentAngles {
        public final int length;
        public final @NotNull class_4665[] tieTransform;
        public final @NotNull Couple<class_4665>[] railTransforms;
        public final @NotNull class_2338[] lightPosition;

        @SuppressWarnings("unchecked")
        SegmentAngles(BezierConnection bc) {
            int segmentCount = bc.getSegmentCount();

            length = segmentCount + 1;

            tieTransform = new class_4665[segmentCount + 1];
            railTransforms = new Couple[segmentCount + 1];
            lightPosition = new class_2338[segmentCount + 1];

            Couple<class_243> previousOffsets = null;

            for (BezierConnection.Segment segment : bc) {
                int i = segment.index;
                boolean end = i == 0 || i == segmentCount;

                Couple<class_243> railOffsets = Couple.create(
                    segment.position.method_1019(segment.normal.method_1021(.965f)),
                    segment.position.method_1020(segment.normal.method_1021(.965f))
                );
                class_243 railMiddle = railOffsets.getFirst().method_1019(railOffsets.getSecond()).method_1021(.5);

                if (previousOffsets == null) {
                    previousOffsets = railOffsets;
                    continue;
                }

                // Tie
                class_243 prevMiddle = previousOffsets.getFirst().method_1019(previousOffsets.getSecond()).method_1021(.5);
                class_243 tieAngles = TrackRenderer.getModelAngles(segment.normal, railMiddle.method_1020(prevMiddle));
                lightPosition[i] = class_2338.method_49638(railMiddle);
                railTransforms[i] = Couple.create(null, null);

                class_4587 poseStack = new class_4587();
                TransformStack.of(poseStack).translate(prevMiddle).rotateY((float) tieAngles.field_1351).rotateX((float) tieAngles.field_1352)
                    .rotateZ((float) tieAngles.field_1350).translate(-1 / 2f, -2 / 16f - 1 / 256f, 0);
                tieTransform[i] = poseStack.method_23760();

                // Rails
                float scale = end ? 2.2f : 2.1f;
                for (boolean first : Iterate.trueAndFalse) {
                    class_243 railI = railOffsets.get(first);
                    class_243 prevI = previousOffsets.get(first);
                    class_243 diff = railI.method_1020(prevI);
                    class_243 anglesI = TrackRenderer.getModelAngles(segment.normal, diff);

                    poseStack = new class_4587();
                    TransformStack.of(poseStack).translate(prevI).rotateY((float) anglesI.field_1351).rotateX((float) anglesI.field_1352).rotateZ((float) anglesI.field_1350)
                        .translate(0, -2 / 16f - 1 / 256f, -1 / 32f).scale(1, 1, (float) diff.method_1033() * scale);
                    railTransforms[i].set(first, poseStack.method_23760());
                }

                previousOffsets = railOffsets;
            }
        }

    }

    public static class GirderAngles {
        public final int length;
        public final Couple<class_4665>[] beams;
        public final Couple<Couple<class_4665>>[] beamCaps;
        public final class_2338[] lightPosition;

        @SuppressWarnings("unchecked")
        GirderAngles(BezierConnection bc) {
            int segmentCount = bc.getSegmentCount();
            length = segmentCount + 1;

            beams = new Couple[length];
            beamCaps = new Couple[length];
            lightPosition = new class_2338[length];

            Couple<Couple<class_243>> previousOffsets = null;

            for (BezierConnection.Segment segment : bc) {
                int i = segment.index;
                boolean end = i == 0 || i == segmentCount;
                class_243 leftGirder = segment.position.method_1019(segment.normal.method_1021(.965f));
                class_243 rightGirder = segment.position.method_1020(segment.normal.method_1021(.965f));
                class_243 upNormal = segment.derivative.method_1029().method_1036(segment.normal);
                class_243 firstGirderOffset = upNormal.method_1021(-8 / 16f);
                class_243 secondGirderOffset = upNormal.method_1021(-10 / 16f);
                class_243 leftTop = segment.position.method_1019(segment.normal.method_1021(1)).method_1019(firstGirderOffset);
                class_243 rightTop = segment.position.method_1020(segment.normal.method_1021(1)).method_1019(firstGirderOffset);
                class_243 leftBottom = leftTop.method_1019(secondGirderOffset);
                class_243 rightBottom = rightTop.method_1019(secondGirderOffset);

                lightPosition[i] = class_2338.method_49638(leftGirder.method_1019(rightGirder).method_1021(.5));

                Couple<Couple<class_243>> offsets = Couple.create(Couple.create(leftTop, rightTop), Couple.create(leftBottom, rightBottom));

                if (previousOffsets == null) {
                    previousOffsets = offsets;
                    continue;
                }

                beams[i] = Couple.create(null, null);
                beamCaps[i] = Couple.create(Couple.create(null, null), Couple.create(null, null));
                float scale = end ? 2.3f : 2.2f;

                for (boolean first : Iterate.trueAndFalse) {

                    // Middle
                    class_243 currentBeam = offsets.getFirst().get(first).method_1019(offsets.getSecond().get(first)).method_1021(.5);
                    class_243 previousBeam = previousOffsets.getFirst().get(first).method_1019(previousOffsets.getSecond().get(first)).method_1021(.5);
                    class_243 beamDiff = currentBeam.method_1020(previousBeam);
                    class_243 beamAngles = TrackRenderer.getModelAngles(segment.normal, beamDiff);

                    class_4587 poseStack = new class_4587();
                    TransformStack.of(poseStack).translate(previousBeam).rotateY((float) beamAngles.field_1351).rotateX((float) beamAngles.field_1352)
                        .rotateZ((float) beamAngles.field_1350).translate(0, 2 / 16f + (segment.index % 2 == 0 ? 1 : -1) / 2048f - 1 / 1024f, -1 / 32f)
                        .scale(1, 1, (float) beamDiff.method_1033() * scale);
                    beams[i].set(first, poseStack.method_23760());

                    // Caps
                    for (boolean top : Iterate.trueAndFalse) {
                        class_243 current = offsets.get(top).get(first);
                        class_243 previous = previousOffsets.get(top).get(first);
                        class_243 diff = current.method_1020(previous);
                        class_243 capAngles = TrackRenderer.getModelAngles(segment.normal, diff);

                        poseStack = new class_4587();
                        TransformStack.of(poseStack).translate(previous).rotateY((float) capAngles.field_1351).rotateX((float) capAngles.field_1352)
                            .rotateZ((float) capAngles.field_1350).translate(0, 2 / 16f + (segment.index % 2 == 0 ? 1 : -1) / 2048f - 1 / 1024f, -1 / 32f)
                            .rotateZ(0).scale(1, 1, (float) diff.method_1033() * scale);
                        beamCaps[i].get(top).set(first, poseStack.method_23760());
                    }
                }

                previousOffsets = offsets;

            }
        }

    }
}