package com.zurrtum.create.client.flywheel.api.backend;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import it.unimi.dsi.fastutil.longs.LongSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;

import java.util.List;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_4076;
import net.minecraft.class_4184;

@BackendImplemented
public interface Engine {
    VisualizationContext createVisualizationContext();

    Plan<RenderContext> createFramePlan();

    class_2382 renderOrigin();

    boolean updateRenderOrigin(class_4184 var1);

    void lightSections(LongSet var1);

    void onLightUpdate(class_4076 var1, class_1944 var2);

    void render(RenderContext var1);

    void renderCrumbling(RenderContext var1, List<CrumblingBlock> var2);

    void delete();

    @ApiStatus.NonExtendable
    public interface CrumblingBlock {
        class_2338 pos();

        @Range(from = 0L, to = 9L)
        int progress();

        List<Instance> instances();
    }
}
