package com.zurrtum.create.client.flywheel.impl.event;

import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import net.minecraft.class_4184;
import net.minecraft.class_4599;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public record RenderContextImpl(
    class_761 renderer, class_638 level, class_4599 buffers, Matrix4fc modelView, Matrix4fc projection, Matrix4fc viewProjection,
    class_4184 camera, float partialTick
) implements RenderContext {
    public static RenderContextImpl create(
        class_761 renderer,
        class_638 level,
        class_4599 buffers,
        Matrix4fc modelView,
        Matrix4f projection,
        class_4184 camera,
        float partialTick
    ) {
        Matrix4f viewProjection = new Matrix4f(projection);
        viewProjection.mul(modelView);

        return new RenderContextImpl(renderer, level, buffers, modelView, projection, viewProjection, camera, partialTick);
    }
}
