package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.class_11515;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import net.minecraft.class_9799;
import org.jetbrains.annotations.UnknownNullability;

class MeshEmitter implements class_4588 {
    private final class_11515 renderType;
    private final class_9799 byteBufferBuilder;
    @UnknownNullability
    private class_287 bufferBuilder;

    private BakedModelBufferer.ResultConsumer resultConsumer;
    private boolean currentShade;

    MeshEmitter(class_11515 renderType) {
        this.renderType = renderType;
        this.byteBufferBuilder = new class_9799(renderType.method_72021());
    }

    public void prepare(BakedModelBufferer.ResultConsumer resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public void end() {
        if (bufferBuilder != null) {
            emit();
        }
        resultConsumer = null;
    }

    public class_287 unwrap(boolean shade) {
        prepareForGeometry(shade);
        return bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (bufferBuilder == null) {
            bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1590);
        } else if (shade != currentShade) {
            emit();
            bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1590);
        }

        currentShade = shade;
    }

    private void prepareForGeometry(class_777 quad) {
        prepareForGeometry(quad.comp_3725());
    }

    private void emit() {
        var data = bufferBuilder.method_60794();
        bufferBuilder = null;

        if (data != null) {
            resultConsumer.accept(renderType, currentShade, data);
            data.close();
        }
    }

    public void quad(
        class_4587.class_4665 pose,
        class_777 quad,
        float red,
        float green,
        float blue,
        float alpha,
        int light,
        int overlay,
        boolean readExistingColor
    ) {
        prepareForGeometry(quad);
        bufferBuilder.method_22920(
            pose,
            quad,
            new float[]{1.0F, 1.0F, 1.0F, 1.0F},
            red,
            green,
            blue,
            alpha,
            new int[]{light, light, light, light},
            overlay,
            readExistingColor
        );
    }

    @Override
    public void method_22919(class_4587.class_4665 pose, class_777 quad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        prepareForGeometry(quad);
        bufferBuilder.method_22919(pose, quad, red, green, blue, alpha, packedLight, packedOverlay);
    }

    @Override
    public void method_22920(
        class_4587.class_4665 pose,
        class_777 quad,
        float[] brightnesses,
        float red,
        float green,
        float blue,
        float alpha,
        int[] lights,
        int overlay,
        boolean readExistingColor
    ) {
        prepareForGeometry(quad);
        bufferBuilder.method_22920(pose, quad, brightnesses, red, green, blue, alpha, lights, overlay, readExistingColor);
    }

    @Override
    public class_4588 method_22912(float x, float y, float z) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22913(float u, float v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_60796(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22921(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22914(float normalX, float normalY, float normalZ) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }
}
