package com.zurrtum.create.client.foundation.blockEntity.behaviour.edgeInteraction;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.crafter.CrafterHelper;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_638;

public class EdgeInteractionRenderer {

    public static void tick(class_310 mc) {
        class_239 target = mc.field_1765;
        if (!(target instanceof class_3965 result))
            return;

        class_638 world = mc.field_1687;
        class_2338 pos = result.method_17777();
        class_1657 player = mc.field_1724;
        class_1799 heldItem = player.method_6047();

        if (player.method_5715())
            return;
        EdgeInteractionBehaviour behaviour = BlockEntityBehaviour.get(world, pos, EdgeInteractionBehaviour.TYPE);
        if (behaviour == null)
            return;
        if (!behaviour.requiredItem.test(heldItem.method_7909()))
            return;

        class_2350 face = result.method_17780();
        List<class_2350> connectiveSides = EdgeInteractionHandler.getConnectiveSides(world, pos, face, behaviour);
        if (connectiveSides.isEmpty())
            return;

        class_2350 closestEdge = connectiveSides.getFirst();
        double bestDistance = Double.MAX_VALUE;
        class_243 center = VecHelper.getCenterOf(pos);
        for (class_2350 direction : connectiveSides) {
            double distance = class_243.method_24954(direction.method_62675()).method_1020(target.method_17784().method_1020(center)).method_1033();
            if (distance > bestDistance)
                continue;
            bestDistance = distance;
            closestEdge = direction;
        }

        class_238 bb = EdgeInteractionHandler.getBB(pos, closestEdge);
        boolean hit = bb.method_1006(target.method_17784());
        class_243 offset = class_243.method_24954(closestEdge.method_62675()).method_1021(.5).method_1019(class_243.method_24954(face.method_62675()).method_1021(.469)).method_1019(VecHelper.CENTER_OF_ORIGIN);

        ValueBox box = new ValueBox(class_5244.field_39003, bb, pos).passive(!hit).transform(new EdgeValueBoxTransform(offset)).wideOutline();
        Outliner.getInstance().showOutline("edge", box).highlightFace(face);

        if (!hit)
            return;

        List<class_5250> tip = new ArrayList<>();
        tip.add(CreateLang.translateDirect("logistics.crafter.connected"));
        tip.add(CreateLang.translateDirect(CrafterHelper.areCraftersConnected(
            world,
            pos,
            pos.method_10093(closestEdge)
        ) ? "logistics.crafter.click_to_separate" : "logistics.crafter.click_to_merge"));
        Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
    }

    static class EdgeValueBoxTransform extends ValueBoxTransform.Sided {

        private final class_243 add;

        public EdgeValueBoxTransform(class_243 add) {
            this.add = add;
        }

        @Override
        protected class_243 getSouthLocation() {
            return class_243.field_1353;
        }

        @Override
        public class_243 getLocalOffset(class_1936 level, class_2338 pos, class_2680 state) {
            return add;
        }

        @Override
        public void rotate(class_1936 level, class_2338 pos, class_2680 state, class_4587 ms) {
            super.rotate(level, pos, state, ms);
        }

    }

}
