package com.zurrtum.create.client.foundation.gui;

import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.catnip.gui.TextureSheetSegment;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper.CustomRenderTarget;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_10444;
import net.minecraft.class_10799;
import net.minecraft.class_10868;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5481;
import net.minecraft.class_765;
import net.minecraft.class_8012;
import net.minecraft.class_811;
import net.minecraft.client.render.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public interface ScreenWithStencils {
    List<Pair<Boolean, Runnable>> items = new ArrayList<>();

    default void drawStretched(
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        int left,
        int top,
        int width,
        int height,
        int z,
        TextureSheetSegment tex
    ) {
        drawTexturedQuad(
            vertexConsumers,
            matrixStack,
            tex.getLocation(),
            left,
            top,
            z,
            tex.getStartX(),
            tex.getStartY(),
            width,
            height,
            tex.getWidth(),
            tex.getHeight(),
            256,
            256
        );
    }

    default void drawTexture(class_4597.class_4598 vertexConsumers, Matrix3x2f matrixStack, int x, int y, int z, TextureSheetSegment tex) {
        int width = tex.getWidth();
        int height = tex.getHeight();
        drawTexturedQuad(
            vertexConsumers,
            matrixStack,
            tex.getLocation(),
            x,
            y,
            z,
            tex.getStartX(),
            tex.getStartY(),
            width,
            height,
            width,
            height,
            256,
            256
        );
    }

    default void drawTexture(
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        class_2960 location,
        int x,
        int y,
        int z,
        float u,
        float v,
        int width,
        int height,
        int textureWidth,
        int textureHeight
    ) {
        drawTexturedQuad(vertexConsumers, matrixStack, location, x, y, z, u, v, width, height, width, height, textureWidth, textureHeight);
    }

    default void drawTexturedQuad(
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        class_2960 location,
        float x,
        float y,
        float z,
        float u,
        float v,
        int width,
        int height,
        int regionWidth,
        int regionHeight,
        int textureWidth,
        int textureHeight
    ) {
        float x2 = x + width;
        float y2 = y + height;
        float u1 = u / textureWidth;
        float u2 = (u + regionWidth) / textureWidth;
        float v1 = v / textureHeight;
        float v2 = (v + regionHeight) / textureHeight;
        class_1921 layer = PonderRenderTypes.getGuiTextured(location);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(layer);
        vertexConsumer.method_70815(matrixStack, x, y, z).method_22913(u1, v1).method_39415(-1);
        vertexConsumer.method_70815(matrixStack, x, y2, z).method_22913(u1, v2).method_39415(-1);
        vertexConsumer.method_70815(matrixStack, x2, y2, z).method_22913(u2, v2).method_39415(-1);
        vertexConsumer.method_70815(matrixStack, x2, y, z).method_22913(u2, v1).method_39415(-1);
    }

    default void fillGradient(
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        float startX,
        float startY,
        float endX,
        float endY,
        float z,
        int colorStart,
        int colorEnd
    ) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(PonderRenderTypes.getGui());
        vertexConsumer.method_70815(matrixStack, startX, startY, z).method_39415(colorStart);
        vertexConsumer.method_70815(matrixStack, startX, endY, z).method_39415(colorEnd);
        vertexConsumer.method_70815(matrixStack, endX, endY, z).method_39415(colorEnd);
        vertexConsumer.method_70815(matrixStack, endX, startY, z).method_39415(colorStart);
    }

    default void fill(
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        float startX,
        float startY,
        float endX,
        float endY,
        float z,
        int color
    ) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(PonderRenderTypes.getGui());
        vertexConsumer.method_70815(matrixStack, startX, startY, z).method_39415(color);
        vertexConsumer.method_70815(matrixStack, startX, endY, z).method_39415(color);
        vertexConsumer.method_70815(matrixStack, endX, endY, z).method_39415(color);
        vertexConsumer.method_70815(matrixStack, endX, startY, z).method_39415(color);
    }

    default void drawSelection(class_4597.class_4598 vertexConsumers, Matrix3x2f matrixStack, int x1, int y1, int x2, int y2, int z) {
        if (x1 < x2) {
            int i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            int i = y1;
            y1 = y2;
            y2 = i;
        }
        class_4588 vertexConsumer = vertexConsumers.getBuffer(PonderRenderTypes.getGuiInvert());
        vertexConsumer.method_70815(matrixStack, x1, y1, z).method_39415(-1);
        vertexConsumer.method_70815(matrixStack, x1, y2, z).method_39415(-1);
        vertexConsumer.method_70815(matrixStack, x2, y2, z).method_39415(-1);
        vertexConsumer.method_70815(matrixStack, x2, y1, z).method_39415(-1);
        vertexConsumer = vertexConsumers.getBuffer(PonderRenderTypes.getGuiTextHighlight());
        int blue = class_8012.field_52313;
        vertexConsumer.method_70815(matrixStack, x1, y1, z).method_39415(blue);
        vertexConsumer.method_70815(matrixStack, x1, y2, z).method_39415(blue);
        vertexConsumer.method_70815(matrixStack, x2, y2, z).method_39415(blue);
        vertexConsumer.method_70815(matrixStack, x2, y1, z).method_39415(blue);
    }

    default void renderWidget(class_342 widget, class_4597.class_4598 vertexConsumers, Matrix3x2f matrixStack, int z) {
        if (widget.method_1885()) {
            BiFunction<String, Integer, class_5481> renderTextProvider = widget.field_2099;
            int i = widget.field_2094 ? widget.field_2100 : widget.field_2098;
            int firstCharacterIndex = widget.field_2103;
            class_327 textRenderer = widget.field_2105;
            class_2561 placeholder = widget.field_41100;
            String suggestion = widget.field_2106;
            boolean textShadow = widget.field_60438;
            int textX = widget.field_60435;
            int textY = widget.field_60436;
            int cursor = widget.method_1881();
            String text = widget.method_1882();
            boolean focused = widget.method_25370();
            int width = widget.method_25368();

            String string = textRenderer.method_27523(text.substring(firstCharacterIndex), widget.method_1859());
            int j = cursor - firstCharacterIndex;
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = focused && (class_156.method_658() - widget.field_45352) / 300L % 2L == 0L && bl;
            int k = textX;
            int l = class_3532.method_15340(widget.field_2101 - firstCharacterIndex, 0, string.length());
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                class_5481 orderedText = renderTextProvider.apply(string2, firstCharacterIndex);
                drawText(vertexConsumers, matrixStack, textRenderer, orderedText, k, textY, z, i, textShadow);
                k += textRenderer.method_30880(orderedText) + 1;
            }

            boolean bl3 = cursor < text.length() || text.length() >= widget.method_1861();
            int m = k;
            if (!bl) {
                m = j > 0 ? textX + width : textX;
            } else if (bl3) {
                m = k - 1;
                k--;
            }

            if (!string.isEmpty() && bl && j < string.length()) {
                drawText(
                    vertexConsumers,
                    matrixStack,
                    textRenderer,
                    renderTextProvider.apply(string.substring(j), cursor),
                    k,
                    textY,
                    z,
                    i,
                    textShadow
                );
            }

            if (placeholder != null && string.isEmpty() && !focused) {
                drawText(vertexConsumers, matrixStack, textRenderer, placeholder, k, textY, z, i, true);
            }

            if (!bl3 && suggestion != null) {
                drawText(vertexConsumers, matrixStack, textRenderer, suggestion, m - 1, textY, z, class_8012.field_44941, textShadow);
            }

            if (bl2) {
                if (bl3) {
                    fill(vertexConsumers, matrixStack, m, textY - 1, m + 1, textY + 1 + 9, z, -3092272);
                } else {
                    drawText(vertexConsumers, matrixStack, textRenderer, "_", m, textY, z, i, textShadow);
                }
            }

            if (l != j) {
                int n = textX + textRenderer.method_1727(string.substring(0, l));
                int x = widget.method_46426();
                drawSelection(vertexConsumers, matrixStack, Math.min(m, x + width), textY - 1, Math.min(n - 1, x + width), textY + 1 + 9, z);
            }
        }
    }

    default void drawItem(
        class_310 client,
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        class_1799 stack,
        int x,
        int y,
        @Nullable Runnable after
    ) {
        class_4587 ms = new class_4587();
        ms.method_46416(8 * matrixStack.m00 + matrixStack.m20 + x, 8 * matrixStack.m11 + matrixStack.m21 + y, 0);
        ms.method_22905(16 * matrixStack.m00, -16 * matrixStack.m11, 16 * matrixStack.m00);
        class_10444 state = new class_10444();
        state.field_55337 = class_811.field_4317;
        client.method_65386().method_65596(state, stack, class_811.field_4317, null, null, 0);
        items.add(Pair.of(
            state.method_65608(), () -> {
                state.method_65604(ms, vertexConsumers, class_765.field_32767, class_4608.field_21444);
                if (after != null) {
                    after.run();
                }
            }
        ));
    }

    default void drawText(
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        class_327 textRenderer,
        String string,
        int x,
        int y,
        int z,
        int color,
        boolean shadow
    ) {
        textRenderer.method_27521(
            string,
            x,
            y,
            color,
            shadow,
            new Matrix4f().translate(matrixStack.m20, matrixStack.m21, z),
            vertexConsumers,
            class_327.class_6415.field_33993,
            0,
            class_765.field_32767
        );
    }

    default void drawText(
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        class_327 textRenderer,
        class_2561 string,
        int x,
        int y,
        int z,
        int color,
        boolean shadow
    ) {
        textRenderer.method_27522(
            string,
            x,
            y,
            color,
            shadow,
            new Matrix4f().translate(matrixStack.m20, matrixStack.m21, z),
            vertexConsumers,
            class_327.class_6415.field_33993,
            0,
            class_765.field_32767
        );
    }

    default void drawText(
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        class_327 textRenderer,
        class_5481 string,
        int x,
        int y,
        int z,
        int color,
        boolean shadow
    ) {
        textRenderer.method_22942(
            string,
            x,
            y,
            color,
            shadow,
            new Matrix4f().translate(matrixStack.m20, matrixStack.m21, z),
            vertexConsumers,
            class_327.class_6415.field_33993,
            0,
            class_765.field_32767
        );
    }

    default void useItemsProjectionMatrix(class_310 client) {
        class_1041 window = client.method_22683();
        RenderSystem.setProjectionMatrix(
            client.field_1773.field_59965.field_60041.method_71092(
                (float) window.method_4489() / window.method_4495(),
                (float) window.method_4506() / window.method_4495()
            ),
            class_10366.field_54954
        );
        RenderSystem.getModelViewStack().popMatrix();
    }

    default void useGuiProjectionMatrix(class_310 client) {
        RenderSystem.setProjectionMatrix(client.field_1773.field_59965.field_60040.field_60060, class_10366.field_54954);
        RenderSystem.getModelViewStack().pushMatrix().translate(0, 0, -11000);
    }

    default void prepareFrameBuffer(class_310 client, class_4597.class_4598 vertexConsumers) {
        vertexConsumers.method_22993();
        CustomRenderTarget framebuffer = UIRenderHelper.framebuffer;
        int depthAttachmentId = ((class_10868) framebuffer.method_30278()).method_68427();
        int frameBufferId = ((class_10868) framebuffer.method_30277()).field_57885.get(depthAttachmentId);
        GlStateManager._glBindFramebuffer(GlConst.GL_FRAMEBUFFER, frameBufferId);
        GlStateManager._disableScissorTest();
        GL11.glClearDepth(1);
        GL11.glClearColor(0, 0, 0, 0);
        GlStateManager._depthMask(true);
        GlStateManager._colorMask(true, true, true, true);
        GlStateManager._clear(GlConst.GL_DEPTH_BUFFER_BIT | GlConst.GL_COLOR_BUFFER_BIT);
        AbstractSimiContainerScreen.backupProjectionMatrix();
        useGuiProjectionMatrix(client);
        RenderSystem.outputColorTextureOverride = framebuffer.method_71639();
        RenderSystem.outputDepthTextureOverride = framebuffer.method_71640();
    }

    default void endFrameBuffer(class_310 client, class_4597.class_4598 vertexConsumers, class_332 graphics) {
        draw(client, vertexConsumers);
        RenderSystem.outputColorTextureOverride = null;
        RenderSystem.outputDepthTextureOverride = null;
        RenderSystem.getModelViewStack().popMatrix();
        AbstractSimiContainerScreen.restoreProjectionMatrix();
        GlStateManager._glBindFramebuffer(GlConst.GL_FRAMEBUFFER, 0);
        class_1041 window = client.method_22683();
        graphics.field_59826.method_71996(new class_11241(
            class_10799.field_56883,
            class_11231.method_70900(UIRenderHelper.framebuffer.method_71639()),
            new Matrix3x2f(),
            0,
            0,
            window.method_4486(),
            window.method_4502(),
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            null,
            null
        ));
    }

    default void draw(class_310 client, class_4597.class_4598 vertexConsumers) {
        vertexConsumers.method_22993();
        if (items.isEmpty()) {
            return;
        }
        useItemsProjectionMatrix(client);
        class_308 lighting = client.field_1773.method_71114();
        lighting.method_71034(class_308.class_11274.field_60027);
        boolean blockLight = true;
        for (Pair<Boolean, Runnable> task : items) {
            if (task.getFirst()) {
                if (!blockLight) {
                    lighting.method_71034(class_308.class_11274.field_60027);
                    blockLight = true;
                }
            } else if (blockLight) {
                lighting.method_71034(class_308.class_11274.field_60026);
                blockLight = false;
            }
            task.getSecond().run();
            vertexConsumers.method_22993();
        }
        useGuiProjectionMatrix(client);
        items.clear();
    }

    default void startStencil(
        class_310 client,
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        float x,
        float y,
        float w,
        float h
    ) {
        draw(client, vertexConsumers);
        GL11.glEnable(GL11.GL_STENCIL_TEST);
        GL11.glStencilOp(GL11.GL_REPLACE, GL11.GL_KEEP, GL11.GL_KEEP);
        GL11.glStencilFunc(GL11.GL_NEVER, 1, 0xFF);
        fillGradient(vertexConsumers, matrixStack, x, y, x + w, y + h, 0, 0xFF000000, 0xFF000000);
        vertexConsumers.method_22994(PonderRenderTypes.getGui());
        GL11.glStencilOp(GL11.GL_KEEP, GL11.GL_KEEP, GL11.GL_KEEP);
        GL11.glStencilFunc(GL11.GL_EQUAL, 1, 0xFF);
    }

    default void endStencil(
        class_310 client,
        class_4597.class_4598 vertexConsumers,
        Matrix3x2f matrixStack,
        float x,
        float y,
        float w,
        float h
    ) {
        draw(client, vertexConsumers);
        GL11.glStencilOp(GL11.GL_REPLACE, GL11.GL_KEEP, GL11.GL_KEEP);
        GL11.glStencilFunc(GL11.GL_NEVER, 0, 0xFF);
        fillGradient(vertexConsumers, matrixStack, x, y, x + w, y + h, 0, 0xFF000000, 0xFF000000);
        vertexConsumers.method_22994(PonderRenderTypes.getGui());
        GL11.glDisable(GL11.GL_STENCIL_TEST);
    }
}
